/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import pregenerator.ChunkPregenerator;

public class BiomeColors
implements IResourceManagerReloadListener {
    public static final BiomeColors INSTANCE = new BiomeColors();
    private Map<ResourceLocation, Integer> biomeColors = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());
    private Set<ResourceLocation> isGuessed = Collections.synchronizedSet(new ObjectOpenHashSet());

    public void func_110549_a(IResourceManager manager) {
        HashMap<ResourceLocation, Integer> biomeColors = new HashMap<ResourceLocation, Integer>();
        HashMap elements = new HashMap();
        JsonParser parser = new JsonParser();
        try {
            for (IResource resource : manager.func_135056_b(new ResourceLocation("chunkpregenerator", "minimap/biomes/biome_colors.json"))) {
                JsonObject obj = parser.parse(new JsonReader((Reader)new InputStreamReader(resource.func_110527_b()))).getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    JsonObject colorControl = JsonUtils.func_151210_l((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                    int red = JsonUtils.func_151215_f((JsonElement)colorControl.get("red"), (String)"red");
                    int green = JsonUtils.func_151215_f((JsonElement)colorControl.get("green"), (String)"green");
                    int blue = JsonUtils.func_151215_f((JsonElement)colorControl.get("blue"), (String)"blue");
                    biomeColors.put(new ResourceLocation((String)entry.getKey()), BiomeColors.color(red, green, blue));
                    elements.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.biomeColors = Collections.synchronizedMap(biomeColors);
        this.isGuessed = Collections.synchronizedSet(new HashSet());
        ChunkPregenerator.LOGGER.info("Loaded [" + biomeColors.size() + "] Biome Colors");
    }

    public boolean isColorGuessed(ResourceLocation id) {
        return this.isGuessed.contains(id);
    }

    public int getBiomeColor(ResourceLocation biomeId, Biome holder) {
        return this.biomeColors.computeIfAbsent(biomeId, T -> {
            this.isGuessed.add(biomeId);
            return BiomeColors.guessBiomeColor(holder);
        });
    }

    private static int guessBiomeColor(Biome biome) {
        Set types = BiomeDictionary.getTypes((Biome)biome);
        if (types.contains(BiomeDictionary.Type.NETHER)) {
            return BiomeColors.color(255, 0, 0);
        }
        if (types.contains(BiomeDictionary.Type.RIVER) || types.contains(BiomeDictionary.Type.OCEAN)) {
            return BiomeColors.color(13, BiomeColors.lerpValue(100, 140, 200, MathHelper.func_76131_a((float)biome.func_185353_n(), (float)-1.0f, (float)1.0f)), 228);
        }
        if (types.contains(BiomeDictionary.Type.FOREST) || types.contains(BiomeDictionary.Type.JUNGLE)) {
            return BiomeColors.color(8, 142, 47);
        }
        if (types.contains(BiomeDictionary.Type.SANDY)) {
            return BiomeColors.color(250, 215, 24);
        }
        if (types.contains(BiomeDictionary.Type.HILLS) || types.contains(BiomeDictionary.Type.MOUNTAIN)) {
            return BiomeColors.color(69, 69, 69);
        }
        return BiomeColors.color(139, 139, 139);
    }

    private static int lerpValue(int min, int start, int max, float lerp) {
        return (int)(lerp <= 0.0f ? BiomeColors.lerp(lerp + 1.0f, min, start) : BiomeColors.lerp(lerp, start, max));
    }

    private static double lerp(double value, double min, double max) {
        return min + value * (max - min);
    }

    private static int color(int r, int g, int b) {
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }
}

