/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world.data;

import java.awt.Color;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.texture.DisplayTexture;
import pregenerator.impl.client.preview.texture.MoveableTexture;
import pregenerator.impl.client.preview.world.IHeightMap;
import pregenerator.impl.client.preview.world.data.BaseChunkData;
import pregenerator.impl.client.utils.BiomeColors;

public class ChunkData
extends BaseChunkData {
    public static final int[][] DATA = ChunkData.createArray();
    byte[] blockIds = new byte[256];
    int[] biomeIds = new int[256];
    int[] height = new int[256];
    int[] blockColors = new int[256];
    int[] biomeColors = new int[256];
    int[] heightColors = new int[256];

    protected ChunkData() {
    }

    public ChunkData(Chunk chunk, boolean isFinished) {
        super(chunk, isFinished);
        boolean roof;
        World world = chunk.func_177412_p();
        int xPos = chunk.field_76635_g * 16;
        int zPos = chunk.field_76647_h * 16;
        int heighest = chunk.func_76625_h() + 16;
        boolean bl = roof = !world.field_73011_w.func_191066_m();
        if (heighest <= 5 || roof) {
            heighest = chunk.func_177412_p().func_181545_F() + 1;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                pos.func_181079_c(xPos + x, 64, zPos + z);
                Biome biome = chunk.func_177411_a((BlockPos)pos, world.func_72959_q());
                pos.func_185336_p(heighest);
                this.getFirstBlock(chunk, pos);
                int index = z * 16 + x;
                IBlockState state = chunk.func_177435_g((BlockPos)pos);
                this.biomeIds[index] = Biome.func_185362_a((Biome)biome);
                this.blockIds[index] = (byte)((state.func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)pos) ? MapColor.field_151660_b.field_76290_q : state.func_185904_a().func_151565_r().field_76290_q) << 2);
                this.blockColors[index] = MapColor.field_76281_a[this.blockIds[index] >> 2].func_151643_b(0);
                pos.func_185336_p(heighest);
                this.height[index] = this.getHeightMapHeight(chunk, pos);
                this.heightColors[index] = ChunkData.color((float)this.height[index] / 256.0f);
                this.biomeColors[index] = BiomeColors.INSTANCE.getBiomeColor(biome.getRegistryName(), biome);
                this.biomeColors[index] = ChunkData.mix(this.biomeColors[index], this.heightColors[index], 0.35f);
            }
        }
    }

    public static ChunkData createDataFromBuffer(ByteBuffer chunkData, ByteBuffer heightData) throws IOException {
        int i;
        ChunkData data = new ChunkData();
        data.x = chunkData.getInt();
        data.z = chunkData.getInt();
        byte flags = chunkData.get();
        data.slimeChunk = (flags & 1) != 0;
        data.isFinished = (flags & 2) != 0;
        chunkData.get(data.blockIds);
        for (i = 0; i < 256; ++i) {
            int colorData = data.blockIds[i] & 0xFF;
            int color = MapColor.field_76281_a[colorData >> 2].func_151643_b(0);
            if ((colorData & 3) == 1) {
                color = ChunkData.darker(color, 0.8f);
            } else if ((colorData & 3) == 2) {
                color = ChunkData.brighter(color, 0.8f);
            }
            data.blockColors[i] = color;
        }
        for (i = 0; i < 256; ++i) {
            data.biomeIds[i] = chunkData.getInt();
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int index = z * 16 + x;
                pos.func_181079_c(data.x * 16 + x, 64, data.z * 16 + z);
                Biome subBiome = (Biome)((ForgeRegistry)ForgeRegistries.BIOMES).getValue(data.biomeIds[index]);
                data.biomeColors[index] = BiomeColors.INSTANCE.getBiomeColor(subBiome.getRegistryName(), subBiome);
            }
        }
        if (heightData.get() <= 0) {
            data.height = new int[0];
            Arrays.fill(data.heightColors, -16777216);
        } else {
            for (int i2 = 0; i2 < data.height.length; ++i2) {
                int value;
                data.height[i2] = value = heightData.get() + 128;
                data.heightColors[i2] = ChunkData.color((float)value / 256.0f);
                data.biomeColors[i2] = ChunkData.mix(data.biomeColors[i2], data.heightColors[i2], 0.35f);
            }
        }
        return data;
    }

    public int[] getData(int view) {
        if ((view & Integer.MIN_VALUE) != 0) {
            return DATA[this.isFinished ? 1 : 0];
        }
        switch (view) {
            case 1: {
                return this.biomeColors;
            }
            case 2: {
                return this.heightColors;
            }
        }
        return this.blockColors;
    }

    @Override
    public int getHeight(int x, int z) {
        return this.height[z * 16 + x];
    }

    @Override
    public int getBiome(int x, int z) {
        return this.biomeIds[z * 16 + x];
    }

    @Override
    public void addToTexture(MoveableTexture texture, int view, int size) {
        texture.addChunkData(this, size, view);
    }

    @Override
    public void updateHeightMap(IHeightMap map) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int xPos = this.x * 16 + x;
                int zPos = this.z * 16 + z;
                int index = z * 16 + x;
                if (this.blockIds[index] >> 2 == MapColor.field_151660_b.field_76290_q) continue;
                if (this.isDarker(xPos, zPos, map)) {
                    this.blockIds[index] = (byte)(this.blockIds[index] & 0xFFFFFFFC | 1);
                } else {
                    if (!this.isBrigther(xPos, zPos, map)) continue;
                    this.blockIds[index] = (byte)(this.blockIds[index] & 0xFFFFFFFC | 2);
                }
                int colorData = this.blockIds[index] & 0xFF;
                int color = MapColor.field_76281_a[colorData >> 2].func_151643_b(0);
                if ((colorData & 3) == 1) {
                    color = ChunkData.darker(color, 0.8f);
                } else if ((colorData & 3) == 2) {
                    color = ChunkData.brighter(color, 0.8f);
                }
                this.blockColors[index] = color;
            }
        }
    }

    @Override
    public void storeInHeightMap(IHeightMap map) {
        map.storeHeightData(this.x, this.z, this.height);
    }

    @Override
    public void handleTask(FileChannel chunkData, FileChannel heightData, IFileProvider provider) throws IOException {
        int i;
        provider.setFinished(this.x, this.z, this.isFinished);
        ByteBuffer buffer = ByteBuffer.allocate((int)IFileProvider.FileType.CHUNK_DATA.getOffset());
        buffer.put((byte)1);
        buffer.putInt(this.x).putInt(this.z).put((byte)((this.slimeChunk ? 1 : 0) | (this.isFinished ? 2 : 0)));
        buffer.put(this.blockIds);
        for (i = 0; i < 256; ++i) {
            buffer.putInt(this.biomeIds[i]);
        }
        buffer.flip();
        chunkData.position(provider.getOrCreateIndex(this.x, this.z, IFileProvider.FileType.CHUNK_DATA));
        chunkData.write(buffer);
        buffer = ByteBuffer.allocate((int)IFileProvider.FileType.HEIGHT_DATA.getOffset());
        buffer.put((byte)1);
        for (i = 0; i < 256; ++i) {
            buffer.put((byte)(this.height[i] - 128));
        }
        buffer.flip();
        heightData.position(provider.getOrCreateIndex(this.x, this.z, IFileProvider.FileType.HEIGHT_DATA));
        heightData.write(buffer);
    }

    public static int color(float rgba) {
        int value = (int)(rgba * 255.0f + 0.5f);
        return 0xFF000000 | value << 16 | value << 8 | value;
    }

    public static int mix(int from, int to, float factor) {
        float weight0 = 1.0f - factor;
        float weight1 = factor;
        int r = (int)((float)(from >> 16 & 0xFF) * weight0 + (float)(to >> 16 & 0xFF) * weight1);
        int g = (int)((float)(from >> 8 & 0xFF) * weight0 + (float)(to >> 8 & 0xFF) * weight1);
        int b = (int)((float)(from & 0xFF) * weight0 + (float)(to & 0xFF) * weight1);
        int a = (int)((float)(from >> 24 & 0xFF) * weight0 + (float)(to >> 24 & 0xFF) * weight1);
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    static int[][] createArray() {
        int[][] data = new int[2][256];
        Arrays.fill(data[0], DisplayTexture.sortColors(Color.RED.darker().getRGB()));
        Arrays.fill(data[1], DisplayTexture.sortColors(Color.GREEN.getRGB()));
        return data;
    }
}

