/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.data.tasks;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import pregenerator.impl.client.preview.ScreenshotScreen;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.data.ITask;
import pregenerator.impl.client.preview.texture.DisplayTexture;
import pregenerator.impl.client.preview.world.ChunkCache;
import pregenerator.impl.client.preview.world.WorldData;
import pregenerator.impl.client.preview.world.data.ChunkData;
import pregenerator.impl.client.utils.StructureIcons;
import pregenerator.impl.misc.FilePos;

public class CreateScreenshotTask
implements Runnable {
    WorldData data;
    File folder;
    ScreenshotScreen.ScreenshotEntry entry;
    Set<String> spammyStructures;

    public CreateScreenshotTask(WorldData data, File folder, ScreenshotScreen.ScreenshotEntry entry, Set<String> spammyStructures) {
        this.data = data;
        this.folder = folder;
        this.entry = entry;
        this.spammyStructures = spammyStructures;
    }

    @Override
    public void run() {
        Graphics2D g;
        int offset;
        int size = this.data.getRadius() * 32;
        BufferedImage image = new BufferedImage(size, size, 2);
        ChunkCache cache = this.data.getCache();
        FileChannel chunkData = cache.getChunkData();
        FileChannel heightData = cache.getHeightData();
        int total = cache.getStored();
        for (int i = 0; i < total; i += 1024) {
            try {
                this.readChunks(image, i, MathHelper.func_76125_a((int)(total - i), (int)0, (int)1024), chunkData, heightData);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.entry.showSlimeChunks()) {
            offset = this.data.getRadius() * 16;
            g = image.createGraphics();
            g.setColor(new Color(-2147418113, true));
            for (long pos : this.data.getSlimeChunks()) {
                int minX = FilePos.getX(pos) * 16 + offset;
                int minY = FilePos.getZ(pos) * 16 + offset;
                g.fillRect(minX, minY, 16, 16);
            }
            g.dispose();
        }
        if (this.entry.showStructures()) {
            offset = this.data.getRadius() * 16;
            g = image.createGraphics();
            int radius = this.data.getRadius() * 16;
            Map<String, Set<StructureStart>> references = this.data.getStructures();
            references.forEach((T, S) -> {
                String id = T.toLowerCase(Locale.ROOT);
                if (this.spammyStructures.contains(id) && !this.entry.showStructures() || StructureIcons.INSTANCE.isHidden(id)) {
                    return;
                }
                for (StructureStart start : S) {
                    StructureBoundingBox bounds = start.func_75071_a();
                    int minX = bounds.field_78897_a + bounds.func_78883_b() / 2;
                    int minZ = bounds.field_78896_c + bounds.func_78880_d() / 2;
                    if (minX - 16 <= -radius || minX + 16 >= radius || minZ - 16 <= -radius || minZ + 16 >= radius) continue;
                    g.setColor(new Color(-2141562278, true));
                    g.fillRect(minX + offset - 16, minZ + offset - 16, 32, 32);
                    g.setColor(Color.RED);
                    g.drawString((String)T, minX + offset - 16, minZ + offset - 16);
                }
            });
            references.forEach((T, S) -> {
                String id = T.toLowerCase(Locale.ROOT);
                if (this.spammyStructures.contains(id) && !this.entry.showStructures() || StructureIcons.INSTANCE.isHidden(id)) {
                    return;
                }
                TextureAtlasSprite sprite = StructureIcons.INSTANCE.getSprite(id);
                int width = sprite.func_94211_a();
                int height = sprite.func_94216_b();
                BufferedImage icon = new BufferedImage(width, height, 2);
                icon.setRGB(0, 0, width, height, sprite.func_147965_a(0)[0], 0, width);
                for (StructureStart start : S) {
                    StructureBoundingBox bounds = start.func_75071_a();
                    int minX = bounds.field_78897_a + bounds.func_78883_b() / 2;
                    int minZ = bounds.field_78896_c + bounds.func_78880_d() / 2;
                    if (minX - 16 <= -radius || minX + 16 >= radius || minZ - 16 <= -radius || minZ + 16 >= radius) continue;
                    g.drawImage(icon, minX + offset - 16, minZ + offset - 16, 32, 32, null);
                }
            });
            g.dispose();
        }
        try {
            ImageIO.write((RenderedImage)image, "png", new File(this.folder, this.data.getScreenName(this.entry.getType(), this.entry.hasOverlays())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int combine(int a, int b, int g, int r) {
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | (r & 0xFF) << 0;
    }

    public static int getA(int color) {
        return color >> 24 & 0xFF;
    }

    public static int getR(int color) {
        return color >> 0 & 0xFF;
    }

    public static int getG(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getB(int color) {
        return color >> 16 & 0xFF;
    }

    public void readChunks(BufferedImage image, long startValue, long size, FileChannel chunkData, FileChannel heightData) throws IOException {
        if (size <= 0L) {
            return;
        }
        int voidColor = this.data.hasSkyLight() ? 0 : -16777216;
        int offset = this.data.getRadius() * 16;
        ByteBuffer chunkBuffer = ITask.readBytes(chunkData, startValue * IFileProvider.FileType.CHUNK_DATA.getOffset(), size * IFileProvider.FileType.CHUNK_DATA.getOffset());
        ByteBuffer heightBuffer = ITask.readBytes(heightData, startValue * IFileProvider.FileType.HEIGHT_DATA.getOffset(), size * IFileProvider.FileType.HEIGHT_DATA.getOffset());
        int k = 0;
        while ((long)k < size) {
            chunkBuffer.position((int)((long)k * IFileProvider.FileType.CHUNK_DATA.getOffset()));
            if (chunkBuffer.get() > 0) {
                heightBuffer.position((int)((long)k * IFileProvider.FileType.HEIGHT_DATA.getOffset()));
                ChunkData data = ChunkData.createDataFromBuffer(chunkBuffer, heightBuffer);
                int posX = data.getX() * 16 + offset;
                int posZ = data.getZ() * 16 + offset;
                int[] pixels = data.getData(this.entry.getType());
                for (int yPos = 0; yPos < 16; ++yPos) {
                    for (int xPos = 0; xPos < 16; ++xPos) {
                        int color = pixels[yPos * 16 + xPos];
                        image.setRGB(posX + xPos, posZ + yPos, DisplayTexture.unsortColors((0xFF000000 | color) == -7631989 ? voidColor : color));
                    }
                }
            }
            ++k;
        }
    }
}

