/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.data;

import com.google.common.cache.Cache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Deque;
import net.minecraft.util.math.MathHelper;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.data.ITask;
import pregenerator.impl.client.preview.world.data.IChunkData;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.Tuple;

public class Tasks {

    public static class FetchHeightData
    implements ITask {
        int x;
        int y;
        int[] data = new int[0];
        boolean done = false;

        public FetchHeightData(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void handleTask(FileChannel chunkData, FileChannel heightData, IFileProvider provider) throws IOException {
            ByteBuffer buffer = ITask.readBytes(heightData, provider.getIndex(this.x, this.y, IFileProvider.FileType.HEIGHT_DATA), IFileProvider.FileType.HEIGHT_DATA.getOffset());
            if (buffer.get() <= 0) {
                this.done = true;
                return;
            }
            int[] fetch = new int[256];
            for (int i = 0; i < fetch.length; ++i) {
                fetch[i] = buffer.get() + 128;
            }
            this.data = fetch;
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }

        public int[] getHeightData() {
            return this.data;
        }
    }

    public static class MassFetchTask
    implements ITask {
        Deque<Tuple<IChunkData, Integer>> result;
        int view;
        IFileProvider.FileType chunkType;

        public MassFetchTask(Deque<Tuple<IChunkData, Integer>> result, int view) {
            this.result = result;
            this.view = view;
            this.chunkType = IFileProvider.FileType.CHUNK_DATA;
        }

        @Override
        public void handleTask(FileChannel chunkData, FileChannel heightData, IFileProvider provider) throws IOException {
            int total = provider.getStored();
            for (int i = 0; i < total; i += 1024) {
                this.gatherChunks(i, MathHelper.func_76125_a((int)(total - i), (int)0, (int)1024), chunkData, heightData);
            }
        }

        public void gatherChunks(long startValue, long size, FileChannel chunkData, FileChannel heightData) throws IOException {
            if (size <= 0L) {
                return;
            }
            ByteBuffer chunkBuffer = ITask.readBytes(chunkData, startValue * IFileProvider.FileType.CHUNK_DATA.getOffset(), size * IFileProvider.FileType.CHUNK_DATA.getOffset());
            ByteBuffer heigthBuffer = ITask.readBytes(heightData, startValue * IFileProvider.FileType.HEIGHT_DATA.getOffset(), size * IFileProvider.FileType.HEIGHT_DATA.getOffset());
            int k = 0;
            while ((long)k < size) {
                chunkBuffer.position((int)((long)k * IFileProvider.FileType.CHUNK_DATA.getOffset()));
                heigthBuffer.position((int)((long)k * IFileProvider.FileType.HEIGHT_DATA.getOffset()));
                if (chunkBuffer.get() > 0) {
                    this.result.add(new Tuple<IChunkData, Integer>(this.chunkType.createData(chunkBuffer, heigthBuffer), this.view));
                }
                ++k;
            }
        }
    }

    public static class FetchChunkTask
    implements ITask {
        int chunkX;
        int chunkY;
        IChunkData data;
        boolean done = false;
        IFileProvider.FileType type;
        Cache<Long, IChunkData> cache;

        public FetchChunkTask(int x, int z, Cache<Long, IChunkData> data) {
            this.cache = data;
            this.chunkX = x;
            this.chunkY = z;
            this.type = IFileProvider.FileType.CHUNK_DATA;
        }

        @Override
        public void handleTask(FileChannel chunkData, FileChannel heightData, IFileProvider provider) throws IOException {
            if (!provider.hasIndex(this.chunkX, this.chunkY)) {
                this.data = null;
                this.done = true;
                return;
            }
            ByteBuffer chunkBuffer = ITask.readBytes(chunkData, provider.getIndex(this.chunkX, this.chunkY, this.type), this.type.getOffset());
            if (chunkBuffer.get() <= 0) {
                this.data = null;
                this.done = true;
                return;
            }
            this.data = this.type.createData(chunkBuffer, ITask.readBytes(heightData, provider.getIndex(this.chunkX, this.chunkY, IFileProvider.FileType.HEIGHT_DATA), IFileProvider.FileType.HEIGHT_DATA.getOffset()));
            this.done = true;
            if (this.data != null) {
                this.cache.put((Object)FilePos.asLong(this.chunkX, this.chunkY), (Object)this.data);
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public IChunkData getData() {
            return this.data;
        }
    }
}

