/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.data;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.World;
import pregenerator.impl.client.preview.data.ITask;
import pregenerator.impl.client.preview.world.ChunkCache;
import pregenerator.impl.client.preview.world.WorldSeed;

public class MapManager
implements Runnable {
    Thread thread;
    boolean running = true;
    Map<Integer, ChunkCache> dimensions = new ConcurrentHashMap<Integer, ChunkCache>();

    public MapManager() {
        this.thread = new Thread((Runnable)this, "FileManager");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.thread.interrupt();
            while (this.thread.isAlive()) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
            this.thread = null;
            this.dimensions.values().forEach(ChunkCache::shutdown);
            this.dimensions.clear();
            System.gc();
        }
        catch (Exception e) {
            if (!this.running) {
                return;
            }
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.dimensions.values().forEach(ChunkCache::update);
                Thread.sleep(1L);
            }
            catch (Exception e) {
                if (!this.running) {
                    return;
                }
                e.printStackTrace();
            }
        }
    }

    public ChunkCache createDimension(int dim) {
        return this.dimensions.computeIfAbsent(dim, T -> {
            try {
                Path folder = WorldSeed.getMapFolder();
                if (Files.notExists(folder, new LinkOption[0])) {
                    Files.createDirectories(folder, new FileAttribute[0]);
                }
                return new ChunkCache(folder.resolve("Chunk_DIM_" + T), folder.resolve("Height_DIM_" + T));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    public void clearData() {
        this.dimensions.values().forEach(ChunkCache::shutdown);
        this.dimensions.clear();
    }

    public void removeDimension(int dimension) {
        ChunkCache cache = this.dimensions.remove(dimension);
        if (cache == null) {
            return;
        }
        cache.shutdown();
    }

    public void addTask(World world, ITask task) {
        this.addTask(world.field_73011_w.getDimension(), task);
    }

    public void addTask(int dim, ITask task) {
        ChunkCache data = this.dimensions.get(dim);
        if (data == null) {
            return;
        }
        data.addTask(task);
    }
}

