/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.comp.PregenButton;
import pregenerator.base.impl.gui.comp.PregenCheckBox;
import pregenerator.base.impl.gui.comp.PregenList;

public class ScreenshotScreen
extends BasePregenScreen {
    PregenList.ListState<Entry> elements = new PregenList.ListState((PregenList.ListEntry[])new Entry[0]).setRowWidth(360).setItemWidth(90).setItemHeight(83).setTopPadding(30).setFrame(true);
    PregenCheckBox.CheckboxState showFrame = new PregenCheckBox.CheckboxState(true, true, TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_frame")).withStateListener(this.elements::setFrame);
    GuiScreen parent;
    PregenButton apply;
    Consumer<List<ScreenshotEntry>> result;

    public ScreenshotScreen(GuiScreen parent, Collection<Integer> dims, int currentlyActive, int mode, Consumer<List<ScreenshotEntry>> result) {
        this.parent = parent;
        this.result = result;
        for (int dim : dims) {
            this.elements.add(new Entry[]{new Entry(dim, 0, dim == currentlyActive && mode == 0)});
            this.elements.add(new Entry[]{new Entry(dim, 1, dim == currentlyActive && mode == 1)});
            this.elements.add(new Entry[]{new Entry(dim, 2, dim == currentlyActive && mode == 2)});
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.list(this.elements);
        this.button(22, -28, 80, 20, Align.CENTER, Align.END, TextUtil.translate("gui.chunk_pregen.retrogen_selector.back"), T -> this.onClose());
        this.apply = this.button(-102, -28, 120, 20, Align.CENTER, Align.END, TextUtil.translate("gui.chunk_pregen.preview.screenshot.create"), this::apply);
        this.checkbox(105, -25, 14, 14, Align.CENTER, Align.END, this.showFrame);
    }

    @Override
    public void tick() {
        super.tick();
        this.apply.field_146124_l = this.hasAny();
    }

    protected boolean hasAny() {
        for (Entry entry : this.elements.getNodes()) {
            if (!entry.isApplied()) continue;
            return true;
        }
        return false;
    }

    protected void apply(GuiButton button) {
        ObjectArrayList entries = new ObjectArrayList();
        for (Entry entry : this.elements.getNodes()) {
            ScreenshotEntry result = entry.createResult();
            if (result == null) continue;
            entries.add(result);
        }
        this.result.accept((List<ScreenshotEntry>)entries);
        this.onClose();
    }

    @Override
    public void onClose() {
        this.displayGuiScreen(this.parent);
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.preview.screenshot.header"), this.centerX, 15.0f, Align.CENTER, -1);
    }

    public static class Entry
    extends PregenList.ListEntry<Entry> {
        int dim;
        int type;
        PregenCheckBox enabled = this.addChild(new PregenCheckBox(0, 0, 14, 14, new PregenCheckBox.CheckboxState(true, false, TextUtil.translate("gui.chunk_pregen.preview.screenshot.entry.create"))));
        PregenCheckBox slimeChunks = this.addChild(new PregenCheckBox(0, 0, 14, 14, new PregenCheckBox.CheckboxState(true, false, TextUtil.translate("gui.chunk_pregen.preview.screenshot.entry.slime"))));
        PregenCheckBox structures = this.addChild(new PregenCheckBox(0, 0, 14, 14, new PregenCheckBox.CheckboxState(true, false, TextUtil.translate("gui.chunk_pregen.preview.screenshot.entry.structures"))));
        PregenCheckBox spam = this.addChild(new PregenCheckBox(0, 0, 14, 14, new PregenCheckBox.CheckboxState(true, false, TextUtil.translate("gui.chunk_pregen.preview.screenshot.entry.spam"))));
        ITextComponent dimName;
        ITextComponent typeName;

        public Entry(int dim, int type, boolean enabled) {
            this.dim = dim;
            this.type = type;
            this.enabled.setChecked(enabled);
            this.enabled.setTooltip(TextUtil.translate("gui.chunk_pregen.preview.tooltip.screenshot.entry.create"));
            this.slimeChunks.setTooltip(TextUtil.translate("gui.chunk_pregen.preview.tooltip.screenshot.entry.slime"));
            this.structures.setTooltip(TextUtil.translate("gui.chunk_pregen.preview.tooltip.screenshot.entry.structures"));
            this.spam.setTooltip(TextUtil.translate("gui.chunk_pregen.preview.tooltip.screenshot.entry.spam"));
            this.dimName = TextUtil.applyTextStyle(TextUtil.dimension(dim).func_150259_f(), TextFormatting.GOLD);
            this.typeName = TextUtil.applyTextStyle(TextUtil.translate(type == 0 ? "gui.chunk_pregen.preview.screenshot.blocks" : (type == 1 ? "gui.chunk_pregen.preview.screenshot.biomes" : "gui.chunk_pregen.preview.screenshot.heights")).func_150259_f(), TextFormatting.DARK_GREEN);
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return false;
        }

        public boolean isApplied() {
            return this.enabled.isChecked();
        }

        public ScreenshotEntry createResult() {
            return this.enabled.isChecked() ? new ScreenshotEntry(this.dim, this.type, this.slimeChunks.isChecked(), this.structures.isChecked(), this.spam.isChecked()) : null;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.enabled.field_146128_h = left + 2;
            this.enabled.field_146129_i = top + 22;
            this.enabled.render(this.mc, mouseX, mouseY, partialTicks);
            this.slimeChunks.field_146128_h = left + 2;
            this.slimeChunks.field_146129_i = top + 36;
            this.slimeChunks.render(this.mc, mouseX, mouseY, partialTicks);
            this.structures.field_146128_h = left + 2;
            this.structures.field_146129_i = top + 50;
            this.structures.render(this.mc, mouseX, mouseY, partialTicks);
            this.spam.field_146128_h = left + 2;
            this.spam.field_146129_i = top + 64;
            this.spam.render(this.mc, mouseX, mouseY, partialTicks);
            BasePregenScreen.drawScrollingString(this.fontRenderer, this.dimName.func_150254_d(), left + 2, top, width - 4, 10.0f, Align.CENTER, -1, this.dim);
            BasePregenScreen.drawScrollingString(this.fontRenderer, this.typeName.func_150254_d(), left + 2, top + 10, width - 4, 10.0f, Align.CENTER, -1, this.type);
        }
    }

    public static class ScreenshotEntry {
        int dim;
        int type;
        boolean slimeChunks;
        boolean structures;
        boolean showSpam;

        public ScreenshotEntry(int dim, int type, boolean slimeChunks, boolean structures, boolean showSpam) {
            this.dim = dim;
            this.type = type;
            this.slimeChunks = slimeChunks;
            this.structures = structures;
            this.showSpam = showSpam;
        }

        public int getDim() {
            return this.dim;
        }

        public int getType() {
            return this.type;
        }

        public boolean showSlimeChunks() {
            return this.slimeChunks;
        }

        public boolean showStructures() {
            return this.structures;
        }

        public boolean showSpam() {
            return this.showSpam;
        }

        public boolean hasOverlays() {
            return this.slimeChunks || this.structures;
        }
    }
}

