/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.info;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.impl.gui.comp.PregenButton;
import pregenerator.impl.client.info.IProcessorInfo;
import pregenerator.impl.client.info.IRenderObj;
import pregenerator.impl.misc.Area;
import pregenerator.impl.network.TaskPacket;
import pregenerator.impl.processor.generator.GenerationType;

public class PregenProcessorInfo
implements IProcessorInfo {
    List<IRenderObj> objects = new ArrayList<IRenderObj>();
    float height = 0.0f;
    boolean minimized = false;
    int dimension;
    UUID taskId;
    float zoomIn = 0.0f;

    @Override
    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    @Override
    public void read(PacketBuffer buffer) {
        boolean preparing = buffer.readBoolean();
        String taskName = buffer.func_150789_c(Short.MAX_VALUE);
        byte modeValue = buffer.readByte();
        GenerationType type = modeValue < 0 ? null : GenerationType.values()[modeValue];
        long totalMemory = buffer.readLong();
        long maxMemory = buffer.readLong();
        long freeMemory = buffer.readLong();
        long lag = buffer.readLong();
        long prepValue = 0L;
        long prepMax = 0L;
        boolean running = false;
        int timePerTick = 0;
        boolean priority = false;
        long duration = 0L;
        long totalChunks = 0L;
        long done = 0L;
        float speed = 0.0f;
        Area area = null;
        if (preparing) {
            prepValue = buffer.readLong();
            prepMax = buffer.readLong();
            this.taskId = null;
        } else {
            running = buffer.readBoolean();
            timePerTick = buffer.readInt();
            priority = buffer.readBoolean();
            duration = buffer.readLong();
            totalChunks = buffer.readLong();
            done = buffer.readLong();
            speed = buffer.readFloat();
            if (buffer.readBoolean()) {
                area = new Area(buffer);
            }
            this.taskId = buffer.func_179253_g();
        }
        this.objects.clear();
        this.objects.add(new HeaderMenu(taskName));
        this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.header", Align.CENTER));
        this.objects.add(IRenderObj.padding(1.0f));
        this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.name", taskName));
        if (type != null) {
            this.objects.add(IRenderObj.text(TextUtil.translate("gui.chunk_pregen.taskgenerator.task_type").func_150259_f().func_150258_a(" ").func_150257_a(type.createText())));
        }
        if (this.minimized) {
            if (preparing) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.prep"));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.prep.progress", NUMBERS.format(prepValue), NUMBERS.format(prepMax), (float)prepValue / (float)prepMax));
                this.objects.add(IRenderObj.padding(1.0f));
            } else if (!running) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.paused"));
            } else {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.running_time", this.getTime(duration)));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.progress", NUMBERS.format(done), NUMBERS.format(totalChunks), Math.min(1.0f, (float)done / (float)totalChunks)));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.generator.server_lag", (Object)lag, Math.min(1.0f, (float)lag / 50.0f)));
                this.objects.add(IRenderObj.padding(1.0f));
            }
        } else {
            this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.dimension", !DimensionManager.isDimensionRegistered((int)this.dimension) ? TextUtil.translate("ui.chunk_pregen.deleter.dimension.unknown") : TextUtil.dimension(this.dimension)));
            if (preparing) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.prep"));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.ram", NUMBERS.format(totalMemory - freeMemory >> 20), NUMBERS.format(maxMemory >> 20), maxMemory <= 0L ? 0.0f : (float)(totalMemory - freeMemory) / (float)maxMemory));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.prep.progress", NUMBERS.format(prepValue), NUMBERS.format(prepMax), (float)prepValue / (float)prepMax));
            } else if (!running) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.paused"));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.ram", NUMBERS.format(totalMemory - freeMemory >> 20), NUMBERS.format(maxMemory >> 20), maxMemory <= 0L ? 0.0f : (float)(totalMemory - freeMemory) / (float)maxMemory));
                this.objects.add(IRenderObj.padding(1.0f));
            } else {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.running_time", DurationFormatUtils.formatDuration((long)duration, (String)"HH:mm:ss")));
                this.objects.add(IRenderObj.text(priority ? "ui.chunk_pregen.generator.time_per_tick.priority" : "ui.chunk_pregen.generator.time_per_tick", TextUtil.NUMBERS.format(timePerTick)));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.generator.server_lag", (Object)lag, Math.min(1.0f, (float)lag / 50.0f)));
                if (area != null) {
                    this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.working_area"));
                    this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.working_area.from", area.getMinX(), area.getMinZ()));
                    this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.working_area.to", area.getMaxX(), area.getMaxZ()));
                } else {
                    this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.working_area.fetching"));
                }
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.ram", NUMBERS.format(totalMemory - freeMemory >> 20), NUMBERS.format(maxMemory >> 20), maxMemory <= 0L ? 0.0f : (float)(totalMemory - freeMemory) / (float)maxMemory));
                this.objects.add(IRenderObj.padding(2.0f));
                this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.eta_small", this.getTime((long)((float)(totalChunks - done) / speed) * Math.max(50L, (long)timePerTick))));
                this.objects.add(IRenderObj.text("ui.chunk_pregen.generator.progress", FLOATING_NUMBERS.format(speed)));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.progress", NUMBERS.format(done), NUMBERS.format(totalChunks), totalChunks == 0L ? 0.0f : (float)done / (float)totalChunks));
            }
        }
        this.objects.add(new FooterMenu(running, taskName));
        this.height = IRenderObj.height(this.objects);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IRenderHelper helper, int x, int y, float scale) {
        helper.setupCanvasSize(100.0f);
        float maxY = this.height - 2.0f;
        helper.drawArea(x, y, 100.0f, maxY);
        float yOffset = 3.0f;
        for (IRenderObj obj : this.objects) {
            obj.render(helper, x + 4, (float)y + yOffset, 100.0f, scale);
            yOffset += obj.height();
        }
    }

    @Override
    public boolean onClick(int mouseX, int mouseY) {
        for (IRenderObj obj : this.objects) {
            if (!obj.onClick(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public int getWidth() {
        return 109;
    }

    @Override
    public int getHeight() {
        return (int)this.height + 6;
    }

    @SideOnly(value=Side.CLIENT)
    public class HeaderMenu
    extends IRenderObj.Interactable {
        PregenButton close = this.addChild(new PregenButton(0, 0, 12, 12, TextUtil.literal("X"), this::onClose));
        PregenButton minimize = this.addChild(new PregenButton(0, 0, 12, 12, TextUtil.literal("_"), this::onMinimize));
        String taskId;

        public HeaderMenu(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public float height() {
            return 0.0f;
        }

        private void onClose(GuiButton button) {
            PregenConfig.INSTANCE.pregenOverlay.setEnabled(false);
            PregenConfig.INSTANCE.save();
        }

        private void onMinimize(GuiButton button) {
            PregenProcessorInfo.this.minimized = !PregenProcessorInfo.this.minimized;
        }

        @Override
        public void setupInteractables(float x, float y, float width, float scale, float posScale) {
            this.close.field_146128_h = (int)((x + width - 2.0f) * posScale) - (int)((float)this.close.getWidgetWidth() * 0.5f * scale);
            this.close.field_146129_i = (int)((y - 1.0f) * posScale);
            this.minimize.field_146128_h = (int)((x + width - 8.0f) * posScale) - (int)((float)this.minimize.getWidgetWidth() * 0.5f * scale);
            this.minimize.field_146129_i = (int)((y - 1.0f) * posScale);
        }
    }

    public static class FooterMenu
    extends IRenderObj.Interactable {
        PregenButton remove = this.addChild(new PregenButton(0, 0, 50, 14, TextUtil.translate("ui.chunk_pregen.deleter.remove"), this::onRemove));
        PregenButton stop = this.addChild(new PregenButton(0, 0, 50, 14, TextUtil.translate("ui.chunk_pregen.deleter.stop"), this::onStop));
        PregenButton pause;
        boolean paused;
        String taskId;

        public FooterMenu(boolean paused, String taskId) {
            this.paused = paused;
            this.taskId = taskId;
            this.pause = this.addChild(new PregenButton(0, 0, 50, 14, TextUtil.translate(paused ? "ui.chunk_pregen.deleter.pause" : "ui.chunk_pregen.deleter.resume"), this::onPause));
        }

        @Override
        public float height() {
            return 7.0f;
        }

        private void onRemove(GuiButton button) {
            ChunkPregenerator.NETWORKING.sendToServer(new TaskPacket.Action(4, this.taskId));
        }

        private void onStop(GuiButton button) {
            ChunkPregenerator.NETWORKING.sendToServer(new TaskPacket.Action(2, this.taskId));
        }

        private void onPause(GuiButton button) {
            ChunkPregenerator.NETWORKING.sendToServer(new TaskPacket.Action(this.paused ? 0 : 1, this.taskId));
        }

        @Override
        public void setupInteractables(float x, float y, float width, float scale, float posScale) {
            this.remove.field_146128_h = (int)(x * posScale);
            this.remove.field_146129_i = (int)(y * posScale);
            this.stop.field_146128_h = (int)(x * posScale) + (int)(25.0f * posScale);
            this.stop.field_146129_i = (int)(y * posScale);
            this.pause.field_146128_h = (int)(x * posScale) + (int)(50.0f * posScale);
            this.pause.field_146129_i = (int)(y * posScale);
        }
    }
}

