/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.api.IModConfigs;
import carbonconfiglib.gui.screen.ConfigSelectorScreen;
import carbonconfiglib.impl.internal.ModConfigs;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.base.IWidget;
import pregenerator.base.impl.gui.comp.CycleButton;
import pregenerator.base.impl.gui.comp.PregenButton;
import pregenerator.base.impl.gui.comp.PregenButtonGroup;
import pregenerator.base.impl.gui.comp.PregenCheckBox;
import pregenerator.base.impl.gui.comp.PregenSlider;
import pregenerator.impl.client.gui.ChunkScreen;
import pregenerator.impl.client.gui.DimensionScreen;
import pregenerator.impl.client.gui.DiskScreen;
import pregenerator.impl.client.gui.RetrogenScreen;
import pregenerator.impl.client.gui.StructureScreen;
import pregenerator.impl.client.gui.commands.DeleteCommandScreen;
import pregenerator.impl.client.gui.commands.GenCommandScreen;
import pregenerator.impl.client.gui.commands.TaskScreen;
import pregenerator.impl.config.PregenOverlay;
import pregenerator.impl.misc.PregenAction;
import pregenerator.impl.network.CommandPacket;

public class PregenMenu
extends BasePregenScreen {
    public static Supplier<GuiScreen> MENU = PregenMenu::new;
    protected PregenButtonGroup group = new PregenButtonGroup(this::setMenu);
    protected Menu[] menus = new Menu[]{new Menu(), new Menu(), new Menu()};
    PregenCheckBox.CheckboxState pregenOverlay = new PregenCheckBox.CheckboxState(false, true).withStateListener(this::togglePregen);
    PregenSlider.SliderState pregenPollRate = new PregenSlider.SliderState(1, 1, 20, this::ticks).setListener(this::setPregenPollRate);
    CycleButton.CycleState<Integer> listenState = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::autoListenState, 0, 1, 2);
    CycleButton.CycleState<Boolean> listening = new CycleButton.CycleState<Boolean>(Boolean.valueOf(false), this::listening, false, true);
    PregenCheckBox.CheckboxState trackerOverlay = new PregenCheckBox.CheckboxState(false, false).withStateListener(this::toggleTracker);
    PregenSlider.SliderState trackerPollRate = new PregenSlider.SliderState(1, 1, 20, this::ticks).setListener(this::setTrackerPollRate);
    CycleButton.CycleState<Integer> dimension = new CycleButton.CycleState<Integer>(Integer.valueOf(0), TextUtil::dimension, this.dimensions());
    protected EnumMap<PregenAction, List<IWidget>> permissions = new EnumMap(PregenAction.class);
    protected EnumSet<PregenAction> allowedActions = EnumSet.noneOf(PregenAction.class);
    boolean update = true;
    private int totalTasks = 0;
    private int runningTasks = 0;
    private int pausedTasks = 0;

    public PregenMenu() {
        this.sendToServer(new CommandPacket.Request());
    }

    protected void loadSettings() {
        PregenConfig config = PregenConfig.INSTANCE;
        PregenOverlay overlay = config.pregenOverlay;
        this.pregenOverlay.setChecked(overlay.isEnabled());
        this.pregenPollRate.set(overlay.getPollDelay());
        overlay = config.trackerOverlay;
        this.trackerOverlay.setChecked(overlay.isEnabled());
        this.trackerPollRate.set(overlay.getPollDelay());
        this.dimension.setValue((Integer)config.detailDimension.getValue());
    }

    @Override
    public void func_73866_w_() {
        this.sendToServer(new CommandPacket.RequestPerms());
        this.update = true;
        this.loadSettings();
        super.func_73866_w_();
        this.group.clear();
        this.addInfoMenu();
        this.addServerDataMenu();
        this.addCommandMenu();
        this.button(-40, -30, 80, 18, Align.CENTER, Align.END, TextUtil.translate("gui.chunk_pregen.retrogen_selector.back"), T -> this.onClose());
        this.setMenu(this.group.getActiveIndex());
    }

    protected void addInfoMenu() {
        this.group.addButton(this.button(15, 15, 40, 16, Align.START, Align.START, TextUtil.translate("gui.chunk_pregen.menu.info"), this.emptyAction()));
        this.menus[0].clear();
        List<IWidget> list = this.menus[0].addMenu(this.button(this.getX(0), 35, 90, 16, Align.START, Align.START, TextUtil.translate("gui.chunk_pregen.menu.pregen_overlay"), this.emptyAction()));
        list.add(this.checkbox(180, 72, 14, 14, this.pregenOverlay));
        list.add(this.slider(134, 88, 60, 14, this.pregenPollRate));
        list.add(this.button(134, 104, 60, 14, TextUtil.translate("gui.chunk_pregen.menu.open"), this::openPregenConfig));
        list = this.menus[0].addMenu(this.button(110, 35, 95, 16, Align.START, Align.START, TextUtil.translate("gui.chunk_pregen.menu.tracker_overlay"), this.emptyAction()));
        list.add(this.checkbox(180, 72, 14, 14, this.trackerOverlay));
        list.add(this.slider(134, 88, 60, 14, this.trackerPollRate));
        list.add(this.cycleButton(114, 104, 80, 14, this.dimension, this::setDetailedDimension).withSelectScreen());
        list.add(this.button(134, 120, 60, 14, TextUtil.translate("gui.chunk_pregen.menu.open"), this::openTrackerConfig));
        list = this.menus[0].addMenu(this.button(this.getX(1), 35, 40, 16, Align.START, Align.START, TextUtil.translate("gui.chunk_pregen.menu.misc"), this.emptyAction()));
        list.add(this.cycleButton(134, 72, 60, 14, this.listenState, this::setChatListenState));
        list.add(this.cycleButton(134, 88, 60, 14, this.listening, this::setListening));
        list.add(this.button(134, 104, 60, 14, TextUtil.translate("gui.chunk_pregen.menu.open"), this::openConfig));
    }

    protected void addServerDataMenu() {
        this.group.addButton(this.button(60, 15, 75, 16, Align.START, Align.START, TextUtil.translate("gui.chunk_pregen.menu.server_data"), this.emptyAction()));
        this.menus[1].clear();
        List<IWidget> list = this.menus[1].addMenu(this.button(15, 35, 75, 16, Align.START, Align.START, TextUtil.translate("gui.chunk_pregen.menu.world_data"), this.emptyAction()));
        list.add(this.permission(PregenAction.ALL_SCANNING, this.button(104, 72, 60, 14, TextUtil.translate("gui.chunk_pregen.menu.open"), this::openEntityViewer)));
        list.add(this.permission(PregenAction.ALL_SCANNING, this.button(104, 88, 60, 14, TextUtil.translate("gui.chunk_pregen.menu.open"), this::openBlockViewer)));
        list.add(this.permission(PregenAction.ALL_SCANNING, this.button(104, 104, 60, 14, TextUtil.translate("gui.chunk_pregen.menu.open"), this::openTileViewer)));
        list.add(this.permission(PregenAction.CHUNK_SCANNING, this.button(104, 120, 60, 14, TextUtil.translate("gui.chunk_pregen.menu.open"), this::openChunkViewer)));
        list.add(this.permission(PregenAction.ALL_SCANNING, this.button(104, 136, 60, 14, TextUtil.translate("gui.chunk_pregen.menu.open"), this::openStructureViewer)));
        list = this.menus[1].addMenu(this.button(95, 35, 40, 16, Align.START, Align.START, TextUtil.translate("gui.chunk_pregen.menu.misc"), this.emptyAction()));
        list.add(this.permission(PregenAction.DISK_SCAN, this.button(114, 72, 60, 14, TextUtil.translate("gui.chunk_pregen.menu.open"), this::openDiskViewer)));
    }

    protected void addCommandMenu() {
        this.group.addButton(this.button(this.getX(2), 15, 60, 16, Align.START, Align.START, TextUtil.translate("gui.chunk_pregen.menu.commands"), this.emptyAction()));
        this.menus[2].clear();
        List<IWidget> list = this.menus[2].addMenu(this.button(15, 35, 95, 16, Align.START, Align.START, TextUtil.translate("gui.chunk_pregen.menu.task_generators"), this.emptyAction()));
        list.add(this.permission(PregenAction.COMMANDS, this.button(129, 72, 60, 14, TextUtil.translate("gui.chunk_pregen.menu.create"), this::openGenerationCreator)));
        list.add(this.permission(PregenAction.COMMANDS, this.button(129, 88, 60, 14, TextUtil.translate("gui.chunk_pregen.menu.create"), this::openDeletionCreator)));
        list = this.menus[2].addMenu(this.button(115, 35, 60, 16, Align.START, Align.START, TextUtil.translate("gui.chunk_pregen.menu.selectors"), this.emptyAction()));
        list.add(this.permission(PregenAction.COMMANDS, this.button(129, 72, 70, 14, TextUtil.translate("gui.chunk_pregen.menu.view_tasks"), this::openTaskList)));
        list.add(this.button(129, 88, 70, 14, TextUtil.translate("gui.chunk_pregen.menu.select"), this::openRetrogen));
        list = this.menus[2].addMenu(this.button(180, 35, 50, 16, Align.START, Align.START, TextUtil.translate("gui.chunk_pregen.menu.actions"), this.emptyAction()));
        list.add(this.permission(PregenAction.COMMANDS, this.button(129, 72, 90, 14, TextUtil.translate("gui.chunk_pregen.menu.pause"), this::pauseAll)));
        list.add(this.permission(PregenAction.COMMANDS, this.button(129, 88, 90, 14, TextUtil.translate("gui.chunk_pregen.menu.resume"), this::resumeAll)));
        list.add(this.permission(PregenAction.COMMANDS, this.button(129, 104, 90, 14, TextUtil.translate("gui.chunk_pregen.menu.stop"), this::stopAll)));
        list.add(this.permission(PregenAction.COMMANDS, this.button(129, 120, 90, 14, TextUtil.translate("gui.chunk_pregen.menu.continue"), this::continueAny)));
        list.add(this.permission(PregenAction.COMMANDS, this.button(129, 136, 90, 14, TextUtil.translate("gui.chunk_pregen.menu.remove"), this::removeAll)));
    }

    protected int getX(int index) {
        switch (index) {
            case 0: {
                return 15;
            }
            case 1: {
                return 210;
            }
            case 2: {
                return 140;
            }
        }
        return -1;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tick % 20 == 0) {
            this.sendToServer(new CommandPacket.Request());
        }
    }

    protected <T extends PregenButton> T permission(PregenAction action, T widget) {
        this.permissions.computeIfAbsent(action, T -> new ObjectArrayList()).add(widget);
        widget.setTooltip(this::permission);
        return (T)widget;
    }

    public void receiveData(int listeningState, boolean listening, int totalTasks, int runningTasks, int pausedTasks) {
        this.listenState.setValue(listeningState);
        this.listening.setValue(listening);
        this.totalTasks = totalTasks;
        this.runningTasks = runningTasks;
        this.pausedTasks = pausedTasks;
        if (this.update) {
            this.update = false;
            this.listening.updateText();
            this.listenState.updateText();
        }
    }

    public void receivePermissions(List<PregenAction> actions) {
        this.allowedActions.clear();
        this.allowedActions.addAll(actions);
    }

    private void updatePermissions() {
        for (Map.Entry<PregenAction, List<IWidget>> entry : this.permissions.entrySet()) {
            boolean result = this.allowedActions.contains((Object)entry.getKey());
            for (IWidget widget : entry.getValue()) {
                widget.setActive(result);
            }
        }
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        this.updatePermissions();
        this.func_146276_q_();
        int index = this.group.getActiveIndex();
        this.renderMenuBackground(index, index < 0 || index >= this.menus.length ? -1 : this.menus[index].getIndex());
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        int index;
        this.renderMenu(index, (index = this.group.getActiveIndex()) < 0 || index >= this.menus.length ? -1 : this.menus[index].getIndex());
    }

    protected void renderMenuBackground(int index, int subIndex) {
        if (index == 0) {
            this.drawColorRegion(15.0f, 55.0f, 200.0f, subIndex == 1 ? 138.0f : 122.0f, -905311734);
        } else if (index == 1) {
            this.drawColorRegion(15.0f, 55.0f, subIndex == 1 ? 180.0f : 170.0f, subIndex == 0 ? 152.0f : (float)(subIndex == 1 ? 92 : 140), -905311734);
        } else {
            this.drawColorRegion(15.0f, 55.0f, subIndex == 1 ? 205.0f : (float)(subIndex == 2 ? 225 : 195), subIndex == 2 ? 155.0f : 108.0f, -905311734);
        }
    }

    protected void renderMenu(int index, int subIndex) {
        if (index == 0) {
            if (subIndex == 0) {
                this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.menu.pregen_overlay"), 18.0f, 58.0f, Align.START, -1);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.enabled"), 18.0f, 72.0f, 160.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.poll_delay"), 18.0f, 88.0f, 114.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.more_settings"), 18.0f, 104.0f, 114.0f, 12.0f, Align.START, -1, 52323);
            } else if (subIndex == 1) {
                this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.menu.tracker_overlay"), 18.0f, 58.0f, Align.START, -1);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.enabled"), 18.0f, 72.0f, 160.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.poll_delay"), 18.0f, 88.0f, 114.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.detailed_dim"), 18.0f, 104.0f, 114.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.more_settings"), 18.0f, 120.0f, 114.0f, 12.0f, Align.START, -1, 52323);
            } else {
                this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.menu.misc_entry"), 18.0f, 58.0f, Align.START, -1);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.chat_state"), 18.0f, 72.0f, 114.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.listening"), 18.0f, 88.0f, 114.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.base_config"), 18.0f, 104.0f, 94.0f, 12.0f, Align.START, -1, 52323);
            }
        } else if (index == 1) {
            if (subIndex == 0) {
                this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.menu.world_data"), 18.0f, 58.0f, Align.START, -1);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.entities"), 18.0f, 72.0f, 84.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.blocks"), 18.0f, 88.0f, 84.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.tiles"), 18.0f, 104.0f, 84.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.chunks"), 18.0f, 120.0f, 84.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.structures"), 18.0f, 136.0f, 84.0f, 12.0f, Align.START, -1, 52323);
            } else {
                this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.menu.misc_entry"), 18.0f, 58.0f, Align.START, -1);
                this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.disk_viewer"), 18.0f, 72.0f, 94.0f, 12.0f, Align.START, -1, 52323);
            }
        } else if (subIndex == 0) {
            this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.menu.task_generators"), 18.0f, 58.0f, Align.START, -1);
            this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.generation_tasks"), 18.0f, 72.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.deletion_tasks"), 18.0f, 88.0f, 109.0f, 12.0f, Align.START, -1, 52323);
        } else if (subIndex == 1) {
            this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.menu.selectors"), 18.0f, 58.0f, Align.START, -1);
            this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.task_list"), 18.0f, 72.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.retrogen_selector"), 18.0f, 88.0f, 109.0f, 12.0f, Align.START, -1, 52323);
        } else {
            this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.menu.actions"), 18.0f, 58.0f, Align.START, -1);
            this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.running_tasks", this.runningTasks - this.pausedTasks), 18.0f, 72.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.paused_tasks", this.pausedTasks), 18.0f, 88.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.active_tasks", this.runningTasks), 18.0f, 104.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.queued tasks", this.totalTasks - this.runningTasks), 18.0f, 120.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.menu.stored_tasks", this.totalTasks), 18.0f, 136.0f, 109.0f, 12.0f, Align.START, -1, 52323);
        }
    }

    @Override
    public void onClose() {
        this.displayGuiScreen(null);
    }

    private void togglePregen(boolean value) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.pregenOverlay.setEnabled(value);
        config.save();
    }

    private void setPregenPollRate(PregenSlider slider) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.pregenOverlay.setPollRate(slider.get());
        config.save();
    }

    private void openPregenConfig(GuiButton button) {
        CarbonConfig.openLocalConfigFolder((IModConfig)IModConfig.carbon((String)"chunkpregenerator", (ConfigHandler)PregenConfig.INSTANCE.getHandler()), (String[])new String[]{"client", "pregen-overlay"});
    }

    private void setListening(CycleButton<Boolean> state) {
        this.sendToServer(new CommandPacket.Action(8 + (state.getValue() != false ? 0 : 1)));
    }

    private void setChatListenState(CycleButton<Integer> state) {
        this.sendToServer(new CommandPacket.Action(state.getValue() + 5));
    }

    private void openConfig(GuiButton button) {
        ModConfigs config = new ModConfigs(FMLCommonHandler.instance().findContainerFor((Object)"chunkpregenerator"));
        config.addConfig(PregenConfig.INSTANCE.getHandler());
        this.displayGuiScreen((GuiScreen)new ConfigSelectorScreen((IModConfigs)config, (GuiScreen)this));
    }

    protected void openGenerationCreator(GuiButton button) {
        this.displayGuiScreen(new GenCommandScreen(this));
    }

    private void openDeletionCreator(GuiButton button) {
        this.displayGuiScreen(new DeleteCommandScreen(this));
    }

    private void openTaskList(GuiButton button) {
        this.displayGuiScreen(new TaskScreen(this));
    }

    private void openRetrogen(GuiButton button) {
        this.displayGuiScreen(new RetrogenScreen(this));
    }

    private void pauseAll(GuiButton button) {
        this.sendToServer(new CommandPacket.Action(0));
    }

    private void resumeAll(GuiButton button) {
        this.sendToServer(new CommandPacket.Action(1));
    }

    private void stopAll(GuiButton button) {
        this.sendToServer(new CommandPacket.Action(2));
    }

    private void continueAny(GuiButton button) {
        this.sendToServer(new CommandPacket.Action(3));
    }

    private void removeAll(GuiButton button) {
        this.sendToServer(new CommandPacket.Action(4));
    }

    private void toggleTracker(boolean value) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.trackerOverlay.setEnabled(value);
        config.save();
    }

    private void setTrackerPollRate(PregenSlider slider) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.trackerOverlay.setPollRate(slider.get());
        config.save();
    }

    private void setDetailedDimension(CycleButton<Integer> state) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.detailDimension.set(state.getValue());
        config.save();
    }

    private void openTrackerConfig(GuiButton button) {
        CarbonConfig.openLocalConfigFolder((IModConfig)IModConfig.carbon((String)"chunkpregenerator", (ConfigHandler)PregenConfig.INSTANCE.getHandler()), (String[])new String[]{"client", "tracker-overlay"});
    }

    private void openEntityViewer(GuiButton button) {
        this.displayGuiScreen(new DimensionScreen(1, this));
    }

    private void openBlockViewer(GuiButton button) {
        this.displayGuiScreen(new DimensionScreen(3, this));
    }

    private void openTileViewer(GuiButton button) {
        this.displayGuiScreen(new DimensionScreen(0, this));
    }

    private void openChunkViewer(GuiButton button) {
        this.displayGuiScreen(new ChunkScreen(this));
    }

    private void openStructureViewer(GuiButton button) {
        this.displayGuiScreen(new StructureScreen(this));
    }

    private void openDiskViewer(GuiButton button) {
        this.displayGuiScreen(new DiskScreen(this));
    }

    public void setMenu(int index) {
        for (int i = 0; i < this.menus.length; ++i) {
            if (i == index) {
                this.menus[i].enable();
                continue;
            }
            this.menus[i].disable();
        }
    }

    private ITextComponent permission(GuiButton button) {
        return button.field_146124_l ? null : TextUtil.translate("gui.chunk_pregen.menu.tooltip.permission");
    }

    protected ITextComponent ticks(int value) {
        return TextUtil.translate(value > 1 ? "gui.chunk_pregen.menu.ticks" : "gui.chunk_pregen.menu.tick", value);
    }

    private ITextComponent listening(boolean value) {
        return TextUtil.translate(value ? "gui.chunk_pregen.menu.yes" : "gui.chunk_pregen.menu.no");
    }

    private ITextComponent autoListenState(int index) {
        return TextUtil.translate(index == 0 ? "gui.chunk_pregen.menu.listen_state.active" : (index == 2 ? "gui.chunk_pregen.menu.listen_state.passive" : "gui.chunk_pregen.menu.listen_state.ignoring"));
    }

    public static class Menu {
        PregenButtonGroup subMenus = new PregenButtonGroup(this::setMenu);
        List<IWidget> menuItems = new ObjectArrayList();
        List<List<IWidget>> widgets = new ObjectArrayList();

        public List<IWidget> addMenu(PregenButton activator) {
            this.subMenus.addButton(activator);
            this.menuItems.add(activator);
            ObjectArrayList result = new ObjectArrayList();
            this.widgets.add((List<IWidget>)result);
            return result;
        }

        public void clear() {
            this.subMenus.clear();
            this.widgets.clear();
        }

        public void disable() {
            this.setMenu(-1);
            for (IWidget entry : this.menuItems) {
                entry.setVisible(false);
            }
        }

        public void enable() {
            this.setMenu(this.subMenus.getActiveIndex());
            for (IWidget entry : this.menuItems) {
                entry.setVisible(true);
            }
        }

        private void setMenu(int index) {
            int m = this.widgets.size();
            for (int i = 0; i < m; ++i) {
                boolean visible = index == i;
                for (IWidget widget : this.widgets.get(i)) {
                    widget.setVisible(visible);
                }
            }
        }

        public int getIndex() {
            return this.subMenus.getActiveIndex();
        }
    }
}

