/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.comp.CycleButton;
import pregenerator.base.impl.gui.comp.PregenCheckBox;
import pregenerator.base.impl.gui.comp.PregenList;
import pregenerator.base.impl.gui.comp.PregenText;
import pregenerator.impl.client.helpers.IWorldAcceptor;
import pregenerator.impl.network.TypePacket;
import pregenerator.impl.tracking.types.BlockEntry;
import pregenerator.impl.tracking.types.EntityTypeEntry;
import pregenerator.impl.tracking.types.IWorldEntry;
import pregenerator.impl.tracking.types.TileEntry;

public class DimensionScreen
extends BasePregenScreen
implements IWorldAcceptor {
    private static final ITextComponent TOOLTIP_LAG = TextUtil.translateStyled("gui.chunk_pregen.dimension_screen.tooltip.no_lag", TextFormatting.RED);
    private static final ITextComponent TOOLTIP_RNG = TextUtil.translateStyled("gui.chunk_pregen.dimension_screen.tooltip.rng_tick", TextFormatting.RED);
    private static final ITextComponent TOOLTIP_DELETE = TextUtil.translateStyled("gui.chunk_pregen.dimension_screen.tooltip.delete", TextFormatting.DARK_AQUA);
    private static final ITextComponent SANITY_CHECK_HEADER = TextUtil.translateStyled("gui.chunk_pregen.check_screen.header", TextFormatting.BOLD, TextFormatting.RED);
    private static final String[] HEADERS = new String[]{"gui.chunk_pregen.dimension_screen.header.tiles", "gui.chunk_pregen.dimension_screen.header.entities", "gui.chunk_pregen.unused_constructor", "gui.chunk_pregen.dimension_screen.header.tiles"};
    int mode;
    GuiScreen parent;
    boolean refresh = true;
    Map<Class<? extends Entity>, Entity> entityCache = new Object2ObjectOpenHashMap();
    PregenList.ListState<TypeEntry> elements = new PregenList.ListState(32, (PregenList.ListEntry[])new TypeEntry[0]).setTopPadding(65).setBottomPadding(45).setRowWidth(330).setItemWidth(55);
    CycleButton.CycleState<Integer> sorter = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getSorterName, 0, 1, 2);
    CycleButton.CycleState<Integer> dimensions = new CycleButton.CycleState<Integer>(Integer.valueOf(this.defaultDimension()), TextUtil::dimension, this.dimensions());
    PregenText.TextState search = new PregenText.TextState("").setCallback(this.elements::search);
    PregenCheckBox.CheckboxState showMods = new PregenCheckBox.CheckboxState(true, true, TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_mods")).withStateListener(T -> {
        this.elements.setItemHeight((T != false ? 65 : 55) - (this.mode == 1 ? 10 : 0));
        this.func_73866_w_();
    });
    PregenCheckBox.CheckboxState showFrame = new PregenCheckBox.CheckboxState(true, false, TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_frame")).withStateListener(this.elements::setFrame);
    ITextComponent header;

    public DimensionScreen(int mode, GuiScreen parent) {
        this.mode = mode;
        this.parent = parent;
        this.updateDimension();
        this.elements.setItemHeight(65 - (mode == 1 ? 10 : 0));
        this.header = TextUtil.translate(HEADERS[mode]);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.list(this.elements);
        this.text(-96, 43, 188, 14, Align.CENTER, Align.START, this.search);
        this.cycleButton(-97, 24, 94, 16, Align.CENTER, Align.START, this.sorter, (CycleButton<T> T) -> {
            if (this.elements.getOwner() == null) {
                return;
            }
            this.elements.sort(this.getSorter((Integer)T.getValue()));
        }).setTooltip(TextUtil.translateStyled("gui.chunk_pregen.dimension_screen.sort", TextFormatting.GOLD));
        this.cycleButton(-1, 24, 94, 16, Align.CENTER, Align.START, this.dimensions, (CycleButton<T> T) -> this.updateDimension()).withSelectScreen().setTooltip(this::getDimensionTooltip);
        this.checkbox(96, 25, 14, 14, Align.CENTER, Align.START, this.showFrame);
        this.checkbox(96, 43, 14, 14, Align.CENTER, Align.START, this.showMods);
        this.button(-60, -28, 120, 20, Align.CENTER, Align.END, TextUtil.translate("gui.chunk_pregen.retrogen_selector.back"), T -> this.onClose());
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tick % 80 == 0 && !GuiScreen.func_146272_n()) {
            this.updateDimension();
        }
    }

    @Override
    public void onClose() {
        this.displayGuiScreen(this.parent);
    }

    public void updateDimension() {
        this.sendToServer(new TypePacket.Request(this.mode, this.dimensions.getValue()));
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        this.drawUnalignedText(this.header, this.centerX, 10.0f, Align.CENTER, -1);
    }

    @Override
    public void acceptWorldData(int index, List<IWorldEntry> data) {
        ObjectArrayList types = new ObjectArrayList();
        for (IWorldEntry entry : data) {
            types.add(new TypeEntry(entry, index));
        }
        types.sort(this.getSorter(this.sorter.getValue()));
        this.elements.replace((List<TypeEntry>)types);
    }

    private ITextComponent getSorterName(int mode) {
        switch (mode) {
            case 0: {
                return TextUtil.translate("gui.chunk_pregen.dimension_screen.sort.count");
            }
            case 1: {
                return TextUtil.translate("gui.chunk_pregen.dimension_screen.sort.name");
            }
        }
        return TextUtil.translate("gui.chunk_pregen.dimension_screen.sort.mod");
    }

    private ITextComponent getDimensionTooltip(CycleButton<Integer> button) {
        ITextComponent base = TextUtil.empty();
        base.func_150257_a(TextUtil.translateStyled("gui.chunk_pregen.taskgenerator.tooltip.dimension", TextFormatting.GOLD));
        return base;
    }

    private Comparator<TypeEntry> getSorter(int mode) {
        switch (mode) {
            case 0: {
                return Comparator.comparingInt(TypeEntry::getCount).reversed();
            }
            case 1: {
                return Comparator.comparing(TypeEntry::getId, Comparator.comparing(ResourceLocation::func_110623_a));
            }
        }
        return Comparator.comparing(TypeEntry::getId);
    }

    private static Entity create(Class<? extends Entity> type) {
        Entity entity = DimensionScreen.createEntity(type);
        if (entity instanceof EntityItem) {
            ((EntityItem)entity).func_92058_a(new ItemStack((Block)Blocks.field_150461_bJ));
        }
        return entity;
    }

    private static Entity createEntity(Class<? extends Entity> type) {
        try {
            return type.getConstructor(World.class).newInstance(Minecraft.func_71410_x().field_71441_e);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public class TypeEntry
    extends PregenList.ListEntry<TypeEntry> {
        IWorldEntry entry;
        int index;
        ResourceLocation id;
        Entity entity;
        boolean hovered = false;
        ITextComponent name;
        ITextComponent mod;
        ITextComponent found;
        ITextComponent ticking;
        ITextComponent tooltipName;
        ITextComponent tooltipMod;
        ITextComponent tooltipFound;

        public TypeEntry(IWorldEntry entry, int index) {
            this.entry = entry;
            this.index = index;
            this.name = TextUtil.applyTextStyle(entry.getName().func_150259_f(), TextFormatting.GOLD);
            this.id = entry.getKey();
            this.mod = TextUtil.applyTextStyle(TextUtil.getModName(this.id.func_110624_b()).func_150259_f(), TextFormatting.GRAY, TextFormatting.ITALIC);
            this.found = TextUtil.literal(BasePregenScreen.NUMBERS.format(entry.getCount()));
            this.ticking = TextUtil.translateStyled(index == 0 ? "gui.chunk_pregen.dimension_screen.ticking" : "gui.chunk_pregen.dimension_screen.rng_tick", TextFormatting.GRAY);
            this.tooltipName = TextUtil.applyTextStyle(TextUtil.translate(this.getTranslationKey(index), entry.getName()), TextFormatting.GOLD);
            this.tooltipMod = TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.mod", TextUtil.getModName(this.id.func_110624_b())), TextFormatting.GRAY);
            this.tooltipFound = TextUtil.translate("gui.chunk_pregen.dimension_screen.tooltip.found", BasePregenScreen.NUMBERS.format(entry.getCount()));
            if (entry instanceof EntityTypeEntry) {
                this.entity = DimensionScreen.this.entityCache.computeIfAbsent(((EntityTypeEntry)entry).getEntity().getEntityClass(), x$0 -> DimensionScreen.create(x$0));
            }
        }

        public int getCount() {
            return this.entry.getCount();
        }

        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public boolean mouseClick(double mouseX, double mouseY, int p_94739_) {
            if (GuiScreen.func_146272_n() && this.entry.canDelete(false)) {
                DimensionScreen.this.displayGuiScreen(DimensionScreen.this.createChoice(SANITY_CHECK_HEADER, TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.check_screen.body", BasePregenScreen.NUMBERS.format(this.entry.getCount()), this.name), TextFormatting.GRAY), (T, I) -> {
                    if (T) {
                        DimensionScreen.this.sendToServer(new TypePacket.DeleteAction(DimensionScreen.this.mode, DimensionScreen.this.dimensions.getValue(), this.entry));
                    }
                    DimensionScreen.this.displayGuiScreen(DimensionScreen.this);
                }));
                return true;
            }
            return super.mouseClick(mouseX, mouseY, p_94739_);
        }

        @Override
        protected boolean containsSearch(String searchString) {
            String[] split = this.id.func_110623_a().split("[\\s-_]");
            int m = split.length;
            for (int i = 0; i < m; ++i) {
                if (!split[i].startsWith(searchString)) continue;
                return true;
            }
            return false;
        }

        private Block getBlock() {
            if (this.entry instanceof TileEntry) {
                return ((TileEntry)this.entry).getType();
            }
            if (this.entry instanceof BlockEntry) {
                return ((BlockEntry)this.entry).getType();
            }
            return null;
        }

        private String getTranslationKey(int index) {
            switch (index) {
                case 0: {
                    return "gui.chunk_pregen.dimension_screen.tooltip.type.tile";
                }
                case 1: {
                    return "gui.chunk_pregen.dimension_screen.tooltip.type.entity";
                }
                case 3: {
                    return "gui.chunk_pregen.dimension_screen.tooltip.type.block";
                }
            }
            return "gui.chunk_pregen.unused_constructor";
        }

        public boolean isRandomTicking() {
            return this.entry instanceof BlockEntry && ((BlockEntry)this.entry).isTicking();
        }

        @Override
        public void provideTooltips(Consumer<ITextComponent> tooltips) {
            super.provideTooltips(tooltips);
            if (this.hovered) {
                tooltips.accept(this.tooltipName);
                tooltips.accept(this.tooltipMod);
                tooltips.accept(this.tooltipFound);
                if (this.entry instanceof TileEntry && !((TileEntry)this.entry).isTicking()) {
                    tooltips.accept(TOOLTIP_LAG);
                } else if (this.isRandomTicking()) {
                    tooltips.accept(TOOLTIP_RNG);
                }
                if (this.entry.canDelete(false)) {
                    tooltips.accept(TOOLTIP_DELETE);
                }
                this.hovered = false;
            }
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.hovered = mouseX >= left && mouseX < left + width && mouseY >= top && mouseY < top + height && this.isVisible(mouseX, mouseY);
            Block block = this.getBlock();
            if (block != null) {
                BasePregenScreen.pushScissors(left + width / 2 - 10, top, 20.0f, 20.0f);
                RenderHelper.func_74520_c();
                this.mc.func_175599_af().func_175042_a(new ItemStack(block), left + width / 2 - 9, top);
                BasePregenScreen.popScissors();
            }
            if (this.entity != null) {
                float entityHeight = this.entity.field_70131_O;
                entityHeight = (entityHeight - 1.0f) * 0.7f + 1.0f;
                float s = 1.0f * (11.2f / entityHeight);
                GlStateManager.func_179126_j();
                BasePregenScreen.pushScissors(left + width / 2 - 10, top, 20.0f, 20.0f);
                BasePregenScreen.renderEntityInGui(this.entity, left + width / 2 - 9, top - 3, s, 0.0f);
                BasePregenScreen.popScissors();
                GlStateManager.func_179097_i();
            }
            int y = top + this.fontRenderer.field_78288_b + 13;
            DimensionScreen.this.drawUnalignedScrollText(this.name, left + 2, y, width - 4, this.fontRenderer.field_78288_b + 1, Align.CENTER, -1, this.id.func_110623_a().hashCode());
            if (DimensionScreen.this.showMods.isChecked()) {
                DimensionScreen.this.drawUnalignedScrollText(this.mod, left + 2, y += this.fontRenderer.field_78288_b + 1, width - 4, this.fontRenderer.field_78288_b + 1, Align.CENTER, -1, this.id.func_110624_b().hashCode());
            }
            DimensionScreen.this.drawUnalignedScrollText(this.found, left + 2, y += this.fontRenderer.field_78288_b + 1, width - 4, this.fontRenderer.field_78288_b + 1, Align.CENTER, -1, this.id.hashCode());
            if (this.entry instanceof TileEntry && ((TileEntry)this.entry).isTicking() || this.isRandomTicking()) {
                DimensionScreen.this.drawUnalignedScrollText(this.ticking, left + 2, y += this.fontRenderer.field_78288_b + 1, width - 4, this.fontRenderer.field_78288_b + 1, Align.CENTER, -1, this.id.hashCode());
            }
        }
    }
}

