/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client;

import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.impl.client.info.IProcessorInfo;
import pregenerator.impl.client.info.TrackerInfo;
import pregenerator.impl.config.PregenOverlay;
import pregenerator.impl.network.TrackerPacket;

public class TrackerRenderer {
    TrackerInfo tracker = new TrackerInfo();
    boolean dataReceived = false;
    int ticker = 0;

    public void onTrackerInfoReceived(byte[] data) {
        if (data.length <= 0) {
            this.tracker.clear();
            this.dataReceived = false;
            return;
        }
        this.tracker.read(new PacketBuffer(Unpooled.wrappedBuffer((byte[])data)));
        this.dataReceived = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onUIRenderer(RenderGameOverlayEvent.Post event, IRenderHelper helper) {
        if (!this.shouldTrack() || !this.dataReceived) {
            return;
        }
        PregenOverlay overlay = PregenConfig.INSTANCE.trackerOverlay;
        float zoom = (float)overlay.getScale();
        float invZoom = 1.0f / zoom;
        int yLevel = this.tracker.getHeight();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)250.0);
        if (zoom != 1.0f) {
            GlStateManager.func_179152_a((float)zoom, (float)zoom, (float)1.0f);
        }
        this.tracker.render(helper, this.calculateXOffset(overlay.hAlign(), (int)((float)this.getScreenWidth() * invZoom), this.tracker), this.calculateHeight(overlay.vAlign(), (int)((float)this.getScreenHeight() * invZoom), yLevel), zoom);
        GlStateManager.func_179121_F();
    }

    public boolean onClick(int mouseX, int mouseY) {
        if (!this.shouldTrack() || !this.dataReceived) {
            return false;
        }
        float scale = 1.0f / (float)PregenConfig.INSTANCE.trackerOverlay.getScale();
        return this.tracker.onClick((int)((float)mouseX * scale), (int)((float)mouseY * scale));
    }

    @SideOnly(value=Side.CLIENT)
    public void update() {
        if (this.shouldTrack() && ++this.ticker % PregenConfig.INSTANCE.trackerOverlay.getPollDelay() == 0) {
            ChunkPregenerator.NETWORKING.sendToServer(new TrackerPacket.Request(PregenConfig.INSTANCE.detailDimension.get()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int getScreenHeight() {
        return new ScaledResolution(Minecraft.func_71410_x()).func_78328_b();
    }

    @SideOnly(value=Side.CLIENT)
    private int getScreenWidth() {
        return new ScaledResolution(Minecraft.func_71410_x()).func_78326_a();
    }

    @SideOnly(value=Side.CLIENT)
    private int calculateXOffset(Align align, int screenWidth, IProcessorInfo info) {
        switch (align) {
            case CENTER: {
                return screenWidth / 2 - info.getWidth() / 2;
            }
            case END: {
                return screenWidth - info.getWidth();
            }
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    private int calculateHeight(Align align, int screenHeight, int yLevel) {
        if (align == Align.END) {
            return screenHeight - yLevel;
        }
        if (align == Align.CENTER) {
            return screenHeight / 2 - yLevel / 2;
        }
        return 1;
    }

    public boolean shouldWarn() {
        return !this.dataReceived && this.shouldTrack();
    }

    public boolean shouldTrack() {
        return PregenConfig.INSTANCE.trackerOverlay.isEnabled();
    }

    public void setVisible(boolean value) {
        PregenConfig.INSTANCE.trackerOverlay.setEnabled(value);
        PregenConfig.INSTANCE.save();
    }
}

