/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.gui.comp;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.base.IInteractable;
import pregenerator.base.impl.gui.base.SmoothFloat;
import pregenerator.base.impl.gui.comp.DynamicPregenList;

public class PregenList<T extends ListEntry<T>>
extends DynamicPregenList<T>
implements BasePregenScreen.ITooltipProvider {
    ListState<T> state;

    public PregenList(int width, int height, int startY, int endY, ListState<T> state) {
        super(width, height, startY, endY, state.getItemHeight());
        this.state = state;
        state.setOwner(this);
        this.applySearch(state.getSearch());
        if (state.isFramed()) {
            this.setRenderSelection(true);
        }
    }

    public PregenList(GuiScreen owner, ListState<T> state) {
        this(owner.field_146294_l, owner.field_146295_m, state.getTopPadding(), owner.field_146295_m - state.getBottomPadding(), state);
    }

    @Override
    public void provideTooltips(Consumer<ITextComponent> tooltips) {
        for (ListEntry entry : this.children()) {
            if (!(entry instanceof BasePregenScreen.ITooltipProvider)) continue;
            entry.provideTooltips(tooltips);
        }
    }

    @Override
    public int getRowWidth() {
        return this.state.getRowWidth();
    }

    @Override
    protected boolean isSelectedItem(int p_94019_) {
        return this.state.isFramed();
    }

    @Override
    protected int getScrollbarPosition() {
        return this.width / 2 + this.state.getRowWidth() / 2 + 14;
    }

    @Override
    public void setScrollAmount(double value) {
        this.state.setScrollAmount(Math.max(0.0, Math.min(value, (double)this.getMaxScroll())));
    }

    @Override
    public double getScrollAmount() {
        return this.state.getScrollAmount();
    }

    @Override
    public void render(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.state.scrollAmount.update(partialTicks);
        super.render(mc, mouseX, mouseY, partialTicks);
    }

    public void applySearch(String search) {
        this.state.updateSearch(search);
        if (search == null || search.isEmpty()) {
            this.replaceEntries(this.state.getNodes());
            this.setScrollAmount(this.getScrollAmount());
            return;
        }
        String actualSearch = search.toLowerCase(Locale.ROOT);
        ObjectArrayList nodes = new ObjectArrayList();
        for (ListEntry entry : this.state.getNodes()) {
            if (!entry.containsSearch(actualSearch)) continue;
            nodes.add(entry);
        }
        this.replaceEntries(nodes);
        this.setScrollAmount(this.getScrollAmount());
    }

    @Override
    protected void renderList(int mouseX, int mouseY, float partialTicks) {
        if (this.state.getItemWidth() <= 0) {
            super.renderList(mouseX, mouseY, partialTicks);
            return;
        }
        this.hovered = this.isMouseOver(mouseX, mouseY) ? this.getEntryAtPos(mouseX, mouseY) : null;
        int entryWidth = this.state.getItemWidth();
        int minX = this.getRowLeft();
        int width = this.getRowWidth();
        int size = this.getItemCount();
        int yOff = this.y0 + 4 - (int)this.getScrollAmount() + this.headerHeight;
        int xOffset = 0;
        int yOffset = 0;
        boolean hasRendered = false;
        BasePregenScreen.pushScissors(new BasePregenScreen.Rect(minX, this.y0 + this.headerHeight, width, this.y1 - this.y0));
        for (int i = 0; i < size; ++i) {
            int minY;
            int maxY;
            if (xOffset + entryWidth > width) {
                yOffset += this.state.itemHeight;
                xOffset = 0;
            }
            if ((maxY = (minY = yOffset + yOff) + this.height) >= this.y0 && minY <= this.y1) {
                hasRendered = true;
                this.renderItem(mouseX, mouseY, partialTicks, i, minX + xOffset, minY, entryWidth, this.state.itemHeight - 4);
            } else if (hasRendered) break;
            xOffset += entryWidth;
        }
        BasePregenScreen.popScissors();
    }

    @Override
    protected void centerScrollOn(T element) {
        if (this.state.getItemWidth() <= 0) {
            super.centerScrollOn(element);
            return;
        }
        int index = this.children().indexOf(element);
        if (index <= 0) {
            this.setScrollAmount(0.0);
            return;
        }
        this.setScrollAmount(((index /= this.getRowWidth() / this.state.getItemWidth()) + 1) * this.state.getItemHeight() - (this.y1 - this.y0) / 2);
    }

    @Override
    protected T getEntryAtPos(double mouseX, double mouseY) {
        if (this.state.getItemWidth() <= 0) {
            return (T)((ListEntry)super.getEntryAtPos(mouseX, mouseY));
        }
        int centerWidth = this.getRowWidth() / 2;
        int centerX = this.x0 + this.width / 2;
        int minX = centerX - centerWidth;
        int maxX = centerX + centerWidth;
        int position = (MathHelper.func_76128_c((double)(mouseY - (double)this.y0)) - this.headerHeight + (int)this.getScrollAmount() - 4) / this.state.getItemHeight() * (this.getRowWidth() / this.state.getItemWidth());
        return (T)(mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)minX && mouseX <= (double)maxX && position >= 0 && position < this.getItemCount() ? (ListEntry)this.children().get(position += (int)((mouseX - (double)minX) / (double)this.state.getItemWidth())) : null);
    }

    @Override
    public int getMaxPosition() {
        return this.state.getItemWidth() <= 0 ? super.getMaxPosition() : MathHelper.func_76143_f((double)((double)this.getItemCount() / Math.floor((double)this.getRowWidth() / (double)this.state.getItemWidth()))) * this.state.getItemHeight();
    }

    @Override
    public boolean mouseRelease(double mouseX, double mouseY, int button) {
        if (this.scrolling) {
            this.state.scrollAmount.forceFinish();
        }
        return super.mouseRelease(mouseX, mouseY, button);
    }

    public static class ListState<T extends ListEntry<T>> {
        List<T> nodes = new ObjectArrayList();
        String search = "";
        int top = 50;
        int bottom = 36;
        int itemHeight = 24;
        int itemWidth = 0;
        int rowWidth = 220;
        SmoothFloat scrollAmount = new SmoothFloat(0.25f);
        boolean frame;
        PregenList<T> owner;

        @SafeVarargs
        public ListState(T ... nodes) {
            this.nodes.addAll(Arrays.asList(nodes));
        }

        public ListState(List<T> nodes) {
            this.nodes.addAll(nodes);
        }

        @SafeVarargs
        public ListState(int height, T ... nodes) {
            this.itemHeight = height;
            this.nodes.addAll(Arrays.asList(nodes));
        }

        public ListState(int height, List<T> nodes) {
            this.nodes.addAll(nodes);
            this.itemHeight = height;
        }

        public ListState<T> add(T ... nodes) {
            this.nodes.addAll(Arrays.asList(nodes));
            return this;
        }

        public ListState<T> add(List<T> nodes) {
            this.nodes.addAll(nodes);
            return this;
        }

        public ListState<T> replace(List<T> nodes) {
            this.nodes.clear();
            this.nodes.addAll(nodes);
            return this.search(this.search);
        }

        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        public void sort(Comparator<T> sorter) {
            this.nodes.sort(sorter);
            if (this.owner != null) {
                this.owner.children().sort(sorter);
            }
        }

        public ListState<T> setItemHeight(int newHeight) {
            this.itemHeight = newHeight;
            return this;
        }

        public ListState<T> setItemWidth(int newWidth) {
            this.itemWidth = newWidth;
            return this;
        }

        public ListState<T> setRowWidth(int rowWidth) {
            this.rowWidth = rowWidth;
            return this;
        }

        public ListState<T> setFrame(boolean frame) {
            this.frame = frame;
            return this;
        }

        public ListState<T> setTopPadding(int value) {
            this.top = value;
            return this;
        }

        public ListState<T> setBottomPadding(int value) {
            this.bottom = value;
            return this;
        }

        public ListState<T> setScrollAmount(double value) {
            this.scrollAmount.setTarget((float)value);
            return this;
        }

        public double getScrollAmount() {
            return this.owner != null && this.owner.isScrolling() ? (double)this.scrollAmount.getTarget() : (double)this.scrollAmount.getValue();
        }

        public int getTopPadding() {
            return this.top;
        }

        public int getBottomPadding() {
            return this.bottom;
        }

        public int getRowWidth() {
            return this.rowWidth;
        }

        public int getItemHeight() {
            return this.itemHeight;
        }

        public int getItemWidth() {
            return this.itemWidth;
        }

        public boolean isFramed() {
            return this.frame;
        }

        void setOwner(PregenList<T> owner) {
            this.owner = owner;
        }

        public PregenList<T> getOwner() {
            return this.owner;
        }

        public boolean isSearching() {
            return this.search != null && !this.search.isEmpty();
        }

        public ListState<T> search(String search) {
            this.search = search;
            if (this.owner != null) {
                this.owner.applySearch(search);
            }
            return this;
        }

        public ListState<T> updateSearch() {
            if (this.owner != null) {
                this.owner.applySearch(this.search);
            }
            return this;
        }

        void updateSearch(String search) {
            this.search = search;
        }

        public String getSearch() {
            return this.search;
        }

        public List<T> getNodes() {
            return this.nodes;
        }
    }

    public static abstract class ListEntry<T extends ListEntry<T>>
    extends DynamicPregenList.DynamicEntry<T>
    implements BasePregenScreen.ITooltipProvider {
        List<IInteractable> children = new ObjectArrayList();

        protected <E extends IInteractable> E addChild(E child) {
            this.children.add(child);
            return child;
        }

        @Override
        public void provideTooltips(Consumer<ITextComponent> tooltips) {
            for (IInteractable listener : this.children) {
                if (!(listener instanceof BasePregenScreen.ITooltipProvider)) continue;
                ((BasePregenScreen.ITooltipProvider)((Object)listener)).provideTooltips(tooltips);
            }
        }

        @Override
        public List<? extends IInteractable> children() {
            return this.children;
        }

        protected abstract boolean containsSearch(String var1);

        @Override
        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);
    }
}

