/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.gui.comp;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.comp.PregenButton;

public class PregenCheckBox
extends PregenButton {
    private static final ResourceLocation TEXTURE = new ResourceLocation("chunkpregenerator", "textures/gui/checkbox.png");
    CheckboxState state;

    public PregenCheckBox(int x, int y, int width, int height, ITextComponent text, boolean isChecked, Consumer<PregenCheckBox> handler) {
        this(x, y, width, height, new CheckboxState(false, isChecked, text, handler));
    }

    public PregenCheckBox(int x, int y, int width, int height, CheckboxState state) {
        super(x, y, width, height, state.getLabel(), null);
        this.state = state;
        this.state.setOwner(this);
    }

    @Override
    public void onPress(int button) {
        this.state.toggle();
    }

    public boolean isChecked() {
        return this.state.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.state.setChecked(isChecked);
    }

    @Override
    public void render(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_146125_m) {
            return;
        }
        this.field_146123_n = this.func_146116_c(mc, mouseX, mouseY);
        mc.func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        BasePregenScreen.drawTextureRegion(this.field_146128_h, this.field_146129_i, this.field_146123_n ? 20.0f : 0.0f, this.state.isChecked ? 20.0f : 0.0f, this.field_146120_f, this.field_146121_g, 20.0f, 20.0f, 64.0f, 64.0f);
        if (this.state.showLabel) {
            FontRenderer font = mc.field_71466_p;
            float xPos = this.state.horizontal.align(this.field_146128_h, this.field_146120_f + 2, font.func_78256_a(this.field_146126_j));
            float yPos = this.state.vertical.align(this.field_146129_i, this.field_146121_g + 2, font.field_78288_b);
            this.func_73731_b(font, this.field_146126_j, (int)xPos, (int)yPos, -2039584);
        }
    }

    public static class CheckboxState {
        boolean showLabel;
        boolean isChecked;
        ITextComponent label = TextUtil.empty();
        PregenCheckBox owner;
        Consumer<PregenCheckBox> listener;
        Align vertical = Align.CENTER;
        Align horizontal = Align.END;

        public CheckboxState() {
        }

        public CheckboxState(boolean isChecked) {
            this.isChecked = isChecked;
        }

        public CheckboxState(boolean showLabel, boolean isChecked) {
            this.showLabel = showLabel;
            this.isChecked = isChecked;
        }

        public CheckboxState(boolean showLabel, boolean isChecked, ITextComponent label) {
            this.showLabel = showLabel;
            this.isChecked = isChecked;
            this.label = label;
        }

        public CheckboxState(boolean showLabel, boolean isChecked, ITextComponent label, Consumer<PregenCheckBox> listener) {
            this.showLabel = showLabel;
            this.isChecked = isChecked;
            this.label = label;
            this.listener = listener;
        }

        public CheckboxState withLabel(boolean value) {
            this.showLabel = value;
            return this;
        }

        public CheckboxState setChecked(boolean checked) {
            this.isChecked = checked;
            return this;
        }

        public CheckboxState withListener(Consumer<PregenCheckBox> listener) {
            this.listener = listener;
            return this;
        }

        public CheckboxState withStateListener(Consumer<Boolean> listener) {
            this.listener = T -> listener.accept(T.isChecked());
            return this;
        }

        public CheckboxState vAlign(Align align) {
            this.vertical = align;
            return this;
        }

        public CheckboxState hAlign(Align align) {
            this.horizontal = align;
            return this;
        }

        public CheckboxState setLabel(ITextComponent label) {
            this.label = label;
            if (this.owner != null) {
                this.owner.setDisplayText(label);
            }
            return this;
        }

        void setOwner(PregenCheckBox owner) {
            this.owner = owner;
        }

        public PregenCheckBox getOwner() {
            return this.owner;
        }

        public ITextComponent getLabel() {
            return this.label;
        }

        public boolean isChecked() {
            return this.isChecked;
        }

        public boolean showLabel() {
            return this.showLabel;
        }

        public void toggle() {
            boolean bl = this.isChecked = !this.isChecked;
            if (this.listener != null && this.owner != null) {
                this.listener.accept(this.owner);
            }
        }
    }
}

