/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.gui.base;

import java.util.List;
import java.util.ListIterator;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import pregenerator.base.impl.gui.base.IInteractable;

public interface IInteractableContainer
extends IInteractable {
    public List<? extends IInteractable> children();

    default public IInteractable getChildAt(double mouseX, double mouseY) {
        for (IInteractable iInteractable : this.children()) {
            if (!iInteractable.isMouseOver(mouseX, mouseY)) continue;
            return iInteractable;
        }
        return null;
    }

    @Override
    default public boolean mouseClick(double mouseX, double mouseY, int button) {
        for (IInteractable iInteractable : this.children()) {
            if (!iInteractable.mouseClick(mouseX, mouseY, button)) continue;
            this.setFocused(iInteractable);
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseRelease(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        IInteractable act = this.getChildAt(mouseX, mouseY);
        return act != null && act.mouseRelease(mouseX, mouseY, button);
    }

    @Override
    default public boolean mouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDrag(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean isDragging();

    public void setDragging(boolean var1);

    @Override
    default public boolean mouseScroll(double mouseX, double mouseY, double scroll) {
        IInteractable act = this.getChildAt(mouseX, mouseY);
        return act != null && act.mouseScroll(mouseX, mouseY, scroll);
    }

    @Override
    default public boolean charTyped(char character, int keyCode) {
        return this.getFocused() != null && this.getFocused().charTyped(character, keyCode);
    }

    @Nullable
    public IInteractable getFocused();

    public void setFocused(@Nullable IInteractable var1);

    default public void setInitialFocus(@Nullable IInteractable interact) {
        this.setFocused(interact);
        interact.changeFocus(true);
    }

    default public void magicalSpecialHackyFocus(@Nullable IInteractable interact) {
        this.setFocused(interact);
    }

    @Override
    default public boolean changeFocus(boolean value) {
        Supplier<IInteractable> next;
        BooleanSupplier hasNext;
        boolean flag;
        IInteractable interact = this.getFocused();
        boolean bl = flag = interact != null;
        if (flag && interact.changeFocus(value)) {
            return true;
        }
        List<? extends IInteractable> list = this.children();
        int j = list.indexOf(interact);
        int i = flag && j >= 0 ? j + (value ? 1 : 0) : (value ? 0 : list.size());
        ListIterator<? extends IInteractable> iter = list.listIterator(i);
        BooleanSupplier booleanSupplier = value ? iter::hasNext : (hasNext = iter::hasPrevious);
        Supplier<IInteractable> supplier = value ? iter::next : (next = iter::previous);
        while (hasNext.getAsBoolean()) {
            IInteractable listener = next.get();
            if (!listener.changeFocus(value)) continue;
            this.setFocused(listener);
            return true;
        }
        this.setFocused(null);
        return false;
    }
}

