/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.gui;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.base.AbstractScrollList;

public class SelectorScreen<T>
extends BasePregenScreen {
    GuiScreen parent;
    Consumer<T> result;
    List<T> ids;
    T current;
    Function<T, ITextComponent> displayFunction;
    SelectionList selections;
    long tick = 0L;

    public SelectorScreen(GuiScreen parent, List<T> ids, T current, Function<T, ITextComponent> displayFunction, Consumer<T> result) {
        this.parent = parent;
        this.ids = ids;
        this.current = current;
        this.displayFunction = displayFunction;
        this.result = result;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.selections = new SelectionList();
        for (T id : this.ids) {
            this.selections.add(new SelectionEntry(id, this.displayFunction.apply(id)));
        }
        this.selections.setRenderSelection(true);
        this.selections.select(this.current);
        this.addWidget(this.selections);
        this.button(-86, -30, 80, 20, Align.CENTER, Align.END, TextUtil.translate("gui.chunk_pregen.selector_screen.pick"), this::pick);
        this.button(5, -30, 80, 20, Align.CENTER, Align.END, TextUtil.translate("gui.chunk_pregen.selector_screen.cancel"), T -> this.onClose());
    }

    private void pick(GuiButton button) {
        SelectionEntry entry = (SelectionEntry)this.selections.getSelected();
        this.result.accept(entry == null ? null : (Object)entry.id);
        this.field_146297_k.func_147108_a(this.parent);
    }

    @Override
    public void tick() {
        super.tick();
        ++this.tick;
    }

    @Override
    public void onClose() {
        this.result.accept(null);
        this.field_146297_k.func_147108_a(this.parent);
    }

    public class SelectionEntry
    extends AbstractScrollList.Entry<SelectionEntry> {
        T id;
        ITextComponent name;
        long lastClick = -1L;

        public SelectionEntry(T id, ITextComponent name) {
            this.id = id;
            this.name = name;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(this.name.func_150254_d(), left, top + height / 2 - 5, SelectorScreen.this.selections.getSelected() == this ? -4472270 : -1);
        }

        @Override
        public boolean mouseClick(double p_94737_, double p_94738_, int p_94739_) {
            if (SelectorScreen.this.selections.getSelected() == this) {
                if (this.lastClick >= 0L && SelectorScreen.this.tick - this.lastClick <= 5L) {
                    SelectorScreen.this.pick(null);
                    return true;
                }
                this.lastClick = SelectorScreen.this.tick;
            } else {
                this.lastClick = SelectorScreen.this.tick;
            }
            SelectorScreen.this.selections.select(this.id);
            SelectorScreen.this.current = this.id;
            return true;
        }
    }

    private class SelectionList
    extends AbstractScrollList<SelectionEntry> {
        public SelectionList() {
            super(SelectorScreen.this.field_146294_l, SelectorScreen.this.field_146295_m, 50, SelectorScreen.this.field_146295_m - 36, 24);
        }

        public void add(SelectionEntry entry) {
            this.addEntry(entry);
        }

        public void select(T id) {
            for (SelectionEntry entry : this.children()) {
                if (!entry.id.equals(id)) continue;
                this.setSelected(entry);
                return;
            }
            this.setSelected(null);
        }
    }
}

