/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.api.network;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public interface IPregenPacket {
    public void write(PacketBuffer var1) throws IOException;

    public void read(PacketBuffer var1) throws IOException;

    public void process(EntityPlayer var1);

    default public boolean needsMainThreads() {
        return true;
    }

    public static NBTTagCompound readNBT(PacketBuffer buffer) {
        try {
            return buffer.func_150793_b();
        }
        catch (IOException iOException) {
            return new NBTTagCompound();
        }
    }

    public static <K, V> void writeMap(PacketBuffer buffer, Map<K, V> elements, BiConsumer<PacketBuffer, K> keyWriter, BiConsumer<PacketBuffer, V> valueWriter) {
        buffer.func_150787_b(elements.size());
        for (Map.Entry<K, V> entry : elements.entrySet()) {
            keyWriter.accept(buffer, entry.getKey());
            valueWriter.accept(buffer, entry.getValue());
        }
    }

    public static <K, V> void readMap(PacketBuffer buffer, Map<K, V> output, Function<PacketBuffer, K> keyReader, Function<PacketBuffer, V> valueReader) {
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            K key = keyReader.apply(buffer);
            V value = valueReader.apply(buffer);
            if (key == null || value == null) continue;
            output.put(key, value);
        }
    }

    public static <T> void writeCollection(PacketBuffer buffer, Collection<T> elements, BiConsumer<T, PacketBuffer> action) {
        buffer.func_150787_b(elements.size());
        for (T entry : elements) {
            action.accept(entry, buffer);
        }
    }

    public static <T> void writeCollectionReverse(PacketBuffer buffer, Collection<T> elements, BiConsumer<PacketBuffer, T> action) {
        buffer.func_150787_b(elements.size());
        for (T entry : elements) {
            action.accept(buffer, (PacketBuffer)entry);
        }
    }

    public static <T> void readCollection(PacketBuffer buffer, Collection<T> output, Function<PacketBuffer, T> parser) {
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            T result = parser.apply(buffer);
            if (result == null) continue;
            output.add(result);
        }
    }

    public static interface IRequestPacket
    extends IPregenPacket {
        @Override
        default public void write(PacketBuffer buffer) throws IOException {
        }

        @Override
        default public void read(PacketBuffer buffer) throws IOException {
        }
    }
}

