/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.api;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.PregenConfig;

public class TextUtil {
    public static final DecimalFormat NUMBERS = new DecimalFormat("###,###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    public static final DecimalFormat FLOATING_NUMBERS = new DecimalFormat("###,###.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    public static final DecimalFormat FLOATING_NUMBERS_EXTENDED = new DecimalFormat("###,###.###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final DecimalFormat FORMAT = new DecimalFormat("###,###.###");
    private static final String[] DATA_TYPES = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
    private static final Map<String, ITextComponent> CACHE = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Map<Integer, Long> DIMENSION_SIZES = TextUtil.createData();

    private static Map<Integer, Long> createData() {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        result.put(0, 10280L);
        result.put(-1, 5476L);
        result.put(1, 925L);
        return result;
    }

    public static synchronized void registerDimensionSize(int result, long bytes) {
        DIMENSION_SIZES.put(result, bytes);
    }

    private static boolean forceServerTranslate() {
        return PregenConfig.INSTANCE.forceServerTranslation.get();
    }

    public static ITextComponent empty() {
        return new TextComponentString("");
    }

    public static ITextComponent literal(String text) {
        return new TextComponentString(text);
    }

    public static ITextComponent literalPascal(String text) {
        return new TextComponentString(TextUtil.toPascalCase(text));
    }

    public static ITextComponent translate(String text) {
        ITextComponent component = CACHE.computeIfAbsent(text, x$0 -> new TextComponentTranslation(x$0, new Object[0]));
        return TextUtil.forceServerTranslate() ? TextUtil.serverTranslate(component) : component;
    }

    public static ITextComponent translate(String text, Object ... args) {
        return TextUtil.forceServerTranslate() ? TextUtil.serverTranslate((ITextComponent)new TextComponentTranslation(text, args)) : new TextComponentTranslation(text, args);
    }

    public static ITextComponent translateStyled(String text, TextFormatting formatting) {
        return TextUtil.applyTextStyle(TextUtil.translate(text).func_150259_f(), formatting);
    }

    public static ITextComponent translateStyled(String text, TextFormatting ... formatting) {
        return TextUtil.applyTextStyle(TextUtil.translate(text).func_150259_f(), formatting);
    }

    public static ITextComponent mergeStyle(ITextComponent text, Style style) {
        Style textStyle = text.func_150256_b();
        if (textStyle.func_150215_a() == null) {
            textStyle.func_150238_a(style.func_150215_a());
        }
        if (!textStyle.func_150223_b()) {
            textStyle.func_150227_a(Boolean.valueOf(style.func_150223_b()));
        }
        if (!textStyle.func_150242_c()) {
            textStyle.func_150217_b(Boolean.valueOf(style.func_150242_c()));
        }
        if (!textStyle.func_150233_f()) {
            textStyle.func_150237_e(Boolean.valueOf(style.func_150233_f()));
        }
        if (!textStyle.func_150236_d()) {
            textStyle.func_150225_c(Boolean.valueOf(style.func_150236_d()));
        }
        if (!textStyle.func_150234_e()) {
            textStyle.func_150228_d(Boolean.valueOf(style.func_150234_e()));
        }
        if (textStyle.func_150235_h() == null) {
            textStyle.func_150241_a(style.func_150235_h());
        }
        if (textStyle.func_150210_i() == null) {
            textStyle.func_150209_a(style.func_150210_i());
        }
        if (textStyle.func_179986_j() == null) {
            textStyle.func_179989_a(style.func_179986_j());
        }
        return text;
    }

    public static ITextComponent applyTextStyle(ITextComponent text, TextFormatting ... formatting) {
        Style style = text.func_150256_b();
        for (TextFormatting format : formatting) {
            if (format.func_96302_c()) {
                style.func_150238_a(format);
                continue;
            }
            if (format == TextFormatting.OBFUSCATED) {
                style.func_150237_e(Boolean.valueOf(true));
            } else if (format == TextFormatting.BOLD) {
                style.func_150227_a(Boolean.valueOf(true));
            } else if (format == TextFormatting.STRIKETHROUGH) {
                style.func_150225_c(Boolean.valueOf(true));
            } else if (format == TextFormatting.UNDERLINE) {
                style.func_150228_d(Boolean.valueOf(true));
            } else if (format == TextFormatting.ITALIC) {
                style.func_150217_b(Boolean.valueOf(true));
            }
            if (format != TextFormatting.RESET) continue;
            text.func_150255_a(new Style());
            style = text.func_150256_b();
        }
        return text;
    }

    public static ITextComponent serverTranslate(ITextComponent input) {
        ITextComponent output = TextUtil.empty();
        input.forEach(T -> output.func_150257_a(TextUtil.literal(T.func_150261_e()).func_150255_a(TextUtil.validateStyle(T.func_150256_b()))));
        return output;
    }

    private static Style validateStyle(Style style) {
        ITextComponent value;
        HoverEvent event = style.func_150210_i();
        if (event != null && (value = event.func_150702_b()) != null) {
            return style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextUtil.serverTranslate(value)));
        }
        return style;
    }

    public static void split(ITextComponent input, Consumer<ITextComponent> output) {
        ITextComponent currentOutput = TextUtil.empty();
        for (ITextComponent component : input) {
            boolean hasSplit = false;
            String originalText = component.func_150261_e();
            if ("\\n".equals(originalText)) {
                output.accept(currentOutput);
                currentOutput = TextUtil.empty();
                continue;
            }
            for (String text : originalText.split("\\n")) {
                if (hasSplit) {
                    output.accept(currentOutput);
                    currentOutput = TextUtil.empty();
                    hasSplit = false;
                }
                currentOutput.func_150257_a(TextUtil.literal(text).func_150255_a(component.func_150256_b()));
            }
        }
        if (currentOutput.func_150253_a().size() > 0) {
            output.accept(currentOutput);
        }
    }

    public static ITextComponent guiConstructor() {
        return TextUtil.translate("gui.chunk_pregen.unused_constructor");
    }

    public static ITextComponent dimension(int dimensionId) {
        return DimensionManager.isDimensionRegistered((int)dimensionId) ? TextUtil.dimension(DimensionManager.getProviderType((int)dimensionId)) : TextUtil.translate("commands.chunk_pregen.error.dimension.unknown");
    }

    private static ITextComponent dimension(DimensionType dimension) {
        ResourceLocation id = new ResourceLocation(dimension.func_186065_b());
        String key = TextUtil.makeTranslationKey("dimension", id);
        return I18n.func_94522_b((String)key) ? TextUtil.translate(key) : TextUtil.literal(TextUtil.toPascalCase(id.func_110623_a()));
    }

    public static ITextComponent biome(ResourceLocation biome) {
        String key = TextUtil.makeTranslationKey("biome", biome);
        return I18n.func_94522_b((String)key) ? TextUtil.translate(key) : TextUtil.literal(TextUtil.toPascalCase(biome.func_110623_a()));
    }

    public static String makeTranslationKey(String type, ResourceLocation id) {
        return type + '.' + id.func_110624_b() + '.' + id.func_110623_a().replace('/', '.');
    }

    public static ITextComponent wrap(ITextComponent text) {
        return TextUtil.translate("process.chunk_pregen.wrap", text);
    }

    public static ITextComponent dimensionMissing() {
        return TextUtil.translate("commands.chunk_pregen.error.missing_dimension");
    }

    public static ITextComponent creationFailed() {
        return TextUtil.translate("commands.chunk_pregen.error.creation_failed");
    }

    public static ITextComponent impossibleScenario() {
        return TextUtil.translateStyled("queue.chunk_pregen.errors.impossible", TextFormatting.RED);
    }

    public static ITextComponent minBiggerThenMax() {
        return TextUtil.translate("commands.chunk_pregen.error.min_bigger_max");
    }

    public static ITextComponent taskOverflow(long taskSize) {
        return TextUtil.translate("commands.chunk_pregen.error.task_overflow", "~" + TextUtil.findBestMemory(taskSize));
    }

    public static ITextComponent taskWarning(long taskSize, String taskId) {
        Style start = new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pregen continue " + taskId));
        Style delete = new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pregen clear " + taskId));
        return TextUtil.translate("commands.chunk_pregen.error.task_warning", "~" + TextUtil.findBestMemory(taskSize), TextUtil.mergeStyle(TextUtil.translate("commands.chunk_pregen.error.task_warning.start").func_150259_f(), start), TextUtil.mergeStyle(TextUtil.translate("commands.chunk_pregen.error.task_warning.delete").func_150259_f(), delete));
    }

    public static ITextComponent taskInfo(long taskSize) {
        return TextUtil.translate("commands.chunk_pregen.error.task_info", "~" + TextUtil.findBestMemory(taskSize));
    }

    public static ITextComponent ram() {
        return TextUtil.translate("process.chunk_pregen.ram", TextUtil.toMB(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()), TextUtil.toMB(Runtime.getRuntime().maxMemory()));
    }

    public static ITextComponent ram(long used, long total) {
        return TextUtil.translate("process.chunk_pregen.ram", TextUtil.toMB(used), TextUtil.toMB(total));
    }

    public static ITextComponent getModName(String id) {
        ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(id);
        return TextUtil.literal(container == null ? "Unknown" : container.getName());
    }

    public static String toPascalCase(String input) {
        StringBuilder builder = new StringBuilder();
        for (String s : input.split("[\\s-_]")) {
            builder.append(TextUtil.firstLetterUppercase(s)).append(" ");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static String findBestMemory(long input) {
        return TextUtil.findBestMemory(input, 1000);
    }

    public static String findBestMemory(long input, int threshold) {
        long actual = Math.abs(input);
        int layersFound = 0;
        for (int i = 0; i < DATA_TYPES.length && actual >= (long)threshold; ++i) {
            actual >>= 10;
            ++layersFound;
        }
        FORMAT.setMaximumFractionDigits(Math.max(0, actual >= 100L ? 0 : (actual >= 10L ? 1 : 2)));
        return FORMAT.format((double)input * (1.0 / (double)(1L << 10 * layersFound))) + DATA_TYPES[Math.min(DATA_TYPES.length - 1, layersFound)];
    }

    public static String getTime(long time) {
        return DurationFormatUtils.formatDuration((long)Math.abs(time), (String)(TimeUnit.MILLISECONDS.toDays(time) > 0L ? "d:HH:mm:ss" : "HH:mm:ss"));
    }

    private static long toMB(long base) {
        return base >> 20;
    }

    public static String firstLetterUppercase(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String first = Character.toString(string.charAt(0));
        return string.replaceFirst(first, first.toUpperCase());
    }

    public static long getWorldSize(long chunks, int dimension) {
        long base = DIMENSION_SIZES.getOrDefault(dimension, 12288L) + 4095L >> 12 << 12;
        return chunks * base;
    }

    public static long getUsedMemory(int dimension) {
        return TextUtil.getUsedMemory(DimensionManager.getProviderType((int)dimension));
    }

    public static long getUsedMemory(DimensionType dimension) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        String folder = dimension.func_186070_d().getSaveFolder();
        Path path = server.func_71254_M().func_186352_b(server.func_71270_I(), ".").toPath().resolve(folder == null ? "." : folder).resolve("region");
        if (Files.notExists(path, new LinkOption[0])) {
            return 0L;
        }
        Predicate<Path> isSymbolic = Files::isSymbolicLink;
        try {
            return Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(isSymbolic.negate()).mapToLong(TextUtil::fileSize).sum();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getUsedMemory() {
        Predicate<Path> isSymbolic = Files::isSymbolicLink;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        try {
            return Files.walk(server.func_71254_M().func_186352_b(server.func_71270_I(), ".").toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(isSymbolic.negate()).mapToLong(TextUtil::fileSize).sum();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long fileSize(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static boolean delete(Path path) {
        try {
            return Files.deleteIfExists(path);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static long getFreeMemory() {
        try {
            return Files.getFileStore(Loader.instance().getConfigDir().toPath().getParent()).getUsableSpace();
        }
        catch (IOException e) {
            return Long.MAX_VALUE;
        }
    }
}

