/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base;

import java.io.File;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import pregenerator.base.api.misc.IConfig;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.INetworkManager;
import pregenerator.base.impl.misc.PregenConfig;
import pregenerator.base.impl.misc.RenderManager;
import pregenerator.base.impl.networking.PacketHandler;

public class PregenAPI {
    public void init() {
    }

    public void postInit() {
        PermissionAPI.registerNode((String)"pregen-chunkview", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows Access to the ChunkView in the clientOnly part of Chunk Pregen");
    }

    public void registerTickEvent(Object obj) {
        MinecraftForge.EVENT_BUS.register(obj);
        FMLCommonHandler.instance().bus().register(obj);
    }

    public IConfig getConfig(File file) {
        return new PregenConfig(file);
    }

    public INetworkManager createNetworking() {
        return new PacketHandler().init();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHelper createRenderHelper() {
        RenderManager helper = new RenderManager();
        helper.init();
        return helper;
    }

    public void setState(World world, boolean active) {
        world.field_73011_w.func_186058_p().setLoadSpawn(active);
    }

    public boolean hasPermission(EntityPlayer player, String id) {
        return PermissionAPI.hasPermission((EntityPlayer)player, (String)id);
    }
}

