/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.utils;

import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;

public class SanityChecks {
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static ForkJoinPool WORK_POOL = ForkJoinPool.commonPool();
    private static boolean FORCE_IGNORE_PARALLELISM = false;
    private static ThreadLocal<Random> RANDOM = ThreadLocal.withInitial(Random::new);
    private static ThreadLocal<Boolean> FORCE_ASYNC = ThreadLocal.withInitial(() -> false);
    private static ThreadLocal<Boolean> FORCE_TASK_POOL = ThreadLocal.withInitial(() -> false);

    public static byte castToByte(int value) {
        if (value > 127 || value < -128) {
            throw new IllegalStateException("Value [" + value + "] out of Byte[-128,127] range");
        }
        return (byte)value;
    }

    public static short castToShort(int value) {
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw new IllegalStateException("Value [" + value + "] out of Short[-32768,32767] range");
        }
        return (short)value;
    }

    public static char castToChar(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalStateException("Value [" + value + "] out of Character[0,65535] range");
        }
        return (char)value;
    }

    public static float castToFloat(double value) {
        if (Double.isNaN(value)) {
            return Float.NaN;
        }
        if (Double.isInfinite(value)) {
            return value > 0.0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        if (value < -3.4028234663852886E38 || value > 3.4028234663852886E38) {
            throw new IllegalStateException("Value [" + value + "] out of Float range");
        }
        return (float)value;
    }

    public static void checkArrayCapacity(int arraySize, int offset, int accessSize) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset is negative (" + offset + ")");
        }
        if (accessSize < 0) {
            throw new IllegalArgumentException("Size is negative (" + accessSize + ")");
        }
        if (arraySize < offset + accessSize) {
            throw new IndexOutOfBoundsException("Index (" + (offset + accessSize) + ") is not in size (" + arraySize + ")");
        }
    }

    public static boolean canParallelTask() {
        return SanityChecks.getPool().getParallelism() > 1 || FORCE_IGNORE_PARALLELISM;
    }

    public static <T> void invokeTask(ForkJoinTask<T> task) {
        if (FORCE_ASYNC.get().booleanValue()) {
            SanityChecks.invokeAsyncTask(task);
        } else {
            SanityChecks.getPool().invoke(task);
        }
    }

    public static <T> void invokeAsyncTask(ForkJoinTask<T> task) {
        SanityChecks.getPool().execute(task);
    }

    public static void invokeAsyncTask(Runnable task) {
        SanityChecks.getPool().execute(task);
    }

    public static void setWorkPool(ForkJoinPool pool) {
        WORK_POOL = pool == null ? ForkJoinPool.commonPool() : pool;
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool pool;
        if (FORCE_TASK_POOL.get().booleanValue() && (pool = ForkJoinTask.getPool()) != null) {
            return pool;
        }
        return WORK_POOL;
    }

    public static boolean isForcedAsync() {
        return FORCE_ASYNC.get();
    }

    public static boolean isForcedTaskPool() {
        return FORCE_TASK_POOL.get();
    }

    public static void setForcedAsync(boolean value) {
        FORCE_ASYNC.set(value);
    }

    public static void setForcedTaskPool(boolean value) {
        FORCE_TASK_POOL.set(value);
    }

    public static void setForceIgnoreParallelism(boolean value) {
        FORCE_IGNORE_PARALLELISM = value;
    }

    public static Random getRandom() {
        return RANDOM.get();
    }
}

