/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.utils.maps;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import speiger.src.collections.objects.collections.ObjectBidirectionalIterator;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.ObjectSupplier;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.functions.function.UnaryOperator;
import speiger.src.collections.objects.maps.abstracts.AbstractObject2ObjectMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectOrderedMap;
import speiger.src.collections.objects.sets.ObjectOrderedSet;
import speiger.src.collections.objects.sets.ObjectSet;
import speiger.src.collections.objects.utils.ObjectCollections;
import speiger.src.collections.objects.utils.ObjectIterators;
import speiger.src.collections.objects.utils.ObjectSets;

public class Object2ObjectMaps {
    private static final Object2ObjectMap<?, ?> EMPTY = new EmptyMap();

    public static <T, V> Object2ObjectMap<T, V> empty() {
        return EMPTY;
    }

    public static <T, V> ObjectIterator<Object2ObjectMap.Entry<T, V>> fastIterator(Object2ObjectMap<T, V> map) {
        ObjectSet<Object2ObjectMap.Entry<T, V>> entries = map.object2ObjectEntrySet();
        return entries instanceof Object2ObjectMap.FastEntrySet ? ((Object2ObjectMap.FastEntrySet)entries).fastIterator() : entries.iterator();
    }

    public static <T, V> ObjectIterable<Object2ObjectMap.Entry<T, V>> fastIterable(Object2ObjectMap<T, V> map) {
        final ObjectSet<Object2ObjectMap.Entry<T, V>> entries = map.object2ObjectEntrySet();
        return map instanceof Object2ObjectMap.FastEntrySet ? new ObjectIterable<Object2ObjectMap.Entry<T, V>>(){

            @Override
            public ObjectIterator<Object2ObjectMap.Entry<T, V>> iterator() {
                return ((Object2ObjectMap.FastEntrySet)entries).fastIterator();
            }

            @Override
            public void forEach(Consumer<? super Object2ObjectMap.Entry<T, V>> action) {
                ((Object2ObjectMap.FastEntrySet)entries).fastForEach(action);
            }
        } : entries;
    }

    public static <T, V> void fastForEach(Object2ObjectMap<T, V> map, Consumer<Object2ObjectMap.Entry<T, V>> action) {
        ObjectSet<Object2ObjectMap.Entry<Object2ObjectMap.Entry<T, V>, V>> entries = map.object2ObjectEntrySet();
        if (entries instanceof Object2ObjectMap.FastEntrySet) {
            ((Object2ObjectMap.FastEntrySet)entries).fastForEach(action);
        } else {
            entries.forEach(action);
        }
    }

    public static <T, V> Object2ObjectMap<T, V> synchronize(Object2ObjectMap<T, V> map) {
        return map instanceof SynchronizedMap ? map : new SynchronizedMap(map);
    }

    public static <T, V> Object2ObjectMap<T, V> synchronize(Object2ObjectMap<T, V> map, Object mutex) {
        return map instanceof SynchronizedMap ? map : new SynchronizedMap(map, mutex);
    }

    public static <T, V> Object2ObjectOrderedMap<T, V> synchronize(Object2ObjectOrderedMap<T, V> map) {
        return map instanceof SynchronizedOrderedMap ? map : new SynchronizedOrderedMap(map);
    }

    public static <T, V> Object2ObjectOrderedMap<T, V> synchronize(Object2ObjectOrderedMap<T, V> map, Object mutex) {
        return map instanceof SynchronizedOrderedMap ? map : new SynchronizedOrderedMap(map, mutex);
    }

    public static <T, V> Object2ObjectMap<T, V> unmodifiable(Object2ObjectMap<T, V> map) {
        return map instanceof UnmodifyableMap ? map : new UnmodifyableMap(map);
    }

    public static <T, V> Object2ObjectOrderedMap<T, V> unmodifiable(Object2ObjectOrderedMap<T, V> map) {
        return map instanceof UnmodifyableOrderedMap ? map : new UnmodifyableOrderedMap(map);
    }

    public static <T, V> Object2ObjectMap.Entry<T, V> unmodifiable(Object2ObjectMap.Entry<T, V> entry) {
        return entry instanceof UnmodifyableEntry ? entry : (entry == null ? null : new UnmodifyableEntry(entry));
    }

    public static <T, V> Object2ObjectMap.Entry<T, V> unmodifiable(Map.Entry<T, V> entry) {
        return entry instanceof UnmodifyableEntry ? (UnmodifyableEntry)entry : (entry == null ? null : new UnmodifyableEntry<T, V>(entry));
    }

    public static <T, V> Object2ObjectMap<T, V> singleton(T key, V value) {
        return new SingletonMap<T, V>(key, value);
    }

    public static class SynchronizedMap<T, V>
    extends AbstractObject2ObjectMap<T, V>
    implements Object2ObjectMap<T, V> {
        Object2ObjectMap<T, V> map;
        ObjectCollection<V> values;
        ObjectSet<T> keys;
        ObjectSet<Object2ObjectMap.Entry<T, V>> entrySet;
        protected Object mutex;

        SynchronizedMap(Object2ObjectMap<T, V> map) {
            this.map = map;
            this.mutex = this;
        }

        SynchronizedMap(Object2ObjectMap<T, V> map, Object mutex) {
            this.map = map;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getDefaultReturnValue() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.getDefaultReturnValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractObject2ObjectMap<T, V> setDefaultReturnValue(V v) {
            Object object = this.mutex;
            synchronized (object) {
                this.map.setDefaultReturnValue(v);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(T key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(T key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.putIfAbsent(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAllIfAbsent(Object2ObjectMap<T, V> m) {
            Object object = this.mutex;
            synchronized (object) {
                this.map.putAllIfAbsent(m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Object2ObjectMap<T, V> m) {
            Object object = this.mutex;
            synchronized (object) {
                this.map.putAll(m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends T, ? extends V> m) {
            Object object = this.mutex;
            synchronized (object) {
                this.map.putAll(m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(T[] keys, V[] values, int offset, int size) {
            Object object = this.mutex;
            synchronized (object) {
                this.map.putAll(keys, values, offset, size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getObject(T key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.getObject(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V rem(T key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.rem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remOrDefault(T key, V defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.remOrDefault(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replace(T key, V oldValue, V newValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.replace(key, oldValue, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V replace(T key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.replace(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceObjects(Object2ObjectMap<T, V> m) {
            Object object = this.mutex;
            synchronized (object) {
                this.map.replaceObjects(m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceObjects(ObjectObjectUnaryOperator<T, V> mappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                this.map.replaceObjects(mappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V compute(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.compute(key, mappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfAbsent(T key, UnaryOperator<T, V> mappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.computeIfAbsent(key, mappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfPresent(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.computeIfPresent(key, mappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V supplyIfAbsent(T key, ObjectSupplier<V> valueProvider) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.supplyIfAbsent(key, valueProvider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V merge(T key, V value, ObjectObjectUnaryOperator<V, V> mappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.merge(key, value, mappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mergeAll(Object2ObjectMap<T, V> m, ObjectObjectUnaryOperator<V, V> mappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                this.map.mergeAll(m, mappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(ObjectObjectConsumer<T, V> action) {
            Object object = this.mutex;
            synchronized (object) {
                this.map.forEach(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object2ObjectMap<T, V> copy() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.copy();
            }
        }

        @Override
        public ObjectSet<T> keySet() {
            if (this.keys == null) {
                this.keys = ObjectSets.synchronize(this.map.keySet(), this.mutex);
            }
            return this.keys;
        }

        @Override
        public ObjectCollection<V> values() {
            if (this.values == null) {
                this.values = ObjectCollections.synchronize(this.map.values(), this.mutex);
            }
            return this.values;
        }

        @Override
        public ObjectSet<Object2ObjectMap.Entry<T, V>> object2ObjectEntrySet() {
            if (this.entrySet == null) {
                this.entrySet = ObjectSets.synchronize(this.map.object2ObjectEntrySet(), this.mutex);
            }
            return this.entrySet;
        }
    }

    public static class SynchronizedOrderedMap<T, V>
    extends SynchronizedMap<T, V>
    implements Object2ObjectOrderedMap<T, V> {
        Object2ObjectOrderedMap<T, V> map;

        SynchronizedOrderedMap(Object2ObjectOrderedMap<T, V> map) {
            super(map);
            this.map = map;
        }

        SynchronizedOrderedMap(Object2ObjectOrderedMap<T, V> map, Object mutex) {
            super(map, mutex);
            this.map = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putAndMoveToFirst(T key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.putAndMoveToFirst(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putAndMoveToLast(T key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.putAndMoveToLast(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveToFirst(T key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.moveToFirst(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveToLast(T key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.moveToLast(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getAndMoveToFirst(T key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.getAndMoveToFirst(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getAndMoveToLast(T key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.getAndMoveToLast(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T pollFirstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.pollFirstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T pollLastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.pollLastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V firstValue() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.firstValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V lastValue() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.lastValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object2ObjectOrderedMap<T, V> copy() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.copy();
            }
        }

        @Override
        public ObjectOrderedSet<T> keySet() {
            if (this.keys == null) {
                this.keys = ObjectSets.synchronize(this.map.keySet(), this.mutex);
            }
            return (ObjectOrderedSet)this.keys;
        }

        @Override
        public ObjectOrderedSet<Object2ObjectMap.Entry<T, V>> object2ObjectEntrySet() {
            if (this.entrySet == null) {
                this.entrySet = ObjectSets.synchronize(this.map.object2ObjectEntrySet(), this.mutex);
            }
            return (ObjectOrderedSet)this.entrySet;
        }
    }

    public static class UnmodifyableEntrySet<T, V>
    extends ObjectSets.UnmodifiableSet<Object2ObjectMap.Entry<T, V>> {
        ObjectSet<Object2ObjectMap.Entry<T, V>> s;

        UnmodifyableEntrySet(ObjectSet<Object2ObjectMap.Entry<T, V>> c) {
            super(c);
            this.s = c;
        }

        @Override
        public void forEach(Consumer<? super Object2ObjectMap.Entry<T, V>> action) {
            this.s.forEach((? super T T) -> action.accept(Object2ObjectMaps.unmodifiable(T)));
        }

        @Override
        public ObjectIterator<Object2ObjectMap.Entry<T, V>> iterator() {
            return new ObjectIterator<Object2ObjectMap.Entry<T, V>>(){
                ObjectIterator<Object2ObjectMap.Entry<T, V>> iter;
                {
                    this.iter = s.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Object2ObjectMap.Entry<T, V> next() {
                    return Object2ObjectMaps.unmodifiable((Object2ObjectMap.Entry)this.iter.next());
                }
            };
        }
    }

    public static class UnmodifyableOrderedEntrySet<T, V>
    extends UnmodifyableEntrySet<T, V>
    implements ObjectOrderedSet<Object2ObjectMap.Entry<T, V>> {
        ObjectOrderedSet<Object2ObjectMap.Entry<T, V>> set;

        UnmodifyableOrderedEntrySet(ObjectOrderedSet<Object2ObjectMap.Entry<T, V>> c) {
            super(c);
            this.set = c;
        }

        @Override
        public boolean addAndMoveToFirst(Object2ObjectMap.Entry<T, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAndMoveToLast(Object2ObjectMap.Entry<T, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToFirst(Object2ObjectMap.Entry<T, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToLast(Object2ObjectMap.Entry<T, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectOrderedSet<Object2ObjectMap.Entry<T, V>> copy() {
            return this.set.copy();
        }

        @Override
        public ObjectBidirectionalIterator<Object2ObjectMap.Entry<T, V>> iterator() {
            return ObjectIterators.unmodifiable(this.set.iterator());
        }

        @Override
        public ObjectBidirectionalIterator<Object2ObjectMap.Entry<T, V>> iterator(Object2ObjectMap.Entry<T, V> fromElement) {
            return ObjectIterators.unmodifiable(this.set.iterator(fromElement));
        }

        @Override
        public Object2ObjectMap.Entry<T, V> first() {
            return this.set.first();
        }

        @Override
        public Object2ObjectMap.Entry<T, V> pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object2ObjectMap.Entry<T, V> last() {
            return this.set.last();
        }

        @Override
        public Object2ObjectMap.Entry<T, V> pollLast() {
            throw new UnsupportedOperationException();
        }
    }

    public static class UnmodifyableMap<T, V>
    extends AbstractObject2ObjectMap<T, V>
    implements Object2ObjectMap<T, V> {
        Object2ObjectMap<T, V> map;
        ObjectCollection<V> values;
        ObjectSet<T> keys;
        ObjectSet<Object2ObjectMap.Entry<T, V>> entrySet;

        UnmodifyableMap(Object2ObjectMap<T, V> map) {
            this.map = map;
        }

        @Override
        public V put(T key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(T key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V rem(T key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remOrDefault(T key, V defaultValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V getObject(T key) {
            V type = this.map.getObject(key);
            return Objects.equals(type, this.map.getDefaultReturnValue()) && !this.map.containsKey(key) ? this.getDefaultReturnValue() : type;
        }

        @Override
        public V compute(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(T key, UnaryOperator<T, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V supplyIfAbsent(T key, ObjectSupplier<V> valueProvider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(T key, V value, ObjectObjectUnaryOperator<V, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void mergeAll(Object2ObjectMap<T, V> m, ObjectObjectUnaryOperator<V, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceObjects(ObjectObjectUnaryOperator<T, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceObjects(Object2ObjectMap<T, V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object2ObjectMap<T, V> copy() {
            return this.map.copy();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSet<T> keySet() {
            if (this.keys == null) {
                this.keys = ObjectSets.unmodifiable(this.map.keySet());
            }
            return this.keys;
        }

        @Override
        public ObjectCollection<V> values() {
            if (this.values == null) {
                this.values = ObjectCollections.unmodifiable(this.map.values());
            }
            return this.values;
        }

        @Override
        public ObjectSet<Object2ObjectMap.Entry<T, V>> object2ObjectEntrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifyableEntrySet<T, V>(this.map.object2ObjectEntrySet());
            }
            return this.entrySet;
        }
    }

    public static class UnmodifyableOrderedMap<T, V>
    extends UnmodifyableMap<T, V>
    implements Object2ObjectOrderedMap<T, V> {
        Object2ObjectOrderedMap<T, V> map;

        UnmodifyableOrderedMap(Object2ObjectOrderedMap<T, V> map) {
            super(map);
            this.map = map;
        }

        @Override
        public V putAndMoveToFirst(T key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putAndMoveToLast(T key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToFirst(T key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToLast(T key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V getAndMoveToFirst(T key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V getAndMoveToLast(T key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T firstKey() {
            return this.map.firstKey();
        }

        @Override
        public T pollFirstKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T lastKey() {
            return this.map.lastKey();
        }

        @Override
        public T pollLastKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V firstValue() {
            return this.map.firstValue();
        }

        @Override
        public V lastValue() {
            return this.map.lastValue();
        }

        @Override
        public Object2ObjectOrderedMap<T, V> copy() {
            return this.map.copy();
        }

        @Override
        public ObjectOrderedSet<T> keySet() {
            if (this.keys == null) {
                this.keys = ObjectSets.unmodifiable(this.map.keySet());
            }
            return (ObjectOrderedSet)this.keys;
        }

        @Override
        public ObjectOrderedSet<Object2ObjectMap.Entry<T, V>> object2ObjectEntrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifyableOrderedEntrySet(this.map.object2ObjectEntrySet());
            }
            return (ObjectOrderedSet)this.entrySet;
        }
    }

    public static class UnmodifyableEntry<T, V>
    extends AbstractObject2ObjectMap.BasicEntry<T, V> {
        UnmodifyableEntry(Map.Entry<T, V> entry) {
            super(entry.getKey(), entry.getValue());
        }

        UnmodifyableEntry(Object2ObjectMap.Entry<T, V> entry) {
            super(entry.getKey(), entry.getValue());
        }

        @Override
        public void set(T key, V value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class EmptyMap<T, V>
    extends AbstractObject2ObjectMap<T, V> {
        @Override
        public V put(T key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(T key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V rem(T key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remOrDefault(T key, V defaultValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V getObject(T key) {
            return this.getDefaultReturnValue();
        }

        @Override
        public V compute(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(T key, UnaryOperator<T, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V supplyIfAbsent(T key, ObjectSupplier<V> valueProvider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(T key, V value, ObjectObjectUnaryOperator<V, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void mergeAll(Object2ObjectMap<T, V> m, ObjectObjectUnaryOperator<V, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSet<T> keySet() {
            return ObjectSets.empty();
        }

        @Override
        public ObjectCollection<V> values() {
            return ObjectCollections.empty();
        }

        @Override
        public ObjectSet<Object2ObjectMap.Entry<T, V>> object2ObjectEntrySet() {
            return ObjectSets.empty();
        }

        @Override
        public EmptyMap<T, V> copy() {
            return this;
        }
    }

    public static class SingletonMap<T, V>
    extends AbstractObject2ObjectMap<T, V> {
        final T key;
        final V value;
        ObjectSet<T> keySet;
        ObjectCollection<V> values;
        ObjectSet<Object2ObjectMap.Entry<T, V>> entrySet;

        SingletonMap(T key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public V put(T key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(T key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V rem(T key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remOrDefault(T key, V defaultValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V getObject(T key) {
            return Objects.equals(this.key, key) ? this.value : this.getDefaultReturnValue();
        }

        @Override
        public V compute(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(T key, UnaryOperator<T, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V supplyIfAbsent(T key, ObjectSupplier<V> valueProvider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(T key, V value, ObjectObjectUnaryOperator<V, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void mergeAll(Object2ObjectMap<T, V> m, ObjectObjectUnaryOperator<V, V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SingletonMap<T, V> copy() {
            return new SingletonMap<T, V>(this.key, this.value);
        }

        @Override
        public ObjectSet<T> keySet() {
            if (this.keySet == null) {
                this.keySet = ObjectSets.singleton(this.key);
            }
            return this.keySet;
        }

        @Override
        public ObjectCollection<V> values() {
            if (this.values == null) {
                this.values = ObjectCollections.singleton(this.value);
            }
            return this.values;
        }

        @Override
        public ObjectSet<Object2ObjectMap.Entry<T, V>> object2ObjectEntrySet() {
            if (this.entrySet == null) {
                this.entrySet = ObjectSets.singleton(new AbstractObject2ObjectMap.BasicEntry<T, V>(this.key, this.value));
            }
            return this.entrySet;
        }
    }
}

