/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.utils;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import speiger.src.collections.objects.collections.ObjectBidirectionalIterator;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.UnaryOperator;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.lists.ObjectList;
import speiger.src.collections.objects.lists.ObjectListIterator;
import speiger.src.collections.objects.utils.ObjectCollections;

public class ObjectIterators {
    private static final EmptyIterator<?> EMPTY = new EmptyIterator();

    public static <T> EmptyIterator<T> empty() {
        return EMPTY;
    }

    public static <T> ObjectBidirectionalIterator<T> invert(ObjectBidirectionalIterator<T> it) {
        return it instanceof ReverseBiIterator ? ((ReverseBiIterator)it).it : new ReverseBiIterator<T>(it);
    }

    public static <T> ObjectListIterator<T> invert(ObjectListIterator<T> it) {
        return it instanceof ReverseListIterator ? ((ReverseListIterator)it).it : new ReverseListIterator<T>(it);
    }

    public static <T> ObjectIterator<T> unmodifiable(ObjectIterator<T> iterator) {
        return iterator instanceof UnmodifiableIterator ? iterator : new UnmodifiableIterator(iterator);
    }

    public static <T> ObjectBidirectionalIterator<T> unmodifiable(ObjectBidirectionalIterator<T> iterator) {
        return iterator instanceof UnmodifiableBiIterator ? iterator : new UnmodifiableBiIterator(iterator);
    }

    public static <T> ObjectListIterator<T> unmodifiable(ObjectListIterator<T> iterator) {
        return iterator instanceof UnmodifiableListIterator ? iterator : new UnmodifiableListIterator(iterator);
    }

    public static <T, E> ObjectIterator<E> map(Iterator<? extends T> iterator, UnaryOperator<T, E> mapper) {
        return new MappedIterator<T, E>(ObjectIterators.wrap(iterator), mapper);
    }

    public static <T, E> ObjectIterator<E> map(ObjectIterator<T> iterator, UnaryOperator<T, E> mapper) {
        return new MappedIterator<T, E>(iterator, mapper);
    }

    public static <T, E, V extends Iterable<E>> ObjectIterator<E> flatMap(Iterator<? extends T> iterator, UnaryOperator<T, V> mapper) {
        return new FlatMappedIterator(ObjectIterators.wrap(iterator), mapper);
    }

    public static <T, E, V extends Iterable<E>> ObjectIterator<E> flatMap(ObjectIterator<T> iterator, UnaryOperator<T, V> mapper) {
        return new FlatMappedIterator(iterator, mapper);
    }

    public static <T, E> ObjectIterator<E> arrayFlatMap(Iterator<? extends T> iterator, UnaryOperator<T, E[]> mapper) {
        return new FlatMappedArrayIterator(ObjectIterators.wrap(iterator), mapper);
    }

    public static <T, E> ObjectIterator<E> arrayFlatMap(ObjectIterator<T> iterator, UnaryOperator<T, E[]> mapper) {
        return new FlatMappedArrayIterator(iterator, mapper);
    }

    public static <T> ObjectIterator<T> filter(Iterator<? extends T> iterator, Predicate<T> filter) {
        return new FilteredIterator<T>(ObjectIterators.wrap(iterator), filter);
    }

    public static <T> ObjectIterator<T> filter(ObjectIterator<T> iterator, Predicate<T> filter) {
        return new FilteredIterator<T>(iterator, filter);
    }

    public static <T> ObjectIterator<T> distinct(ObjectIterator<T> iterator) {
        return new DistinctIterator<T>(iterator);
    }

    public static <T> ObjectIterator<T> distinct(Iterator<? extends T> iterator) {
        return new DistinctIterator<T>(ObjectIterators.wrap(iterator));
    }

    public static <T> ObjectIterator<T> repeat(ObjectIterator<T> iterator, int repeats) {
        return new RepeatingIterator<T>(iterator, repeats);
    }

    public static <T> ObjectIterator<T> repeat(Iterator<? extends T> iterator, int repeats) {
        return new RepeatingIterator<T>(ObjectIterators.wrap(iterator), repeats);
    }

    public static <T> ObjectIterator<T> infinite(ObjectIterator<T> iterator) {
        return new InfiniteIterator<T>(iterator);
    }

    public static <T> ObjectIterator<T> infinite(Iterator<? extends T> iterator) {
        return new InfiniteIterator<T>(ObjectIterators.wrap(iterator));
    }

    public static <T> ObjectIterator<T> limit(ObjectIterator<T> iterator, long limit) {
        return new LimitedIterator<T>(iterator, limit);
    }

    public static <T> ObjectIterator<T> limit(Iterator<? extends T> iterator, long limit) {
        return new LimitedIterator<T>(ObjectIterators.wrap(iterator), limit);
    }

    public static <T> ObjectIterator<T> sorted(ObjectIterator<T> iterator, Comparator<T> sorter) {
        return new SortedIterator<T>(iterator, sorter);
    }

    public static <T> ObjectIterator<T> sorted(Iterator<? extends T> iterator, Comparator<T> sorter) {
        return new SortedIterator<T>(ObjectIterators.wrap(iterator), sorter);
    }

    public static <T> ObjectIterator<T> peek(ObjectIterator<T> iterator, Consumer<T> action) {
        return new PeekIterator<T>(iterator, action);
    }

    public static <T> ObjectIterator<T> peek(Iterator<? extends T> iterator, Consumer<T> action) {
        return new PeekIterator<T>(ObjectIterators.wrap(iterator), action);
    }

    public static <T> ObjectIterator<T> wrap(Iterator<? extends T> iterator) {
        return iterator instanceof ObjectIterator ? (ObjectIterator<Object>)iterator : new IteratorWrapper<T>(iterator);
    }

    public static <T> ArrayIterator<T> wrap(T ... a) {
        return ObjectIterators.wrap(a, 0, a.length);
    }

    public static <T> ArrayIterator<T> wrap(T[] a, int start, int end) {
        return new ArrayIterator<T>(a, start, end);
    }

    public static <T> int unwrap(T[] a, Iterator<? extends T> i) {
        return ObjectIterators.unwrap(a, i, 0, a.length);
    }

    public static <T> int unwrap(T[] a, Iterator<? extends T> i, int offset) {
        return ObjectIterators.unwrap(a, i, offset, a.length - offset);
    }

    public static <T> int unwrap(T[] a, Iterator<? extends T> i, int offset, int max) {
        int index;
        if (max < 0) {
            throw new IllegalStateException("The max size is smaller then 0");
        }
        if (offset + max > a.length) {
            throw new IllegalStateException("largest array index exceeds array size");
        }
        for (index = 0; index < max && i.hasNext(); ++index) {
            a[index + offset] = i.next();
        }
        return index;
    }

    public static <T> int unwrap(T[] a, ObjectIterator<T> i) {
        return ObjectIterators.unwrap(a, i, 0, a.length);
    }

    public static <T> int unwrap(T[] a, ObjectIterator<T> i, int offset) {
        return ObjectIterators.unwrap(a, i, offset, a.length - offset);
    }

    public static <T> int unwrap(T[] a, ObjectIterator<T> i, int offset, int max) {
        int index;
        if (max < 0) {
            throw new IllegalStateException("The max size is smaller then 0");
        }
        if (offset + max > a.length) {
            throw new IllegalStateException("largest array index exceeds array size");
        }
        for (index = 0; index < max && i.hasNext(); ++index) {
            a[index + offset] = i.next();
        }
        return index;
    }

    public static <T> ObjectList<T> pour(ObjectIterator<T> iter) {
        return ObjectIterators.pour(iter, Integer.MAX_VALUE);
    }

    public static <T> ObjectList<T> pour(ObjectIterator<T> iter, int max) {
        ObjectArrayList list = new ObjectArrayList();
        ObjectIterators.pour(iter, list, max);
        list.trim();
        return list;
    }

    public static <T> int pour(ObjectIterator<T> iter, ObjectCollection<T> c) {
        return ObjectIterators.pour(iter, c, Integer.MAX_VALUE);
    }

    public static <T> int pour(ObjectIterator<T> iter, ObjectCollection<T> c, int max) {
        int done;
        if (max < 0) {
            throw new IllegalStateException("Max is negative");
        }
        for (done = 0; done < max && iter.hasNext(); ++done) {
            c.add(iter.next());
        }
        return done;
    }

    public static <T> ObjectIterator<T> concat(ObjectIterator<T> ... array) {
        return ObjectIterators.concat(array, 0, array.length);
    }

    public static <T> ObjectIterator<T> concat(ObjectIterator<T>[] array, int offset, int length) {
        return new ConcatIterator<T>(array, offset, length);
    }

    private static class PeekIterator<T>
    implements ObjectIterator<T> {
        ObjectIterator<T> iterator;
        Consumer<T> action;

        public PeekIterator(ObjectIterator<T> iterator, Consumer<T> action) {
            this.iterator = iterator;
            this.action = action;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.iterator.next();
            this.action.accept(result);
            return (T)result;
        }
    }

    private static class LimitedIterator<T>
    implements ObjectIterator<T> {
        ObjectIterator<T> iterator;
        long limit;

        public LimitedIterator(ObjectIterator<T> iterator, long limit) {
            this.iterator = iterator;
            this.limit = limit;
        }

        @Override
        public boolean hasNext() {
            return this.limit > 0L && this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.limit;
            return (T)this.iterator.next();
        }
    }

    private static class FilteredIterator<T>
    implements ObjectIterator<T> {
        ObjectIterator<T> iterator;
        Predicate<T> filter;
        T lastFound;
        boolean foundNext = false;

        public FilteredIterator(ObjectIterator<T> iterator, Predicate<T> filter) {
            this.iterator = iterator;
            this.filter = filter;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            while (this.iterator.hasNext()) {
                this.lastFound = this.iterator.next();
                if (!this.filter.test(this.lastFound)) continue;
                this.foundNext = true;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.foundNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.foundNext = false;
            return this.lastFound;
        }
    }

    private static class DistinctIterator<T>
    implements ObjectIterator<T> {
        ObjectIterator<T> iterator;
        ObjectCollection<T> filtered = ObjectCollections.distinctWrapper();
        T lastFound;
        boolean foundNext = false;

        public DistinctIterator(ObjectIterator<T> iterator) {
            this.iterator = iterator;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            while (this.iterator.hasNext()) {
                this.lastFound = this.iterator.next();
                if (!this.filtered.add(this.lastFound)) continue;
                this.foundNext = true;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.foundNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.foundNext = false;
            return this.lastFound;
        }
    }

    private static class SortedIterator<T>
    implements ObjectIterator<T> {
        ObjectIterator<T> iterator;
        Comparator<T> sorter;
        ObjectCollections.CollectionWrapper<T> sortedElements = null;
        int index = 0;

        public SortedIterator(ObjectIterator<T> iterator, Comparator<T> sorter) {
            this.iterator = iterator;
            this.sorter = sorter;
        }

        @Override
        public boolean hasNext() {
            if (this.sortedElements == null) {
                boolean hasNext = this.iterator.hasNext();
                if (hasNext) {
                    this.sortedElements = ObjectCollections.wrapper();
                    ObjectIterators.pour(this.iterator, this.sortedElements);
                } else {
                    this.sortedElements = ObjectCollections.wrapper();
                }
                if (hasNext) {
                    this.sortedElements.unstableSort(this.sorter);
                }
            }
            return this.index < this.sortedElements.size();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.sortedElements.get(this.index++);
        }
    }

    private static class RepeatingIterator<T>
    implements ObjectIterator<T> {
        final int repeats;
        int index = 0;
        ObjectIterator<T> iter;
        ObjectCollection<T> repeater = ObjectCollections.wrapper();

        public RepeatingIterator(ObjectIterator<T> iter, int repeat) {
            this.iter = iter;
            this.repeats = repeat;
        }

        @Override
        public boolean hasNext() {
            if (this.iter.hasNext()) {
                return true;
            }
            if (this.index < this.repeats) {
                ++this.index;
                this.iter = this.repeater.iterator();
                return this.iter.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object value = this.iter.next();
            if (this.index == 0) {
                this.repeater.add(value);
            }
            return (T)value;
        }
    }

    private static class InfiniteIterator<T>
    implements ObjectIterator<T> {
        ObjectIterator<T> iter;
        ObjectCollections.CollectionWrapper<T> looper = ObjectCollections.wrapper();
        int index = 0;

        public InfiniteIterator(ObjectIterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public T next() {
            if (this.iter != null) {
                if (this.iter.hasNext()) {
                    Object value = this.iter.next();
                    this.looper.add(value);
                    return (T)value;
                }
                this.iter = null;
            }
            return this.looper.get(this.index++ % this.looper.size());
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            throw new UnsupportedOperationException("This is a instant deadlock, so unsupported");
        }

        @Override
        public <E> void forEachRemaining(E input, ObjectObjectConsumer<E, T> action) {
            throw new UnsupportedOperationException("This is a instant deadlock, so unsupported");
        }
    }

    private static class FlatMappedArrayIterator<E, T>
    implements ObjectIterator<T> {
        ObjectIterator<E> iterator;
        Iterator<T> last = null;
        UnaryOperator<E, T[]> mapper;
        boolean foundNext = false;

        FlatMappedArrayIterator(ObjectIterator<E> iterator, UnaryOperator<E, T[]> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            this.foundNext = true;
            while (this.iterator.hasNext()) {
                if (this.last != null && this.last.hasNext()) {
                    return;
                }
                this.last = ObjectIterators.wrap(this.mapper.apply(this.iterator.next()));
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.last != null && this.last.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.last.next();
            this.foundNext = false;
            return result;
        }
    }

    private static class FlatMappedIterator<E, T, V extends Iterable<T>>
    implements ObjectIterator<T> {
        ObjectIterator<E> iterator;
        Iterator<T> last = null;
        UnaryOperator<E, V> mapper;
        boolean foundNext = false;

        FlatMappedIterator(ObjectIterator<E> iterator, UnaryOperator<E, V> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            this.foundNext = true;
            while (this.iterator.hasNext()) {
                if (this.last != null && this.last.hasNext()) {
                    return;
                }
                this.last = ((Iterable)this.mapper.apply(this.iterator.next())).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.last != null && this.last.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.last.next();
            this.foundNext = false;
            return result;
        }
    }

    private static class MappedIterator<E, T>
    implements ObjectIterator<T> {
        ObjectIterator<E> iterator;
        UnaryOperator<E, T> mapper;

        MappedIterator(ObjectIterator<E> iterator, UnaryOperator<E, T> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.mapper.apply(this.iterator.next());
        }

        @Override
        public int skip(int amount) {
            return this.iterator.skip(amount);
        }
    }

    private static class ArrayIterator<T>
    implements ObjectIterator<T> {
        T[] a;
        int from;
        int to;

        ArrayIterator(T[] a, int from, int to) {
            this.a = a;
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean hasNext() {
            return this.from < this.to;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.a[this.from++];
        }

        @Override
        public int skip(int amount) {
            if (amount < 0) {
                throw new IllegalStateException("Negative Numbers are not allowed");
            }
            int left = Math.min(amount, this.to - this.from);
            this.from += left;
            return amount - left;
        }
    }

    private static class EmptyIterator<T>
    implements ObjectListIterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public T previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableIterator<T>
    implements ObjectIterator<T> {
        ObjectIterator<T> iterator;

        UnmodifiableIterator(ObjectIterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return (T)this.iterator.next();
        }
    }

    private static class UnmodifiableBiIterator<T>
    implements ObjectBidirectionalIterator<T> {
        ObjectBidirectionalIterator<T> iter;

        UnmodifiableBiIterator(ObjectBidirectionalIterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public T next() {
            return (T)this.iter.next();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public T previous() {
            return this.iter.previous();
        }
    }

    private static class UnmodifiableListIterator<T>
    implements ObjectListIterator<T> {
        ObjectListIterator<T> iter;

        UnmodifiableListIterator(ObjectListIterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T previous() {
            return (T)this.iter.previous();
        }

        @Override
        public T next() {
            return (T)this.iter.next();
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReverseListIterator<T>
    implements ObjectListIterator<T> {
        ObjectListIterator<T> it;

        ReverseListIterator(ObjectListIterator<T> it) {
            this.it = it;
        }

        @Override
        public T next() {
            return (T)this.it.previous();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public T previous() {
            return (T)this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public int nextIndex() {
            return this.it.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.nextIndex();
        }

        @Override
        public void set(T e) {
            this.it.set(e);
        }

        @Override
        public void add(T e) {
            this.it.add(e);
        }
    }

    private static class ReverseBiIterator<T>
    implements ObjectBidirectionalIterator<T> {
        ObjectBidirectionalIterator<T> it;

        ReverseBiIterator(ObjectBidirectionalIterator<T> it) {
            this.it = it;
        }

        @Override
        public T next() {
            return this.it.previous();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public T previous() {
            return (T)this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    private static class ConcatIterator<T>
    implements ObjectIterator<T> {
        ObjectIterator<T>[] iters;
        int offset;
        int lastOffset = -1;
        int length;

        public ConcatIterator(ObjectIterator<T>[] iters, int offset, int length) {
            this.iters = iters;
            this.offset = offset;
            this.length = length;
            this.find();
        }

        private void find() {
            while (this.length != 0 && !this.iters[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        @Override
        public boolean hasNext() {
            return this.length > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            Object result = this.iters[this.lastOffset].next();
            this.find();
            return (T)result;
        }

        @Override
        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.iters[this.lastOffset].remove();
            this.lastOffset = -1;
        }
    }

    private static class IteratorWrapper<T>
    implements ObjectIterator<T> {
        Iterator<? extends T> iter;

        public IteratorWrapper(Iterator<? extends T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.iter.next();
        }
    }
}

