/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.objects.collections.AbstractObjectCollection;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.utils.ObjectArrays;
import speiger.src.collections.objects.utils.ObjectIterators;
import speiger.src.collections.utils.HashUtil;
import speiger.src.collections.utils.ITrimmable;

public class ObjectCollections {
    public static final ObjectCollection<?> EMPTY = new EmptyCollection();

    public static <T> ObjectCollection<T> empty() {
        return EMPTY;
    }

    public static <T> ObjectCollection<T> unmodifiable(ObjectCollection<T> c) {
        return c instanceof UnmodifiableCollection ? c : new UnmodifiableCollection(c);
    }

    public static <T> ObjectCollection<T> synchronize(ObjectCollection<T> c) {
        return c instanceof SynchronizedCollection ? c : new SynchronizedCollection(c);
    }

    public static <T> ObjectCollection<T> synchronize(ObjectCollection<T> c, Object mutex) {
        return c instanceof SynchronizedCollection ? c : new SynchronizedCollection(c, mutex);
    }

    public static <T> ObjectCollection<T> singleton(T element) {
        return new SingletonCollection<T>(element);
    }

    protected static <T> CollectionWrapper<T> wrapper() {
        return new CollectionWrapper();
    }

    protected static <T> CollectionWrapper<T> wrapper(int size) {
        return new CollectionWrapper(size);
    }

    protected static <T> DistinctCollectionWrapper<T> distinctWrapper() {
        return new DistinctCollectionWrapper();
    }

    protected static <T> DistinctCollectionWrapper<T> distinctWrapper(int size) {
        return new DistinctCollectionWrapper(size);
    }

    public static class EmptyCollection<T>
    extends AbstractObjectCollection<T> {
        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ObjectCollection<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(T[] e, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean containsAny(Collection<?> c) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Collection)) {
                return false;
            }
            return ((Collection)o).isEmpty();
        }

        @Override
        @Deprecated
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(ObjectCollection<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(ObjectCollection<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return ObjectArrays.EMPTY_ARRAY;
        }

        @Override
        public <E> E[] toArray(E[] a) {
            if (a != null && a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.empty();
        }

        @Override
        public void clear() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public EmptyCollection<T> copy() {
            return this;
        }
    }

    public static class UnmodifiableCollection<T>
    implements ObjectCollection<T> {
        ObjectCollection<T> c;

        UnmodifiableCollection(ObjectCollection<T> c) {
            this.c = c;
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ObjectCollection<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(T[] e, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        @Override
        public boolean containsAll(ObjectCollection<T> c) {
            return this.c.containsAll(c);
        }

        @Override
        public boolean containsAny(ObjectCollection<T> c) {
            return this.c.containsAny(c);
        }

        @Override
        public boolean containsAny(Collection<?> c) {
            return this.c.containsAny(c);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.c.containsAll(c);
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.unmodifiable(this.c.iterator());
        }

        @Override
        public ObjectCollection<T> copy() {
            return this.c.copy();
        }

        @Override
        @Deprecated
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(ObjectCollection<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(ObjectCollection<T> c, Consumer<T> r) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(ObjectCollection<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(ObjectCollection<T> c, Consumer<T> r) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            return this.c.toArray(a);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            this.c.forEach(action);
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<T> action) {
            this.c.forEachIndexed(action);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || this.c.equals(obj);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, T> action) {
            this.c.forEach(input, action);
        }

        @Override
        public boolean matchesAny(Predicate<T> filter) {
            return this.c.matchesAny(filter);
        }

        @Override
        public boolean matchesNone(Predicate<T> filter) {
            return this.c.matchesNone(filter);
        }

        @Override
        public boolean matchesAll(Predicate<T> filter) {
            return this.c.matchesAll(filter);
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, T, E> operator) {
            return this.c.reduce(identity, operator);
        }

        @Override
        public T reduce(ObjectObjectUnaryOperator<T, T> operator) {
            return this.c.reduce(operator);
        }

        @Override
        public T findFirst(Predicate<T> filter) {
            return this.c.findFirst(filter);
        }

        @Override
        public int count(Predicate<T> filter) {
            return this.c.count(filter);
        }
    }

    public static class SynchronizedCollection<T>
    implements ObjectCollection<T> {
        ObjectCollection<T> c;
        protected Object mutex;

        SynchronizedCollection(ObjectCollection<T> c) {
            this.c = c;
            this.mutex = this;
        }

        SynchronizedCollection(ObjectCollection<T> c, Object mutex) {
            this.c = c;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(T o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(ObjectCollection<T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(T[] e, int offset, int length) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(e, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAny(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAny(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(ObjectCollection<T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAny(ObjectCollection<T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAny(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        @Override
        public ObjectIterator<T> iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectCollection<T> copy() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.copy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(ObjectCollection<T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(ObjectCollection<T> c, Consumer<T> r) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(c, r);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(ObjectCollection<T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(ObjectCollection<T> c, Consumer<T> r) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(c, r);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <E> E[] toArray(E[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Consumer<? super T> action) {
            Object object = this.mutex;
            synchronized (object) {
                this.c.forEach(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachIndexed(IntObjectConsumer<T> action) {
            Object object = this.mutex;
            synchronized (object) {
                this.c.forEachIndexed(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                return this.c.equals(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, T> action) {
            Object object = this.mutex;
            synchronized (object) {
                this.c.forEach(input, action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matchesAny(Predicate<T> filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.matchesAny(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matchesNone(Predicate<T> filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.matchesNone(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matchesAll(Predicate<T> filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.matchesAll(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <E> E reduce(E identity, BiFunction<E, T, E> operator) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.reduce(identity, operator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T reduce(ObjectObjectUnaryOperator<T, T> operator) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.reduce(operator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T findFirst(Predicate<T> filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.findFirst(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int count(Predicate<T> filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.count(filter);
            }
        }
    }

    private static class SingletonCollection<T>
    extends AbstractObjectCollection<T> {
        T element;

        SingletonCollection(T element) {
            this.element = element;
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectIterator<T> iterator() {
            return new ObjectIterator<T>(){
                boolean next = true;

                @Override
                public boolean hasNext() {
                    return this.next;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.next = false;
                    return element;
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection l = (Collection)o;
            if (l.size() != this.size()) {
                return false;
            }
            Iterator iter = l.iterator();
            if (iter.hasNext() && !Objects.equals(this.element, iter.next())) {
                return false;
            }
            return !iter.hasNext();
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public SingletonCollection<T> copy() {
            return new SingletonCollection<T>(this.element);
        }
    }

    protected static class DistinctCollectionWrapper<T>
    extends AbstractObjectCollection<T> {
        T[] keys;
        boolean containsNull;
        int minCapacity;
        int nullIndex;
        int maxFill;
        int mask;
        int size;

        public DistinctCollectionWrapper() {
            this(16);
        }

        public DistinctCollectionWrapper(int size) {
            if (this.minCapacity < 0) {
                throw new IllegalStateException("Minimum Capacity is negative. This is not allowed");
            }
            this.minCapacity = this.nullIndex = HashUtil.arraySize(this.minCapacity, 0.75f);
            this.mask = this.nullIndex - 1;
            this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * 0.75f), this.nullIndex - 1);
            this.keys = new Object[this.nullIndex + 1];
        }

        @Override
        public boolean add(T o) {
            if (o == null) {
                if (this.containsNull) {
                    return false;
                }
                this.containsNull = true;
            } else {
                block7: {
                    int pos = HashUtil.mix(Objects.hashCode(o)) & this.mask;
                    T current = this.keys[pos];
                    if (current != null) {
                        if (Objects.equals(current, o)) {
                            return false;
                        }
                        do {
                            ++pos;
                            current = this.keys[pos &= this.mask];
                            if (current == null) break block7;
                        } while (!Objects.equals(current, o));
                        return false;
                    }
                }
                this.keys[pos] = o;
            }
            if (this.size++ >= this.maxFill) {
                this.rehash(HashUtil.arraySize(this.size + 1, 0.75f));
            }
            return true;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return this.containsNull;
            }
            int pos = HashUtil.mix(o.hashCode()) & this.mask;
            T current = this.keys[pos];
            if (current == null) {
                return false;
            }
            if (Objects.equals(o, current)) {
                return true;
            }
            do {
                ++pos;
                current = this.keys[pos &= this.mask];
                if (current != null) continue;
                return false;
            } while (!Objects.equals(o, current));
            return true;
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                return this.containsNull ? this.removeNullIndex() : false;
            }
            int pos = HashUtil.mix(o.hashCode()) & this.mask;
            T current = this.keys[pos];
            if (current == null) {
                return false;
            }
            if (Objects.equals(o, current)) {
                return this.removeIndex(pos);
            }
            do {
                ++pos;
                current = this.keys[pos &= this.mask];
                if (current != null) continue;
                return false;
            } while (!Objects.equals(o, current));
            return this.removeIndex(pos);
        }

        protected boolean removeIndex(int pos) {
            if (pos == this.nullIndex) {
                return this.containsNull ? this.removeNullIndex() : false;
            }
            this.keys[pos] = null;
            --this.size;
            this.shiftKeys(pos);
            if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
                this.rehash(this.nullIndex / 2);
            }
            return true;
        }

        protected boolean removeNullIndex() {
            this.containsNull = false;
            this.keys[this.nullIndex] = null;
            --this.size;
            if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
                this.rehash(this.nullIndex / 2);
            }
            return true;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return new SetIterator();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            if (this.size() <= 0) {
                return;
            }
            if (this.containsNull) {
                action.accept(this.keys[this.nullIndex]);
            }
            for (int i = this.nullIndex - 1; i >= 0; --i) {
                if (this.keys[i] == null) continue;
                action.accept(this.keys[i]);
            }
        }

        @Override
        public DistinctCollectionWrapper<T> copy() {
            DistinctCollectionWrapper<T> set = new DistinctCollectionWrapper<T>(0);
            set.minCapacity = this.minCapacity;
            set.mask = this.mask;
            set.maxFill = this.maxFill;
            set.nullIndex = this.nullIndex;
            set.containsNull = this.containsNull;
            set.size = this.size;
            set.keys = Arrays.copyOf(this.keys, this.keys.length);
            return set;
        }

        protected void shiftKeys(int startPos) {
            while (true) {
                T current;
                int last = startPos;
                startPos = last + 1 & this.mask;
                while (true) {
                    if ((current = this.keys[startPos]) == null) {
                        this.keys[last] = null;
                        return;
                    }
                    int slot = HashUtil.mix(Objects.hashCode(current)) & this.mask;
                    if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                    ++startPos;
                    startPos &= this.mask;
                }
                this.keys[last] = current;
            }
        }

        protected void rehash(int newSize) {
            int newMask = newSize - 1;
            Object[] newKeys = new Object[newSize + 1];
            int i = this.nullIndex;
            int pos = 0;
            int j = this.size - (this.containsNull ? 1 : 0);
            while (j-- != 0) {
                do {
                    if (--i >= 0) continue;
                    throw new ConcurrentModificationException("Set was modified during rehash");
                } while (this.keys[i] == null);
                pos = HashUtil.mix(Objects.hashCode(this.keys[i])) & newMask;
                if (newKeys[pos] != null) {
                    do {
                        ++pos;
                    } while (newKeys[pos &= newMask] != null);
                }
                newKeys[pos] = this.keys[i];
            }
            this.nullIndex = newSize;
            this.mask = newMask;
            this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * 0.75f), this.nullIndex - 1);
            this.keys = newKeys;
        }

        @Override
        public void clear() {
            if (this.size == 0) {
                return;
            }
            this.size = 0;
            this.containsNull = false;
            Arrays.fill(this.keys, null);
        }

        @Override
        public int size() {
            return this.size;
        }

        private class SetIterator
        implements ObjectIterator<T> {
            int pos;
            int returnedPos;
            int lastReturned;
            int nextIndex;
            boolean returnNull;
            T[] wrapped;
            int wrappedIndex;

            private SetIterator() {
                this.pos = DistinctCollectionWrapper.this.nullIndex;
                this.returnedPos = -1;
                this.lastReturned = -1;
                this.nextIndex = Integer.MIN_VALUE;
                this.returnNull = DistinctCollectionWrapper.this.containsNull;
                this.wrapped = null;
                this.wrappedIndex = 0;
            }

            @Override
            public boolean hasNext() {
                block5: {
                    if (this.nextIndex == Integer.MIN_VALUE) {
                        if (this.returnNull) {
                            this.returnNull = false;
                            this.nextIndex = DistinctCollectionWrapper.this.nullIndex;
                        } else {
                            do {
                                if (--this.pos >= 0) continue;
                                if (this.wrapped != null && this.wrappedIndex > -this.pos - 1) {
                                    this.nextIndex = -this.pos - 1;
                                }
                                break block5;
                            } while (DistinctCollectionWrapper.this.keys[this.pos] == null);
                            this.nextIndex = this.pos;
                        }
                    }
                }
                return this.nextIndex != Integer.MIN_VALUE;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.returnedPos = this.pos;
                if (this.nextIndex < 0) {
                    this.lastReturned = Integer.MAX_VALUE;
                    Object value = this.wrapped[this.nextIndex];
                    this.nextIndex = Integer.MIN_VALUE;
                    return value;
                }
                this.lastReturned = this.nextIndex;
                Object value = DistinctCollectionWrapper.this.keys[this.lastReturned];
                this.nextIndex = Integer.MIN_VALUE;
                return value;
            }

            @Override
            public void remove() {
                if (this.lastReturned == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturned == DistinctCollectionWrapper.this.nullIndex) {
                    DistinctCollectionWrapper.this.containsNull = false;
                    DistinctCollectionWrapper.this.keys[DistinctCollectionWrapper.this.nullIndex] = null;
                } else if (this.returnedPos >= 0) {
                    this.shiftKeys(this.returnedPos);
                } else {
                    DistinctCollectionWrapper.this.remove(this.wrapped[-this.returnedPos - 1]);
                    this.lastReturned = -1;
                    return;
                }
                --DistinctCollectionWrapper.this.size;
                this.lastReturned = -1;
            }

            private void shiftKeys(int startPos) {
                while (true) {
                    Object current;
                    int last = startPos;
                    startPos = last + 1 & DistinctCollectionWrapper.this.mask;
                    while (true) {
                        if ((current = DistinctCollectionWrapper.this.keys[startPos]) == null) {
                            DistinctCollectionWrapper.this.keys[last] = null;
                            return;
                        }
                        int slot = HashUtil.mix(Objects.hashCode(current)) & DistinctCollectionWrapper.this.mask;
                        if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                        ++startPos;
                        startPos &= DistinctCollectionWrapper.this.mask;
                    }
                    if (startPos < last) {
                        this.addWrapper(DistinctCollectionWrapper.this.keys[startPos]);
                    }
                    DistinctCollectionWrapper.this.keys[last] = current;
                }
            }

            private void addWrapper(T value) {
                if (this.wrapped == null) {
                    this.wrapped = new Object[2];
                } else if (this.wrappedIndex >= this.wrapped.length) {
                    Object[] newArray = new Object[this.wrapped.length * 2];
                    System.arraycopy(this.wrapped, 0, newArray, 0, this.wrapped.length);
                    this.wrapped = newArray;
                }
                this.wrapped[this.wrappedIndex++] = value;
            }
        }
    }

    protected static class CollectionWrapper<T>
    extends AbstractObjectCollection<T>
    implements ITrimmable {
        T[] elements;
        int size = 0;

        public CollectionWrapper() {
            this(10);
        }

        public CollectionWrapper(int size) {
            if (size < 0) {
                throw new IllegalStateException("Size has to be 0 or greater");
            }
            this.elements = new Object[size];
        }

        @Override
        public boolean add(T o) {
            if (this.size >= this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, (int)Math.min((long)this.elements.length + (long)(this.elements.length >> 1), 0x7FFFFFF7L));
            }
            this.elements[this.size++] = o;
            return true;
        }

        public T get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return this.elements[index];
        }

        @Override
        public boolean remove(Object e) {
            for (int i = 0; i < this.size; ++i) {
                if (!Objects.equals(this.elements[i], e)) continue;
                this.removeIndex(i);
                return true;
            }
            return false;
        }

        private void removeIndex(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            --this.size;
            if (index != this.size) {
                System.arraycopy(this.elements, index + 1, this.elements, index, this.size - index);
            }
        }

        @Override
        public ObjectIterator<T> iterator() {
            return new ObjectIterator<T>(){
                int index = 0;
                int lastReturned = -1;

                @Override
                public boolean hasNext() {
                    return this.index < size;
                }

                @Override
                public T next() {
                    int i;
                    this.lastReturned = i = this.index++;
                    return elements[this.lastReturned];
                }

                @Override
                public void remove() {
                    if (this.lastReturned == -1) {
                        throw new IllegalStateException();
                    }
                    this.removeIndex(this.lastReturned);
                    this.index = this.lastReturned;
                    this.lastReturned = -1;
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.size; ++i) {
                this.elements[i] = null;
            }
            this.size = 0;
        }

        public void sort(Comparator<? super T> c) {
            if (c != null) {
                ObjectArrays.stableSort(this.elements, this.size, c);
            } else {
                ObjectArrays.stableSort(this.elements, this.size);
            }
        }

        public void unstableSort(Comparator<? super T> c) {
            if (c != null) {
                ObjectArrays.unstableSort(this.elements, this.size, c);
            } else {
                ObjectArrays.unstableSort(this.elements, this.size);
            }
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            for (int i = 0; i < this.size; ++i) {
                action.accept(this.elements[i]);
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, T> action) {
            Objects.requireNonNull(action);
            for (int i = 0; i < this.size; ++i) {
                action.accept(input, (E)this.elements[i]);
            }
        }

        @Override
        public boolean trim(int size) {
            if (size > this.size() || this.size() == this.elements.length) {
                return false;
            }
            int value = Math.max(size, this.size());
            this.elements = value == 0 ? ObjectArrays.EMPTY_ARRAY : Arrays.copyOf(this.elements, value);
            return true;
        }

        @Override
        public void clearAndTrim(int size) {
            if (this.elements.length <= size) {
                this.clear();
                return;
            }
            this.elements = size == 0 ? ObjectArrays.EMPTY_ARRAY : new Object[size];
            this.size = size;
        }

        @Override
        public Object[] toArray() {
            Object[] obj = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                obj[i] = this.elements[i];
            }
            return obj;
        }

        @Override
        public <E> E[] toArray(E[] a) {
            if (a == null) {
                a = new Object[this.size];
            } else if (a.length < this.size) {
                a = ObjectArrays.newArray(a.getClass().getComponentType(), this.size);
            }
            System.arraycopy(this.elements, 0, a, 0, this.size);
            if (a.length > this.size) {
                a[this.size] = null;
            }
            return a;
        }
    }
}

