/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.maps.impl.immutable;

import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.objects.collections.AbstractObjectCollection;
import speiger.src.collections.objects.collections.ObjectBidirectionalIterator;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.ObjectSupplier;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.functions.function.UnaryOperator;
import speiger.src.collections.objects.lists.ObjectListIterator;
import speiger.src.collections.objects.maps.abstracts.AbstractObject2ObjectMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectOrderedMap;
import speiger.src.collections.objects.sets.AbstractObjectSet;
import speiger.src.collections.objects.sets.ObjectOrderedSet;
import speiger.src.collections.utils.HashUtil;
import speiger.src.collections.utils.SanityChecks;

public class ImmutableObject2ObjectOpenHashMap<T, V>
extends AbstractObject2ObjectMap<T, V>
implements Object2ObjectOrderedMap<T, V> {
    protected transient T[] keys;
    protected transient V[] values;
    protected transient long[] links;
    protected transient boolean containsNull;
    protected transient int nullIndex;
    protected transient int mask;
    protected int firstIndex = -1;
    protected int lastIndex = -1;
    protected transient Object2ObjectOrderedMap.FastOrderedSet<T, V> entrySet;
    protected transient ObjectOrderedSet<T> keySet;
    protected transient ObjectCollection<V> valuesC;
    protected int size;

    protected ImmutableObject2ObjectOpenHashMap() {
    }

    public ImmutableObject2ObjectOpenHashMap(T[] keys, V[] values) {
        this(keys, values, 0.75f);
    }

    public ImmutableObject2ObjectOpenHashMap(T[] keys, V[] values, float loadFactor) {
        if (keys.length != values.length) {
            throw new IllegalStateException("Input Arrays are not equal size");
        }
        this.init(keys, values, 0, keys.length, loadFactor);
    }

    public ImmutableObject2ObjectOpenHashMap(Map<? extends T, ? extends V> map) {
        this(map, 0.75f);
    }

    public ImmutableObject2ObjectOpenHashMap(Map<? extends T, ? extends V> map, float loadFactor) {
        Object[] keys = new Object[map.size()];
        Object[] values = new Object[keys.length];
        int index = 0;
        for (Map.Entry<T, V> entry : map.entrySet()) {
            keys[index] = entry.getKey();
            values[index] = entry.getValue();
            ++index;
        }
        this.init(keys, values, 0, index, loadFactor);
    }

    public ImmutableObject2ObjectOpenHashMap(Object2ObjectMap<T, V> map) {
        this(map, 0.75f);
    }

    public ImmutableObject2ObjectOpenHashMap(Object2ObjectMap<T, V> map, float loadFactor) {
        Object[] keys = new Object[map.size()];
        Object[] values = new Object[keys.length];
        int index = 0;
        for (Object2ObjectMap.Entry entry : this.getFastIterable(map)) {
            keys[index] = entry.getKey();
            values[index] = entry.getValue();
            ++index;
        }
        this.init(keys, values, 0, index, loadFactor);
    }

    protected void init(T[] a, V[] b, int offset, int length, float loadFactor) {
        SanityChecks.checkArrayCapacity(a.length, offset, length);
        int newSize = HashUtil.arraySize(length + 1, loadFactor);
        int newMask = newSize - 1;
        Object[] newKeys = new Object[newSize + 1];
        Object[] newValues = new Object[newSize + 1];
        long[] newLinks = new long[newSize + 1];
        int prev = -1;
        int m = offset + length;
        for (int i = offset; i < m; ++i) {
            int pos;
            boolean found;
            T o;
            block10: {
                o = a[i];
                if (o == null) {
                    if (!this.containsNull) {
                        ++this.size;
                        if (prev != -1) {
                            int n = prev;
                            newLinks[n] = newLinks[n] ^ (newLinks[prev] ^ (long)newSize & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                            int n2 = newSize;
                            newLinks[n2] = newLinks[n2] ^ (newLinks[newSize] ^ ((long)prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                            prev = newSize;
                        } else {
                            prev = this.firstIndex = newSize;
                            newLinks[newSize] = -1L;
                        }
                    }
                    this.containsNull = true;
                    newValues[newSize] = b[i];
                    continue;
                }
                found = true;
                pos = HashUtil.mix(Objects.hashCode(o)) & newMask;
                Object current = newKeys[pos];
                if (current != null) {
                    if (Objects.equals(current, o)) {
                        newValues[pos] = b[i];
                        continue;
                    }
                    do {
                        ++pos;
                        current = newKeys[pos &= newMask];
                        if (current == null) break block10;
                    } while (!Objects.equals(current, o));
                    found = false;
                    newValues[pos] = b[i];
                }
            }
            if (!found) continue;
            ++this.size;
            newKeys[pos] = o;
            newValues[pos] = b[i];
            if (prev != -1) {
                int n = prev;
                newLinks[n] = newLinks[n] ^ (newLinks[prev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n3 = pos;
                newLinks[n3] = newLinks[n3] ^ (newLinks[pos] ^ ((long)prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                prev = pos;
                continue;
            }
            prev = this.firstIndex = pos;
            newLinks[pos] = -1L;
        }
        this.nullIndex = newSize;
        this.mask = newMask;
        this.keys = newKeys;
        this.values = newValues;
        this.links = newLinks;
        this.lastIndex = prev;
        if (prev != -1) {
            int n = prev;
            newLinks[n] = newLinks[n] | 0xFFFFFFFFL;
        }
    }

    @Override
    public V put(T key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putIfAbsent(T key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putAndMoveToFirst(T key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putAndMoveToLast(T key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean moveToFirst(T key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean moveToLast(T key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V getAndMoveToFirst(T key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V getAndMoveToLast(T key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findIndex(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        int index = this.firstIndex;
        while (index != -1) {
            if (Objects.equals(this.values[index], value)) {
                return true;
            }
            index = (int)this.links[index];
        }
        return false;
    }

    @Override
    public V rem(T key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remOrDefault(T key, V defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V getObject(T key) {
        int slot = this.findIndex(key);
        return slot < 0 ? this.getDefaultReturnValue() : this.values[slot];
    }

    @Override
    public V get(Object key) {
        int slot = this.findIndex(key);
        return slot < 0 ? this.getDefaultReturnValue() : this.values[slot];
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        int slot = this.findIndex(key);
        return slot < 0 ? defaultValue : this.values[slot];
    }

    @Override
    public T firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.keys[this.firstIndex];
    }

    @Override
    public T pollFirstKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.keys[this.lastIndex];
    }

    @Override
    public T pollLastKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V firstValue() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.values[this.firstIndex];
    }

    @Override
    public V lastValue() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.values[this.lastIndex];
    }

    @Override
    public ObjectOrderedSet<Object2ObjectMap.Entry<T, V>> object2ObjectEntrySet() {
        if (this.entrySet == null) {
            this.entrySet = new MapEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public ObjectOrderedSet<T> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.valuesC == null) {
            this.valuesC = new Values();
        }
        return this.valuesC;
    }

    @Override
    public ImmutableObject2ObjectOpenHashMap<T, V> copy() {
        ImmutableObject2ObjectOpenHashMap<T, V> map = new ImmutableObject2ObjectOpenHashMap<T, V>();
        map.mask = this.mask;
        map.nullIndex = this.nullIndex;
        map.containsNull = this.containsNull;
        map.size = this.size;
        map.keys = Arrays.copyOf(this.keys, this.keys.length);
        map.values = Arrays.copyOf(this.values, this.values.length);
        map.links = Arrays.copyOf(this.links, this.links.length);
        map.firstIndex = this.firstIndex;
        map.lastIndex = this.lastIndex;
        return map;
    }

    @Override
    public void forEach(ObjectObjectConsumer<T, V> action) {
        int index = this.firstIndex;
        while (index != -1) {
            action.accept(this.keys[index], this.values[index]);
            index = (int)this.links[index];
        }
    }

    @Override
    public boolean replace(T key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(T key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V compute(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfAbsent(T key, UnaryOperator<T, V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V supplyIfAbsent(T key, ObjectSupplier<V> valueProvider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfPresent(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V merge(T key, V value, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mergeAll(Object2ObjectMap<T, V> m, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    protected int findIndex(Object key) {
        int pos;
        block4: {
            if (key == null) {
                return this.containsNull ? this.nullIndex : -(this.nullIndex + 1);
            }
            pos = HashUtil.mix(key.hashCode()) & this.mask;
            T current = this.keys[pos];
            if (current != null) {
                if (Objects.equals(key, current)) {
                    return pos;
                }
                do {
                    ++pos;
                    current = this.keys[pos &= this.mask];
                    if (current == null) break block4;
                } while (!Objects.equals(key, current));
                return pos;
            }
        }
        return -(pos + 1);
    }

    private class MapIterator {
        int previous = -1;
        int next = -1;
        int current = -1;
        int index = 0;

        MapIterator() {
            this.next = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        MapIterator(T from) {
            if (from == null) {
                if (!ImmutableObject2ObjectOpenHashMap.this.containsNull) throw new NoSuchElementException("The null element is not in the set");
                this.next = (int)ImmutableObject2ObjectOpenHashMap.this.links[ImmutableObject2ObjectOpenHashMap.this.nullIndex];
                this.previous = ImmutableObject2ObjectOpenHashMap.this.nullIndex;
                return;
            } else if (ImmutableObject2ObjectOpenHashMap.this.keys[ImmutableObject2ObjectOpenHashMap.this.lastIndex] == from) {
                this.previous = ImmutableObject2ObjectOpenHashMap.this.lastIndex;
                this.index = ImmutableObject2ObjectOpenHashMap.this.size;
                return;
            } else {
                int pos = HashUtil.mix(Objects.hashCode(from)) & ImmutableObject2ObjectOpenHashMap.this.mask;
                while (ImmutableObject2ObjectOpenHashMap.this.keys[pos] != null) {
                    if (Objects.equals(ImmutableObject2ObjectOpenHashMap.this.keys[pos], from)) {
                        this.next = (int)ImmutableObject2ObjectOpenHashMap.this.links[pos];
                        this.previous = pos;
                        break;
                    }
                    ++pos;
                    pos &= ImmutableObject2ObjectOpenHashMap.this.mask;
                }
                if (this.previous != -1 || this.next != -1) return;
                throw new NoSuchElementException("The element was not found");
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.previous != -1;
        }

        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.current = this.previous;
            this.previous = (int)(ImmutableObject2ObjectOpenHashMap.this.links[this.current] >> 32);
            this.next = this.current;
            if (this.index >= 0) {
                --this.index;
            }
            return this.current;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = (int)ImmutableObject2ObjectOpenHashMap.this.links[this.current];
            this.previous = this.current;
            if (this.index >= 0) {
                ++this.index;
            }
            return this.current;
        }

        private void ensureIndexKnown() {
            if (this.index == -1) {
                if (this.previous == -1) {
                    this.index = 0;
                } else if (this.next == -1) {
                    this.index = ImmutableObject2ObjectOpenHashMap.this.size;
                } else {
                    this.index = 1;
                    int pos = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
                    while (pos != this.previous) {
                        pos = (int)ImmutableObject2ObjectOpenHashMap.this.links[pos];
                        ++this.index;
                    }
                }
            }
        }
    }

    private class ValueIterator
    extends MapIterator
    implements ObjectListIterator<V> {
        @Override
        public V previous() {
            return ImmutableObject2ObjectOpenHashMap.this.values[this.previousEntry()];
        }

        @Override
        public V next() {
            return ImmutableObject2ObjectOpenHashMap.this.values[this.nextEntry()];
        }

        @Override
        public void set(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(V e) {
            throw new UnsupportedOperationException();
        }
    }

    private class KeyIterator
    extends MapIterator
    implements ObjectListIterator<T> {
        public KeyIterator() {
        }

        public KeyIterator(T from) {
            super(from);
        }

        @Override
        public T previous() {
            return ImmutableObject2ObjectOpenHashMap.this.keys[this.previousEntry()];
        }

        @Override
        public T next() {
            return ImmutableObject2ObjectOpenHashMap.this.keys[this.nextEntry()];
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2ObjectMap.Entry<T, V>> {
        public EntryIterator() {
        }

        public EntryIterator(T from) {
            super(from);
        }

        @Override
        public Object2ObjectMap.Entry<T, V> next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public Object2ObjectMap.Entry<T, V> previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object2ObjectMap.Entry<T, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2ObjectMap.Entry<T, V> entry) {
            throw new UnsupportedOperationException();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2ObjectMap.Entry<T, V>> {
        MapEntry entry;

        public FastEntryIterator() {
            this.entry = new MapEntry();
        }

        public FastEntryIterator(T from) {
            super(from);
            this.entry = new MapEntry();
        }

        @Override
        public Object2ObjectMap.Entry<T, V> next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }

        @Override
        public Object2ObjectMap.Entry<T, V> previous() {
            this.entry.index = this.previousEntry();
            return this.entry;
        }

        @Override
        public void set(Object2ObjectMap.Entry<T, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2ObjectMap.Entry<T, V> entry) {
            throw new UnsupportedOperationException();
        }
    }

    private class Values
    extends AbstractObjectCollection<V> {
        private Values() {
        }

        @Override
        @Deprecated
        public boolean contains(Object e) {
            return ImmutableObject2ObjectOpenHashMap.this.containsValue(e);
        }

        @Override
        public boolean add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectIterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ImmutableObject2ObjectOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(ImmutableObject2ObjectOpenHashMap.this.values[index]);
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<V> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int count = 0;
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(count++, ImmutableObject2ObjectOpenHashMap.this.values[index]);
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, V> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(input, ImmutableObject2ObjectOpenHashMap.this.values[index]);
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
        }

        @Override
        public boolean matchesAny(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(ImmutableObject2ObjectOpenHashMap.this.values[index])) {
                    return true;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(ImmutableObject2ObjectOpenHashMap.this.values[index])) {
                    return false;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (!filter.test(ImmutableObject2ObjectOpenHashMap.this.values[index])) {
                    return false;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, V, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                state = operator.apply(state, ImmutableObject2ObjectOpenHashMap.this.values[index]);
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public V reduce(ObjectObjectUnaryOperator<V, V> operator) {
            Objects.requireNonNull(operator);
            Object state = null;
            boolean empty = true;
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (empty) {
                    empty = false;
                    state = ImmutableObject2ObjectOpenHashMap.this.values[index];
                    index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
                    continue;
                }
                state = operator.apply(state, ImmutableObject2ObjectOpenHashMap.this.values[index]);
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public V findFirst(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(ImmutableObject2ObjectOpenHashMap.this.values[index])) {
                    return ImmutableObject2ObjectOpenHashMap.this.values[index];
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return null;
        }

        @Override
        public int count(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            int result = 0;
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(ImmutableObject2ObjectOpenHashMap.this.values[index])) {
                    ++result;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return result;
        }
    }

    private final class KeySet
    extends AbstractObjectSet<T>
    implements ObjectOrderedSet<T> {
        private KeySet() {
        }

        @Override
        @Deprecated
        public boolean contains(Object e) {
            return ImmutableObject2ObjectOpenHashMap.this.containsKey(e);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAndMoveToFirst(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAndMoveToLast(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToFirst(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToLast(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectListIterator<T> iterator() {
            return new KeyIterator();
        }

        @Override
        public ObjectBidirectionalIterator<T> iterator(T fromElement) {
            return new KeyIterator(fromElement);
        }

        @Override
        public KeySet copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return ImmutableObject2ObjectOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T first() {
            return ImmutableObject2ObjectOpenHashMap.this.firstKey();
        }

        @Override
        public T pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T last() {
            return ImmutableObject2ObjectOpenHashMap.this.lastKey();
        }

        @Override
        public T pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(ImmutableObject2ObjectOpenHashMap.this.keys[index]);
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<T> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int count = 0;
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(count++, ImmutableObject2ObjectOpenHashMap.this.keys[index]);
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, T> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(input, (E)ImmutableObject2ObjectOpenHashMap.this.keys[index]);
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
        }

        @Override
        public boolean matchesAny(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(ImmutableObject2ObjectOpenHashMap.this.keys[index])) {
                    return true;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(ImmutableObject2ObjectOpenHashMap.this.keys[index])) {
                    return false;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (!filter.test(ImmutableObject2ObjectOpenHashMap.this.keys[index])) {
                    return false;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, T, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                state = operator.apply(state, ImmutableObject2ObjectOpenHashMap.this.keys[index]);
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public T reduce(ObjectObjectUnaryOperator<T, T> operator) {
            Objects.requireNonNull(operator);
            Object state = null;
            boolean empty = true;
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (empty) {
                    empty = false;
                    state = ImmutableObject2ObjectOpenHashMap.this.keys[index];
                    index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
                    continue;
                }
                state = operator.apply(state, ImmutableObject2ObjectOpenHashMap.this.keys[index]);
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public T findFirst(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(ImmutableObject2ObjectOpenHashMap.this.keys[index])) {
                    return ImmutableObject2ObjectOpenHashMap.this.keys[index];
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return null;
        }

        @Override
        public int count(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            int result = 0;
            while (index != -1) {
                if (filter.test(ImmutableObject2ObjectOpenHashMap.this.keys[index])) {
                    ++result;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return result;
        }
    }

    private class MapEntrySet
    extends AbstractObjectSet<Object2ObjectMap.Entry<T, V>>
    implements Object2ObjectOrderedMap.FastOrderedSet<T, V> {
        private MapEntrySet() {
        }

        @Override
        public boolean addAndMoveToFirst(Object2ObjectMap.Entry<T, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAndMoveToLast(Object2ObjectMap.Entry<T, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToFirst(Object2ObjectMap.Entry<T, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToLast(Object2ObjectMap.Entry<T, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object2ObjectMap.Entry<T, V> first() {
            return new AbstractObject2ObjectMap.BasicEntry(ImmutableObject2ObjectOpenHashMap.this.firstKey(), ImmutableObject2ObjectOpenHashMap.this.firstValue());
        }

        @Override
        public Object2ObjectMap.Entry<T, V> last() {
            return new AbstractObject2ObjectMap.BasicEntry(ImmutableObject2ObjectOpenHashMap.this.lastKey(), ImmutableObject2ObjectOpenHashMap.this.lastValue());
        }

        @Override
        public Object2ObjectMap.Entry<T, V> pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object2ObjectMap.Entry<T, V> pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectBidirectionalIterator<Object2ObjectMap.Entry<T, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Object2ObjectMap.Entry<T, V>> iterator(Object2ObjectMap.Entry<T, V> fromElement) {
            return new EntryIterator(fromElement.getKey());
        }

        @Override
        public ObjectBidirectionalIterator<Object2ObjectMap.Entry<T, V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Object2ObjectMap.Entry<T, V>> fastIterator(T fromElement) {
            return new FastEntryIterator(fromElement);
        }

        @Override
        public MapEntrySet copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super Object2ObjectMap.Entry<T, V>> action) {
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(new AbstractObject2ObjectMap.BasicEntry(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]));
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
        }

        @Override
        public void fastForEach(Consumer<? super Object2ObjectMap.Entry<T, V>> action) {
            AbstractObject2ObjectMap.BasicEntry entry = new AbstractObject2ObjectMap.BasicEntry();
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]);
                action.accept(entry);
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<Object2ObjectMap.Entry<T, V>> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int count = 0;
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(count++, new AbstractObject2ObjectMap.BasicEntry(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]));
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, Object2ObjectMap.Entry<T, V>> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(input, new AbstractObject2ObjectMap.BasicEntry(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]));
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
        }

        @Override
        public boolean matchesAny(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            AbstractObject2ObjectMap.BasicEntry entry = new AbstractObject2ObjectMap.BasicEntry();
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]);
                if (filter.test(entry)) {
                    return true;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            AbstractObject2ObjectMap.BasicEntry entry = new AbstractObject2ObjectMap.BasicEntry();
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]);
                if (filter.test(entry)) {
                    return false;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            AbstractObject2ObjectMap.BasicEntry entry = new AbstractObject2ObjectMap.BasicEntry();
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]);
                if (!filter.test(entry)) {
                    return false;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, Object2ObjectMap.Entry<T, V>, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                state = operator.apply(state, new AbstractObject2ObjectMap.BasicEntry(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]));
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public Object2ObjectMap.Entry<T, V> reduce(ObjectObjectUnaryOperator<Object2ObjectMap.Entry<T, V>, Object2ObjectMap.Entry<T, V>> operator) {
            Objects.requireNonNull(operator);
            Object2ObjectMap.Entry state = null;
            boolean empty = true;
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (empty) {
                    empty = false;
                    state = new AbstractObject2ObjectMap.BasicEntry(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]);
                    index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
                    continue;
                }
                state = (Object2ObjectMap.Entry)operator.apply(state, new AbstractObject2ObjectMap.BasicEntry(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]));
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public Object2ObjectMap.Entry<T, V> findFirst(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            AbstractObject2ObjectMap.BasicEntry entry = new AbstractObject2ObjectMap.BasicEntry();
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]);
                if (filter.test(entry)) {
                    return entry;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return null;
        }

        @Override
        public int count(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            AbstractObject2ObjectMap.BasicEntry entry = new AbstractObject2ObjectMap.BasicEntry();
            int result = 0;
            int index = ImmutableObject2ObjectOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(ImmutableObject2ObjectOpenHashMap.this.keys[index], ImmutableObject2ObjectOpenHashMap.this.values[index]);
                if (filter.test(entry)) {
                    ++result;
                }
                index = (int)ImmutableObject2ObjectOpenHashMap.this.links[index];
            }
            return result;
        }

        @Override
        @Deprecated
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                if (o instanceof Object2ObjectMap.Entry) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)o;
                    int index = ImmutableObject2ObjectOpenHashMap.this.findIndex(entry.getKey());
                    if (index >= 0) {
                        return Objects.equals(entry.getValue(), ImmutableObject2ObjectOpenHashMap.this.values[index]);
                    }
                } else {
                    Map.Entry entry = (Map.Entry)o;
                    int index = ImmutableObject2ObjectOpenHashMap.this.findIndex(entry.getKey());
                    if (index >= 0) {
                        return Objects.equals(entry.getValue(), ImmutableObject2ObjectOpenHashMap.this.values[index]);
                    }
                }
            }
            return false;
        }

        @Override
        @Deprecated
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return ImmutableObject2ObjectOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    protected class MapEntry
    implements Object2ObjectMap.Entry<T, V>,
    Map.Entry<T, V> {
        public int index = -1;

        public MapEntry() {
        }

        public MapEntry(int index) {
            this.index = index;
        }

        @Override
        public T getKey() {
            return ImmutableObject2ObjectOpenHashMap.this.keys[this.index];
        }

        @Override
        public V getValue() {
            return ImmutableObject2ObjectOpenHashMap.this.values[this.index];
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                if (obj instanceof Object2ObjectMap.Entry) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)obj;
                    return Objects.equals(ImmutableObject2ObjectOpenHashMap.this.keys[this.index], entry.getKey()) && Objects.equals(ImmutableObject2ObjectOpenHashMap.this.values[this.index], entry.getValue());
                }
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                return Objects.equals(ImmutableObject2ObjectOpenHashMap.this.keys[this.index], key) && Objects.equals(ImmutableObject2ObjectOpenHashMap.this.values[this.index], value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(ImmutableObject2ObjectOpenHashMap.this.keys[this.index]) ^ Objects.hashCode(ImmutableObject2ObjectOpenHashMap.this.values[this.index]);
        }

        public String toString() {
            return Objects.toString(ImmutableObject2ObjectOpenHashMap.this.keys[this.index]) + "=" + Objects.toString(ImmutableObject2ObjectOpenHashMap.this.values[this.index]);
        }
    }
}

