/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.maps.impl.hash;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.objects.collections.AbstractObjectCollection;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.ObjectSupplier;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.functions.function.UnaryOperator;
import speiger.src.collections.objects.maps.abstracts.AbstractObject2ObjectMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;
import speiger.src.collections.objects.sets.AbstractObjectSet;
import speiger.src.collections.objects.sets.ObjectSet;
import speiger.src.collections.utils.HashUtil;
import speiger.src.collections.utils.ITrimmable;

public class Object2ObjectOpenHashMap<T, V>
extends AbstractObject2ObjectMap<T, V>
implements ITrimmable {
    protected transient T[] keys;
    protected transient V[] values;
    protected transient boolean containsNull;
    protected transient int minCapacity;
    protected transient int nullIndex;
    protected transient int maxFill;
    protected transient int mask;
    protected transient Object2ObjectMap.FastEntrySet<T, V> entrySet;
    protected transient ObjectSet<T> keySet;
    protected transient ObjectCollection<V> valuesC;
    protected int size;
    protected final float loadFactor;

    public Object2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    public Object2ObjectOpenHashMap(int minCapacity) {
        this(minCapacity, 0.75f);
    }

    public Object2ObjectOpenHashMap(int minCapacity, float loadFactor) {
        if (minCapacity < 0) {
            throw new IllegalStateException("Minimum Capacity is negative. This is not allowed");
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalStateException("Load Factor is not between 0 and 1");
        }
        this.loadFactor = loadFactor;
        this.minCapacity = this.nullIndex = HashUtil.arraySize(minCapacity, loadFactor);
        this.mask = this.nullIndex - 1;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * loadFactor), this.nullIndex - 1);
        this.keys = new Object[this.nullIndex + 1];
        this.values = new Object[this.nullIndex + 1];
    }

    public Object2ObjectOpenHashMap(T[] keys, V[] values) {
        this(keys, values, 0.75f);
    }

    public Object2ObjectOpenHashMap(T[] keys, V[] values, float loadFactor) {
        this(keys.length, loadFactor);
        if (keys.length != values.length) {
            throw new IllegalStateException("Input Arrays are not equal size");
        }
        int m = keys.length;
        for (int i = 0; i < m; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    public Object2ObjectOpenHashMap(Map<? extends T, ? extends V> map) {
        this(map, 0.75f);
    }

    public Object2ObjectOpenHashMap(Map<? extends T, ? extends V> map, float loadFactor) {
        this(map.size(), loadFactor);
        this.putAll(map);
    }

    public Object2ObjectOpenHashMap(Object2ObjectMap<T, V> map) {
        this(map, 0.75f);
    }

    public Object2ObjectOpenHashMap(Object2ObjectMap<T, V> map, float loadFactor) {
        this(map.size(), loadFactor);
        this.putAll(map);
    }

    @Override
    public V put(T key, V value) {
        int slot = this.findIndex(key);
        if (slot < 0) {
            this.insert(-slot - 1, key, value);
            return this.getDefaultReturnValue();
        }
        V oldValue = this.values[slot];
        this.values[slot] = value;
        return oldValue;
    }

    @Override
    public V putIfAbsent(T key, V value) {
        int slot = this.findIndex(key);
        if (slot < 0) {
            this.insert(-slot - 1, key, value);
            return this.getDefaultReturnValue();
        }
        if (Objects.equals(this.values[slot], this.getDefaultReturnValue())) {
            V oldValue = this.values[slot];
            this.values[slot] = value;
            return oldValue;
        }
        return this.values[slot];
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findIndex(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.containsNull && Objects.equals(this.values[this.nullIndex], value)) {
            return true;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null || !Objects.equals(value, this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public V rem(T key) {
        int slot = this.findIndex(key);
        if (slot < 0) {
            return this.getDefaultReturnValue();
        }
        return this.removeIndex(slot);
    }

    @Override
    public V remOrDefault(T key, V defaultValue) {
        int slot = this.findIndex(key);
        if (slot < 0) {
            return defaultValue;
        }
        return this.removeIndex(slot);
    }

    @Override
    public V remove(Object key) {
        int slot = this.findIndex(key);
        if (slot < 0) {
            return this.getDefaultReturnValue();
        }
        return this.removeIndex(slot);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Objects.requireNonNull(value);
        if (key == null) {
            if (this.containsNull && Objects.equals(value, this.values[this.nullIndex])) {
                this.removeNullIndex();
                return true;
            }
            return false;
        }
        int pos = HashUtil.mix(key.hashCode()) & this.mask;
        T current = this.keys[pos];
        if (current == null) {
            return false;
        }
        if (Objects.equals(key, current) && Objects.equals(value, this.values[pos])) {
            this.removeIndex(pos);
            return true;
        }
        do {
            ++pos;
            current = this.keys[pos &= this.mask];
            if (current != null) continue;
            return false;
        } while (!Objects.equals(key, current) || !Objects.equals(value, this.values[pos]));
        this.removeIndex(pos);
        return true;
    }

    @Override
    public V getObject(T key) {
        int slot = this.findIndex(key);
        return slot < 0 ? this.getDefaultReturnValue() : this.values[slot];
    }

    @Override
    public V get(Object key) {
        int slot = this.findIndex(key);
        return slot < 0 ? this.getDefaultReturnValue() : this.values[slot];
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        int slot = this.findIndex(key);
        return slot < 0 ? defaultValue : this.values[slot];
    }

    @Override
    public Object2ObjectOpenHashMap<T, V> copy() {
        Object2ObjectOpenHashMap<T, V> map = new Object2ObjectOpenHashMap<T, V>(0, this.loadFactor);
        map.minCapacity = this.minCapacity;
        map.mask = this.mask;
        map.maxFill = this.maxFill;
        map.nullIndex = this.nullIndex;
        map.containsNull = this.containsNull;
        map.size = this.size;
        map.keys = Arrays.copyOf(this.keys, this.keys.length);
        map.values = Arrays.copyOf(this.values, this.values.length);
        return map;
    }

    @Override
    public ObjectSet<Object2ObjectMap.Entry<T, V>> object2ObjectEntrySet() {
        if (this.entrySet == null) {
            this.entrySet = new MapEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public ObjectSet<T> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.valuesC == null) {
            this.valuesC = new Values();
        }
        return this.valuesC;
    }

    @Override
    public void forEach(ObjectObjectConsumer<T, V> action) {
        if (this.size() <= 0) {
            return;
        }
        if (this.containsNull) {
            action.accept(this.keys[this.nullIndex], this.values[this.nullIndex]);
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null) continue;
            action.accept(this.keys[i], this.values[i]);
        }
    }

    @Override
    public boolean replace(T key, V oldValue, V newValue) {
        int index = this.findIndex(key);
        if (index < 0 || this.values[index] != oldValue) {
            return false;
        }
        this.values[index] = newValue;
        return true;
    }

    @Override
    public V replace(T key, V value) {
        int index = this.findIndex(key);
        if (index < 0) {
            return this.getDefaultReturnValue();
        }
        V oldValue = this.values[index];
        this.values[index] = value;
        return oldValue;
    }

    @Override
    public V compute(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int index = this.findIndex(key);
        if (index < 0) {
            Object newValue = mappingFunction.apply(key, this.getDefaultReturnValue());
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return (V)newValue;
            }
            this.insert(-index - 1, key, newValue);
            return (V)newValue;
        }
        Object newValue = mappingFunction.apply(key, this.values[index]);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            this.removeIndex(index);
            return (V)newValue;
        }
        this.values[index] = newValue;
        return (V)newValue;
    }

    @Override
    public V computeIfAbsent(T key, UnaryOperator<T, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int index = this.findIndex(key);
        if (index < 0) {
            V newValue = mappingFunction.apply(key);
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.insert(-index - 1, key, newValue);
            return newValue;
        }
        V newValue = this.values[index];
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            newValue = mappingFunction.apply(key);
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.values[index] = newValue;
        }
        return newValue;
    }

    @Override
    public V supplyIfAbsent(T key, ObjectSupplier<V> valueProvider) {
        Objects.requireNonNull(valueProvider);
        int index = this.findIndex(key);
        if (index < 0) {
            V newValue = valueProvider.get();
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.insert(-index - 1, key, newValue);
            return newValue;
        }
        V newValue = this.values[index];
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            newValue = valueProvider.get();
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.values[index] = newValue;
        }
        return newValue;
    }

    @Override
    public V computeIfPresent(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int index = this.findIndex(key);
        if (index < 0 || Objects.equals(this.values[index], this.getDefaultReturnValue())) {
            return this.getDefaultReturnValue();
        }
        Object newValue = mappingFunction.apply(key, this.values[index]);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            this.removeIndex(index);
            return (V)newValue;
        }
        this.values[index] = newValue;
        return (V)newValue;
    }

    @Override
    public V merge(T key, V value, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Objects.requireNonNull(value);
        int index = this.findIndex(key);
        Object object = newValue = index < 0 || Objects.equals(this.values[index], this.getDefaultReturnValue()) ? value : mappingFunction.apply(this.values[index], value);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            if (index >= 0) {
                this.removeIndex(index);
            }
        } else if (index < 0) {
            this.insert(-index - 1, key, newValue);
        } else {
            this.values[index] = newValue;
        }
        return newValue;
    }

    @Override
    public void mergeAll(Object2ObjectMap<T, V> m, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        for (Object2ObjectMap.Entry entry : this.getFastIterable(m)) {
            Object newValue;
            Object key = entry.getKey();
            int index = this.findIndex(key);
            Object object = newValue = index < 0 || Objects.equals(this.values[index], this.getDefaultReturnValue()) ? entry.getValue() : mappingFunction.apply(this.values[index], entry.getValue());
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                if (index < 0) continue;
                this.removeIndex(index);
                continue;
            }
            if (index < 0) {
                this.insert(-index - 1, key, newValue);
                continue;
            }
            this.values[index] = newValue;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
    }

    @Override
    public boolean trim(int size) {
        int request = Math.max(this.minCapacity, HashUtil.nextPowerOfTwo((int)Math.ceil((float)size / this.loadFactor)));
        if (request >= this.nullIndex || this.size >= Math.min((int)Math.ceil((float)request * this.loadFactor), request - 1)) {
            return false;
        }
        try {
            this.rehash(request);
        }
        catch (OutOfMemoryError noMemory) {
            return false;
        }
        return true;
    }

    @Override
    public void clearAndTrim(int size) {
        int request = Math.max(this.minCapacity, HashUtil.nextPowerOfTwo((int)Math.ceil((float)size / this.loadFactor)));
        if (request >= this.nullIndex) {
            this.clear();
            return;
        }
        this.nullIndex = request;
        this.mask = request - 1;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = new Object[request + 1];
        this.values = new Object[request + 1];
        this.size = 0;
        this.containsNull = false;
    }

    protected int findIndex(Object key) {
        int pos;
        block4: {
            if (key == null) {
                return this.containsNull ? this.nullIndex : -(this.nullIndex + 1);
            }
            pos = HashUtil.mix(key.hashCode()) & this.mask;
            T current = this.keys[pos];
            if (current != null) {
                if (Objects.equals(key, current)) {
                    return pos;
                }
                do {
                    ++pos;
                    current = this.keys[pos &= this.mask];
                    if (current == null) break block4;
                } while (!Objects.equals(key, current));
                return pos;
            }
        }
        return -(pos + 1);
    }

    protected V removeIndex(int pos) {
        if (pos == this.nullIndex) {
            return this.containsNull ? this.removeNullIndex() : this.getDefaultReturnValue();
        }
        V value = this.values[pos];
        this.keys[pos] = null;
        this.values[pos] = null;
        --this.size;
        this.onNodeRemoved(pos);
        this.shiftKeys(pos);
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return value;
    }

    protected V removeNullIndex() {
        V value = this.values[this.nullIndex];
        this.containsNull = false;
        this.keys[this.nullIndex] = null;
        this.values[this.nullIndex] = null;
        --this.size;
        this.onNodeRemoved(this.nullIndex);
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return value;
    }

    protected void insert(int slot, T key, V value) {
        if (slot == this.nullIndex) {
            this.containsNull = true;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        this.onNodeAdded(slot);
        if (this.size++ >= this.maxFill) {
            this.rehash(HashUtil.arraySize(this.size + 1, this.loadFactor));
        }
    }

    protected void rehash(int newSize) {
        int newMask = newSize - 1;
        Object[] newKeys = new Object[newSize + 1];
        Object[] newValues = new Object[newSize + 1];
        int i = this.nullIndex;
        int pos = 0;
        int j = this.size - (this.containsNull ? 1 : 0);
        while (j-- != 0) {
            do {
                if (--i >= 0) continue;
                throw new ConcurrentModificationException("Map was modified during rehash");
            } while (this.keys[i] == null);
            pos = HashUtil.mix(Objects.hashCode(this.keys[i])) & newMask;
            if (newKeys[pos] != null) {
                do {
                    ++pos;
                } while (newKeys[pos &= newMask] != null);
            }
            newKeys[pos] = this.keys[i];
            newValues[pos] = this.values[i];
        }
        newValues[newSize] = this.values[this.nullIndex];
        this.nullIndex = newSize;
        this.mask = newMask;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = newKeys;
        this.values = newValues;
    }

    protected void onNodeAdded(int pos) {
    }

    protected void onNodeRemoved(int pos) {
    }

    protected void onNodeMoved(int from, int to) {
    }

    protected void shiftKeys(int startPos) {
        while (true) {
            T current;
            int last = startPos;
            startPos = last + 1 & this.mask;
            while (true) {
                if ((current = this.keys[startPos]) == null) {
                    this.keys[last] = null;
                    this.values[last] = null;
                    return;
                }
                int slot = HashUtil.mix(Objects.hashCode(current)) & this.mask;
                if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                ++startPos;
                startPos &= this.mask;
            }
            this.keys[last] = current;
            this.values[last] = this.values[startPos];
            this.onNodeMoved(startPos, last);
        }
    }

    private class MapIterator {
        int pos;
        int returnedPos;
        int lastReturned;
        int nextIndex;
        boolean returnNull;
        T[] wrapped;
        int wrappedIndex;

        private MapIterator() {
            this.pos = Object2ObjectOpenHashMap.this.nullIndex;
            this.returnedPos = -1;
            this.lastReturned = -1;
            this.nextIndex = Integer.MIN_VALUE;
            this.returnNull = Object2ObjectOpenHashMap.this.containsNull;
            this.wrapped = null;
            this.wrappedIndex = 0;
        }

        public boolean hasNext() {
            block5: {
                if (this.nextIndex == Integer.MIN_VALUE) {
                    if (this.returnNull) {
                        this.returnNull = false;
                        this.nextIndex = Object2ObjectOpenHashMap.this.nullIndex;
                    } else {
                        do {
                            if (--this.pos >= 0) continue;
                            if (this.wrapped != null && this.wrappedIndex > -this.pos - 1) {
                                this.nextIndex = -this.pos - 1;
                            }
                            break block5;
                        } while (Object2ObjectOpenHashMap.this.keys[this.pos] == null);
                        this.nextIndex = this.pos;
                    }
                }
            }
            return this.nextIndex != Integer.MIN_VALUE;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.returnedPos = this.pos;
            if (this.nextIndex < 0) {
                this.lastReturned = Integer.MAX_VALUE;
                int value = Object2ObjectOpenHashMap.this.findIndex(this.wrapped[this.nextIndex]);
                if (value < 0) {
                    throw new IllegalStateException("Entry [" + this.nextIndex + "] was removed during Iteration");
                }
                this.nextIndex = Integer.MIN_VALUE;
                return value;
            }
            int value = this.lastReturned = this.nextIndex;
            this.nextIndex = Integer.MIN_VALUE;
            return value;
        }

        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            if (this.lastReturned == Object2ObjectOpenHashMap.this.nullIndex) {
                Object2ObjectOpenHashMap.this.containsNull = false;
                Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex] = null;
                Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex] = null;
            } else if (this.returnedPos >= 0) {
                this.shiftKeys(this.returnedPos);
            } else {
                Object2ObjectOpenHashMap.this.remove(this.wrapped[-this.returnedPos - 1]);
                this.lastReturned = -1;
                return;
            }
            --Object2ObjectOpenHashMap.this.size;
            this.lastReturned = -1;
        }

        private void shiftKeys(int startPos) {
            while (true) {
                Object current;
                int last = startPos;
                startPos = last + 1 & Object2ObjectOpenHashMap.this.mask;
                while (true) {
                    if ((current = Object2ObjectOpenHashMap.this.keys[startPos]) == null) {
                        Object2ObjectOpenHashMap.this.keys[last] = null;
                        Object2ObjectOpenHashMap.this.values[last] = null;
                        return;
                    }
                    int slot = HashUtil.mix(Objects.hashCode(current)) & Object2ObjectOpenHashMap.this.mask;
                    if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                    ++startPos;
                    startPos &= Object2ObjectOpenHashMap.this.mask;
                }
                if (startPos < last) {
                    this.addWrapper(Object2ObjectOpenHashMap.this.keys[startPos]);
                }
                Object2ObjectOpenHashMap.this.keys[last] = current;
                Object2ObjectOpenHashMap.this.values[last] = Object2ObjectOpenHashMap.this.values[startPos];
            }
        }

        private void addWrapper(T value) {
            if (this.wrapped == null) {
                this.wrapped = new Object[2];
            } else if (this.wrappedIndex >= this.wrapped.length) {
                Object[] newArray = new Object[this.wrapped.length * 2];
                System.arraycopy(this.wrapped, 0, newArray, 0, this.wrapped.length);
                this.wrapped = newArray;
            }
            this.wrapped[this.wrappedIndex++] = value;
        }
    }

    private class ValueIterator
    extends MapIterator
    implements ObjectIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return Object2ObjectOpenHashMap.this.values[this.nextEntry()];
        }
    }

    private class KeyIterator
    extends MapIterator
    implements ObjectIterator<T> {
        private KeyIterator() {
        }

        @Override
        public T next() {
            return Object2ObjectOpenHashMap.this.keys[this.nextEntry()];
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Object2ObjectMap.Entry<T, V>> {
        MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Object2ObjectMap.Entry<T, V> next() {
            this.entry = new ValueMapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Object2ObjectMap.Entry<T, V>> {
        MapEntry entry;

        private FastEntryIterator() {
            this.entry = new MapEntry();
        }

        @Override
        public Object2ObjectMap.Entry<T, V> next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }
    }

    private class Values
    extends AbstractObjectCollection<V> {
        private Values() {
        }

        @Override
        public boolean contains(Object e) {
            return Object2ObjectOpenHashMap.this.containsValue(e);
        }

        @Override
        public boolean add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectIterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return Object2ObjectOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            Object2ObjectOpenHashMap.this.clear();
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            if (Object2ObjectOpenHashMap.this.containsNull) {
                action.accept(Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                action.accept(Object2ObjectOpenHashMap.this.values[i]);
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<V> action) {
            int index;
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Object2ObjectOpenHashMap.this.containsNull) {
                action.accept(0, Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex]);
            }
            int n = index = Object2ObjectOpenHashMap.this.containsNull ? 1 : 0;
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                action.accept(index++, Object2ObjectOpenHashMap.this.values[i]);
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, V> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Object2ObjectOpenHashMap.this.containsNull) {
                action.accept(input, Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                action.accept(input, Object2ObjectOpenHashMap.this.values[i]);
            }
        }

        @Override
        public boolean matchesAny(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            if (Object2ObjectOpenHashMap.this.containsNull && filter.test(Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex])) {
                return true;
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null || !filter.test(Object2ObjectOpenHashMap.this.values[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            if (Object2ObjectOpenHashMap.this.containsNull && filter.test(Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex])) {
                return false;
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null || !filter.test(Object2ObjectOpenHashMap.this.values[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            if (Object2ObjectOpenHashMap.this.containsNull && !filter.test(Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex])) {
                return false;
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null || filter.test(Object2ObjectOpenHashMap.this.values[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, V, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            if (Object2ObjectOpenHashMap.this.containsNull) {
                state = operator.apply(state, Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                state = operator.apply(state, Object2ObjectOpenHashMap.this.values[i]);
            }
            return state;
        }

        @Override
        public V reduce(ObjectObjectUnaryOperator<V, V> operator) {
            Objects.requireNonNull(operator);
            Object state = null;
            boolean empty = true;
            if (Object2ObjectOpenHashMap.this.containsNull) {
                state = Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex];
                empty = false;
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                if (empty) {
                    empty = false;
                    state = Object2ObjectOpenHashMap.this.values[i];
                    continue;
                }
                state = operator.apply(state, Object2ObjectOpenHashMap.this.values[i]);
            }
            return state;
        }

        @Override
        public V findFirst(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            if (Object2ObjectOpenHashMap.this.containsNull && filter.test(Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex])) {
                return Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex];
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null || !filter.test(Object2ObjectOpenHashMap.this.values[i])) continue;
                return Object2ObjectOpenHashMap.this.values[i];
            }
            return null;
        }

        @Override
        public int count(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            int result = 0;
            if (Object2ObjectOpenHashMap.this.containsNull && filter.test(Object2ObjectOpenHashMap.this.values[Object2ObjectOpenHashMap.this.nullIndex])) {
                ++result;
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null || !filter.test(Object2ObjectOpenHashMap.this.values[i])) continue;
                ++result;
            }
            return result;
        }
    }

    private final class KeySet
    extends AbstractObjectSet<T> {
        private KeySet() {
        }

        @Override
        public boolean contains(Object e) {
            return Object2ObjectOpenHashMap.this.containsKey(e);
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = Object2ObjectOpenHashMap.this.size;
            Object2ObjectOpenHashMap.this.remove(o);
            return Object2ObjectOpenHashMap.this.size != oldSize;
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectIterator<T> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Object2ObjectOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            Object2ObjectOpenHashMap.this.clear();
        }

        @Override
        public KeySet copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            if (Object2ObjectOpenHashMap.this.containsNull) {
                action.accept(Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                action.accept(Object2ObjectOpenHashMap.this.keys[i]);
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<T> action) {
            int index;
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Object2ObjectOpenHashMap.this.containsNull) {
                action.accept(0, Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex]);
            }
            int n = index = Object2ObjectOpenHashMap.this.containsNull ? 1 : 0;
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                action.accept(index++, Object2ObjectOpenHashMap.this.keys[i]);
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, T> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Object2ObjectOpenHashMap.this.containsNull) {
                action.accept(input, (E)Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                action.accept(input, (E)Object2ObjectOpenHashMap.this.keys[i]);
            }
        }

        @Override
        public boolean matchesAny(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            if (Object2ObjectOpenHashMap.this.containsNull && filter.test(Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex])) {
                return true;
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null || !filter.test(Object2ObjectOpenHashMap.this.keys[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            if (Object2ObjectOpenHashMap.this.containsNull && filter.test(Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex])) {
                return false;
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null || !filter.test(Object2ObjectOpenHashMap.this.keys[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            if (Object2ObjectOpenHashMap.this.containsNull && !filter.test(Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex])) {
                return false;
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null || filter.test(Object2ObjectOpenHashMap.this.keys[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, T, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            if (Object2ObjectOpenHashMap.this.containsNull) {
                state = operator.apply(state, Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                state = operator.apply(state, Object2ObjectOpenHashMap.this.keys[i]);
            }
            return state;
        }

        @Override
        public T reduce(ObjectObjectUnaryOperator<T, T> operator) {
            Objects.requireNonNull(operator);
            Object state = null;
            boolean empty = true;
            if (Object2ObjectOpenHashMap.this.containsNull) {
                state = Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex];
                empty = false;
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                if (empty) {
                    empty = false;
                    state = Object2ObjectOpenHashMap.this.keys[i];
                    continue;
                }
                state = operator.apply(state, Object2ObjectOpenHashMap.this.keys[i]);
            }
            return state;
        }

        @Override
        public T findFirst(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            if (Object2ObjectOpenHashMap.this.containsNull && filter.test(Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex])) {
                return Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex];
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null || !filter.test(Object2ObjectOpenHashMap.this.keys[i])) continue;
                return Object2ObjectOpenHashMap.this.keys[i];
            }
            return null;
        }

        @Override
        public int count(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            int result = 0;
            if (Object2ObjectOpenHashMap.this.containsNull && filter.test(Object2ObjectOpenHashMap.this.keys[Object2ObjectOpenHashMap.this.nullIndex])) {
                ++result;
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null || !filter.test(Object2ObjectOpenHashMap.this.keys[i])) continue;
                ++result;
            }
            return result;
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Object2ObjectMap.Entry<T, V>>
    implements Object2ObjectMap.FastEntrySet<T, V> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Object2ObjectMap.Entry<T, V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectIterator<Object2ObjectMap.Entry<T, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public void forEach(Consumer<? super Object2ObjectMap.Entry<T, V>> action) {
            if (Object2ObjectOpenHashMap.this.containsNull) {
                action.accept(new ValueMapEntry(Object2ObjectOpenHashMap.this.nullIndex));
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                action.accept(new ValueMapEntry(i));
            }
        }

        @Override
        public void fastForEach(Consumer<? super Object2ObjectMap.Entry<T, V>> action) {
            MapEntry entry = new MapEntry();
            if (Object2ObjectOpenHashMap.this.containsNull) {
                entry.set(Object2ObjectOpenHashMap.this.nullIndex);
                action.accept(entry);
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                entry.set(i);
                action.accept(entry);
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<Object2ObjectMap.Entry<T, V>> action) {
            int index;
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Object2ObjectOpenHashMap.this.containsNull) {
                action.accept(0, (Object2ObjectMap.Entry)new ValueMapEntry(Object2ObjectOpenHashMap.this.nullIndex));
            }
            int n = index = Object2ObjectOpenHashMap.this.containsNull ? 1 : 0;
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                action.accept(index++, (Object2ObjectMap.Entry)new ValueMapEntry(i));
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, Object2ObjectMap.Entry<T, V>> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Object2ObjectOpenHashMap.this.containsNull) {
                action.accept(input, new ValueMapEntry(Object2ObjectOpenHashMap.this.nullIndex));
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                action.accept(input, new ValueMapEntry(i));
            }
        }

        @Override
        public boolean matchesAny(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            MapEntry entry = new MapEntry();
            if (Object2ObjectOpenHashMap.this.containsNull) {
                entry.set(Object2ObjectOpenHashMap.this.nullIndex);
                if (filter.test(entry)) {
                    return true;
                }
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                entry.set(i);
                if (!filter.test(entry)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            MapEntry entry = new MapEntry();
            if (Object2ObjectOpenHashMap.this.containsNull) {
                entry.set(Object2ObjectOpenHashMap.this.nullIndex);
                if (filter.test(entry)) {
                    return false;
                }
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                entry.set(i);
                if (!filter.test(entry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            MapEntry entry = new MapEntry();
            if (Object2ObjectOpenHashMap.this.containsNull) {
                entry.set(Object2ObjectOpenHashMap.this.nullIndex);
                if (!filter.test(entry)) {
                    return false;
                }
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                entry.set(i);
                if (filter.test(entry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, Object2ObjectMap.Entry<T, V>, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            if (Object2ObjectOpenHashMap.this.containsNull) {
                state = operator.apply(state, new ValueMapEntry(Object2ObjectOpenHashMap.this.nullIndex));
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                state = operator.apply(state, new ValueMapEntry(i));
            }
            return state;
        }

        @Override
        public Object2ObjectMap.Entry<T, V> reduce(ObjectObjectUnaryOperator<Object2ObjectMap.Entry<T, V>, Object2ObjectMap.Entry<T, V>> operator) {
            Objects.requireNonNull(operator);
            Object2ObjectMap.Entry state = null;
            boolean empty = true;
            if (Object2ObjectOpenHashMap.this.containsNull) {
                state = new ValueMapEntry(Object2ObjectOpenHashMap.this.nullIndex);
                empty = false;
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                if (empty) {
                    empty = false;
                    state = new ValueMapEntry(i);
                    continue;
                }
                state = (Object2ObjectMap.Entry)operator.apply(state, new ValueMapEntry(i));
            }
            return state;
        }

        @Override
        public Object2ObjectMap.Entry<T, V> findFirst(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            MapEntry entry = new MapEntry();
            if (Object2ObjectOpenHashMap.this.containsNull) {
                entry.set(Object2ObjectOpenHashMap.this.nullIndex);
                if (filter.test(entry)) {
                    return entry;
                }
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                entry.set(i);
                if (!filter.test(entry)) continue;
                return entry;
            }
            return null;
        }

        @Override
        public int count(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            MapEntry entry = new MapEntry();
            int result = 0;
            if (Object2ObjectOpenHashMap.this.containsNull) {
                entry.set(Object2ObjectOpenHashMap.this.nullIndex);
                if (filter.test(entry)) {
                    ++result;
                }
            }
            for (int i = Object2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Object2ObjectOpenHashMap.this.keys[i] == null) continue;
                entry.set(i);
                if (!filter.test(entry)) continue;
                ++result;
            }
            return result;
        }

        @Override
        public int size() {
            return Object2ObjectOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            Object2ObjectOpenHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                if (o instanceof Object2ObjectMap.Entry) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)o;
                    int index = Object2ObjectOpenHashMap.this.findIndex(entry.getKey());
                    if (index >= 0) {
                        return Objects.equals(entry.getValue(), Object2ObjectOpenHashMap.this.values[index]);
                    }
                } else {
                    Map.Entry entry = (Map.Entry)o;
                    int index = Object2ObjectOpenHashMap.this.findIndex(entry.getKey());
                    if (index >= 0) {
                        return Objects.equals(entry.getValue(), Object2ObjectOpenHashMap.this.values[index]);
                    }
                }
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                if (o instanceof Object2ObjectMap.Entry) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)o;
                    return Object2ObjectOpenHashMap.this.remove(entry.getKey(), entry.getValue());
                }
                Map.Entry entry = (Map.Entry)o;
                return Object2ObjectOpenHashMap.this.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }
    }

    protected class MapEntry
    implements Object2ObjectMap.Entry<T, V>,
    Map.Entry<T, V> {
        public int index = -1;

        public MapEntry() {
        }

        public MapEntry(int index) {
            this.index = index;
        }

        void set(int index) {
            this.index = index;
        }

        @Override
        public T getKey() {
            return Object2ObjectOpenHashMap.this.keys[this.index];
        }

        @Override
        public V getValue() {
            return Object2ObjectOpenHashMap.this.values[this.index];
        }

        @Override
        public V setValue(V value) {
            Object oldValue = Object2ObjectOpenHashMap.this.values[this.index];
            Object2ObjectOpenHashMap.this.values[this.index] = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                if (obj instanceof Object2ObjectMap.Entry) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)obj;
                    return Objects.equals(this.getKey(), entry.getKey()) && Objects.equals(this.getValue(), entry.getValue());
                }
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                return Objects.equals(this.getKey(), key) && Objects.equals(this.getValue(), value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
        }

        public String toString() {
            return Objects.toString(this.getKey()) + "=" + Objects.toString(this.getValue());
        }
    }

    protected class ValueMapEntry
    extends MapEntry {
        protected T key;
        protected V value;

        public ValueMapEntry(int index) {
            super(index);
            this.key = Object2ObjectOpenHashMap.this.keys[index];
            this.value = Object2ObjectOpenHashMap.this.values[index];
        }

        @Override
        public T getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return super.setValue(value);
        }
    }
}

