/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.maps.abstracts;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import speiger.src.collections.objects.collections.AbstractObjectCollection;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.ObjectSupplier;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.functions.function.UnaryOperator;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;
import speiger.src.collections.objects.sets.AbstractObjectSet;
import speiger.src.collections.objects.sets.ObjectSet;
import speiger.src.collections.objects.utils.maps.Object2ObjectMaps;
import speiger.src.collections.utils.SanityChecks;

public abstract class AbstractObject2ObjectMap<T, V>
extends AbstractMap<T, V>
implements Object2ObjectMap<T, V> {
    protected V defaultReturnValue = null;

    @Override
    public V getDefaultReturnValue() {
        return this.defaultReturnValue;
    }

    @Override
    public AbstractObject2ObjectMap<T, V> setDefaultReturnValue(V v) {
        this.defaultReturnValue = v;
        return this;
    }

    protected ObjectIterable<Object2ObjectMap.Entry<T, V>> getFastIterable(Object2ObjectMap<T, V> map) {
        return Object2ObjectMaps.fastIterable(map);
    }

    protected ObjectIterator<Object2ObjectMap.Entry<T, V>> getFastIterator(Object2ObjectMap<T, V> map) {
        return Object2ObjectMaps.fastIterator(map);
    }

    @Override
    public Object2ObjectMap<T, V> copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Object2ObjectMap<T, V> m) {
        ObjectIterator<Object2ObjectMap.Entry<T, V>> iter = this.getFastIterator(m);
        while (iter.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(Map<? extends T, ? extends V> m) {
        if (m instanceof Object2ObjectMap) {
            this.putAll((Object2ObjectMap)m);
        } else {
            super.putAll(m);
        }
    }

    @Override
    public void putAll(T[] keys, V[] values, int offset, int size) {
        SanityChecks.checkArrayCapacity(keys.length, offset, size);
        SanityChecks.checkArrayCapacity(values.length, offset, size);
        for (int i = 0; i < size; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    @Override
    public void putAllIfAbsent(Object2ObjectMap<T, V> m) {
        for (Object2ObjectMap.Entry entry : this.getFastIterable(m)) {
            this.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            if (!Objects.equals(key, iter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator iter = this.values().iterator();
        while (iter.hasNext()) {
            if (!Objects.equals(value, iter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(T key, V oldValue, V newValue) {
        Object curValue = this.getObject(key);
        if (!Objects.equals(curValue, oldValue) || Objects.equals(curValue, this.getDefaultReturnValue()) && !this.containsKey(key)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @Override
    public V replace(T key, V value) {
        Object curValue = this.getObject(key);
        if (!Objects.equals(curValue, this.getDefaultReturnValue()) || this.containsKey(key)) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public void replaceObjects(Object2ObjectMap<T, V> m) {
        for (Object2ObjectMap.Entry entry : this.getFastIterable(m)) {
            this.replace((T)entry.getKey(), (V)entry.getValue());
        }
    }

    @Override
    public void replaceObjects(ObjectObjectUnaryOperator<T, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        ObjectIterator<Object2ObjectMap.Entry<T, V>> iter = this.getFastIterator(this);
        while (iter.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iter.next();
            entry.setValue(mappingFunction.apply(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public V compute(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Object value = this.getObject(key);
        Object newValue = mappingFunction.apply(key, value);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            if (!Objects.equals(value, this.getDefaultReturnValue()) || this.containsKey(key)) {
                this.remove(key);
                return this.getDefaultReturnValue();
            }
            return this.getDefaultReturnValue();
        }
        this.put(key, newValue);
        return (V)newValue;
    }

    @Override
    public V computeIfAbsent(T key, UnaryOperator<T, V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Object value = this.getObject(key);
        if (!(value != this.getDefaultReturnValue() && this.containsKey(key) || Objects.equals(newValue = mappingFunction.apply(key), this.getDefaultReturnValue()))) {
            this.put(key, newValue);
            return newValue;
        }
        return value;
    }

    @Override
    public V supplyIfAbsent(T key, ObjectSupplier<V> valueProvider) {
        V newValue;
        Objects.requireNonNull(valueProvider);
        Object value = this.getObject(key);
        if (!(value != this.getDefaultReturnValue() && this.containsKey(key) || Objects.equals(newValue = valueProvider.get(), this.getDefaultReturnValue()))) {
            this.put(key, newValue);
            return newValue;
        }
        return value;
    }

    @Override
    public V computeIfPresent(T key, ObjectObjectUnaryOperator<T, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Object value = this.getObject(key);
        if (!Objects.equals(value, this.getDefaultReturnValue()) || this.containsKey(key)) {
            Object newValue = mappingFunction.apply(key, value);
            if (!Objects.equals(newValue, this.getDefaultReturnValue())) {
                this.put(key, newValue);
                return (V)newValue;
            }
            this.remove(key);
        }
        return this.getDefaultReturnValue();
    }

    @Override
    public V merge(T key, V value, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Object oldValue = this.getObject(key);
        Object object = newValue = Objects.equals(oldValue, this.getDefaultReturnValue()) ? value : mappingFunction.apply(oldValue, value);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            this.remove(key);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }

    @Override
    public void mergeAll(Object2ObjectMap<T, V> m, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        for (Object2ObjectMap.Entry entry : this.getFastIterable(m)) {
            Object newValue;
            Object key = entry.getKey();
            Object oldValue = this.getObject(key);
            Object object = newValue = Objects.equals(oldValue, this.getDefaultReturnValue()) ? entry.getValue() : mappingFunction.apply(oldValue, entry.getValue());
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                this.remove(key);
                continue;
            }
            this.put(key, newValue);
        }
    }

    @Override
    public V get(Object key) {
        return this.getObject(key);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V value = this.get(key);
        return !Objects.equals(value, this.getDefaultReturnValue()) || this.containsKey(key) ? value : defaultValue;
    }

    @Override
    public V remove(Object key) {
        return this.rem(key);
    }

    @Override
    public void forEach(ObjectObjectConsumer<T, V> action) {
        Objects.requireNonNull(action);
        ObjectIterator<Object2ObjectMap.Entry<T, V>> iter = this.getFastIterator(this);
        while (iter.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iter.next();
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public ObjectSet<T> keySet() {
        return new AbstractObjectSet<T>(){

            @Override
            public boolean remove(Object o) {
                if (AbstractObject2ObjectMap.this.containsKey(o)) {
                    AbstractObject2ObjectMap.this.remove(o);
                    return true;
                }
                return false;
            }

            @Override
            public boolean add(T o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ObjectIterator<T> iterator() {
                return new ObjectIterator<T>(){
                    ObjectIterator<Object2ObjectMap.Entry<T, V>> iter;
                    {
                        this.iter = AbstractObject2ObjectMap.this.getFastIterator(AbstractObject2ObjectMap.this);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public T next() {
                        return ((Object2ObjectMap.Entry)this.iter.next()).getKey();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractObject2ObjectMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2ObjectMap.this.clear();
            }
        };
    }

    @Override
    public ObjectCollection<V> values() {
        return new AbstractObjectCollection<V>(){

            @Override
            public boolean add(V o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return AbstractObject2ObjectMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2ObjectMap.this.clear();
            }

            @Override
            public ObjectIterator<V> iterator() {
                return new ObjectIterator<V>(){
                    ObjectIterator<Object2ObjectMap.Entry<T, V>> iter;
                    {
                        this.iter = AbstractObject2ObjectMap.this.getFastIterator(AbstractObject2ObjectMap.this);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((Object2ObjectMap.Entry)this.iter.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }
        };
    }

    @Override
    public ObjectSet<Map.Entry<T, V>> entrySet() {
        return this.object2ObjectEntrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Map) {
            if (this.size() != ((Map)o).size()) {
                return false;
            }
            if (o instanceof Object2ObjectMap) {
                return this.object2ObjectEntrySet().containsAll(((Object2ObjectMap)o).object2ObjectEntrySet());
            }
            return this.object2ObjectEntrySet().containsAll(((Map)o).entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        ObjectIterator<Object2ObjectMap.Entry<T, V>> iter = this.getFastIterator(this);
        while (iter.hasNext()) {
            hash += ((Object2ObjectMap.Entry)iter.next()).hashCode();
        }
        return hash;
    }

    public static class BasicEntry<T, V>
    implements Object2ObjectMap.Entry<T, V> {
        protected T key;
        protected V value;

        public BasicEntry() {
        }

        public BasicEntry(T key, V value) {
            this.key = key;
            this.value = value;
        }

        public void set(T key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public T getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                if (obj instanceof Object2ObjectMap.Entry) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)obj;
                    return Objects.equals(this.key, entry.getKey()) && Objects.equals(this.value, entry.getValue());
                }
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                return Objects.equals(this.key, key) && Objects.equals(this.value, value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return Objects.toString(this.key) + "=" + Objects.toString(this.value);
        }
    }
}

