/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.doubles.functions;

import java.util.Comparator;
import java.util.Objects;

public interface DoubleComparator
extends Comparator<Double> {
    @Override
    public int compare(double var1, double var3);

    @Override
    @Deprecated
    default public int compare(Double o1, Double o2) {
        return this.compare((double)o1, (double)o2);
    }

    public static DoubleComparator of(Comparator<Double> c) {
        Objects.requireNonNull(c);
        return (K, V) -> c.compare(K, V);
    }

    default public DoubleComparator reversed() {
        return new Reversed(this);
    }

    public static class Reversed
    implements DoubleComparator {
        DoubleComparator original;

        public Reversed(DoubleComparator original) {
            this.original = original;
        }

        @Override
        public int compare(double o1, double o2) {
            return this.original.compare(o2, o1);
        }

        @Override
        public DoubleComparator reversed() {
            return this.original;
        }
    }
}

