/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import speiger.src.collections.chars.collections.CharBidirectionalIterator;
import speiger.src.collections.chars.collections.CharCollection;
import speiger.src.collections.chars.collections.CharIterator;
import speiger.src.collections.chars.functions.CharComparator;
import speiger.src.collections.chars.functions.CharConsumer;
import speiger.src.collections.chars.functions.function.CharFunction;
import speiger.src.collections.chars.functions.function.CharPredicate;
import speiger.src.collections.chars.lists.CharListIterator;
import speiger.src.collections.chars.utils.CharCollections;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.consumer.ObjectCharConsumer;
import speiger.src.collections.objects.utils.ObjectIterators;

public class CharIterators {
    private static final EmptyIterator EMPTY = new EmptyIterator();

    public static EmptyIterator empty() {
        return EMPTY;
    }

    public static CharBidirectionalIterator invert(CharBidirectionalIterator it) {
        return it instanceof ReverseBiIterator ? ((ReverseBiIterator)it).it : new ReverseBiIterator(it);
    }

    public static CharListIterator invert(CharListIterator it) {
        return it instanceof ReverseListIterator ? ((ReverseListIterator)it).it : new ReverseListIterator(it);
    }

    public static CharIterator unmodifiable(CharIterator iterator) {
        return iterator instanceof UnmodifiableIterator ? iterator : new UnmodifiableIterator(iterator);
    }

    public static CharBidirectionalIterator unmodifiable(CharBidirectionalIterator iterator) {
        return iterator instanceof UnmodifiableBiIterator ? iterator : new UnmodifiableBiIterator(iterator);
    }

    public static CharListIterator unmodifiable(CharListIterator iterator) {
        return iterator instanceof UnmodifiableListIterator ? iterator : new UnmodifiableListIterator(iterator);
    }

    public static <E> ObjectIterator<E> map(Iterator<? extends Character> iterator, CharFunction<E> mapper) {
        return new MappedIterator<E>(CharIterators.wrap(iterator), mapper);
    }

    public static <E> ObjectIterator<E> map(CharIterator iterator, CharFunction<E> mapper) {
        return new MappedIterator<E>(iterator, mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterator<E> flatMap(Iterator<? extends Character> iterator, CharFunction<V> mapper) {
        return new FlatMappedIterator(CharIterators.wrap(iterator), mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterator<E> flatMap(CharIterator iterator, CharFunction<V> mapper) {
        return new FlatMappedIterator(iterator, mapper);
    }

    public static <E> ObjectIterator<E> arrayFlatMap(Iterator<? extends Character> iterator, CharFunction<E[]> mapper) {
        return new FlatMappedArrayIterator(CharIterators.wrap(iterator), mapper);
    }

    public static <E> ObjectIterator<E> arrayFlatMap(CharIterator iterator, CharFunction<E[]> mapper) {
        return new FlatMappedArrayIterator(iterator, mapper);
    }

    public static CharIterator filter(Iterator<? extends Character> iterator, CharPredicate filter) {
        return new FilteredIterator(CharIterators.wrap(iterator), filter);
    }

    public static CharIterator filter(CharIterator iterator, CharPredicate filter) {
        return new FilteredIterator(iterator, filter);
    }

    public static CharIterator distinct(CharIterator iterator) {
        return new DistinctIterator(iterator);
    }

    public static CharIterator distinct(Iterator<? extends Character> iterator) {
        return new DistinctIterator(CharIterators.wrap(iterator));
    }

    public static CharIterator repeat(CharIterator iterator, int repeats) {
        return new RepeatingIterator(iterator, repeats);
    }

    public static CharIterator repeat(Iterator<? extends Character> iterator, int repeats) {
        return new RepeatingIterator(CharIterators.wrap(iterator), repeats);
    }

    public static CharIterator infinite(CharIterator iterator) {
        return new InfiniteIterator(iterator);
    }

    public static CharIterator infinite(Iterator<? extends Character> iterator) {
        return new InfiniteIterator(CharIterators.wrap(iterator));
    }

    public static CharIterator limit(CharIterator iterator, long limit) {
        return new LimitedIterator(iterator, limit);
    }

    public static CharIterator limit(Iterator<? extends Character> iterator, long limit) {
        return new LimitedIterator(CharIterators.wrap(iterator), limit);
    }

    public static CharIterator sorted(CharIterator iterator, CharComparator sorter) {
        return new SortedIterator(iterator, sorter);
    }

    public static CharIterator sorted(Iterator<? extends Character> iterator, CharComparator sorter) {
        return new SortedIterator(CharIterators.wrap(iterator), sorter);
    }

    public static CharIterator peek(CharIterator iterator, CharConsumer action) {
        return new PeekIterator(iterator, action);
    }

    public static CharIterator peek(Iterator<? extends Character> iterator, CharConsumer action) {
        return new PeekIterator(CharIterators.wrap(iterator), action);
    }

    public static CharIterator wrap(Iterator<? extends Character> iterator) {
        return iterator instanceof CharIterator ? (CharIterator)iterator : new IteratorWrapper(iterator);
    }

    public static ArrayIterator wrap(char ... a) {
        return CharIterators.wrap(a, 0, a.length);
    }

    public static ArrayIterator wrap(char[] a, int start, int end) {
        return new ArrayIterator(a, start, end);
    }

    public static int unwrap(char[] a, Iterator<? extends Character> i) {
        return CharIterators.unwrap(a, i, 0, a.length);
    }

    public static int unwrap(char[] a, Iterator<? extends Character> i, int offset) {
        return CharIterators.unwrap(a, i, offset, a.length - offset);
    }

    public static int unwrap(char[] a, Iterator<? extends Character> i, int offset, int max) {
        int index;
        if (max < 0) {
            throw new IllegalStateException("The max size is smaller then 0");
        }
        if (offset + max > a.length) {
            throw new IllegalStateException("largest array index exceeds array size");
        }
        for (index = 0; index < max && i.hasNext(); ++index) {
            a[index + offset] = i.next().charValue();
        }
        return index;
    }

    public static int unwrap(char[] a, CharIterator i) {
        return CharIterators.unwrap(a, i, 0, a.length);
    }

    public static int unwrap(char[] a, CharIterator i, int offset) {
        return CharIterators.unwrap(a, i, offset, a.length - offset);
    }

    public static int unwrap(char[] a, CharIterator i, int offset, int max) {
        int index;
        if (max < 0) {
            throw new IllegalStateException("The max size is smaller then 0");
        }
        if (offset + max > a.length) {
            throw new IllegalStateException("largest array index exceeds array size");
        }
        for (index = 0; index < max && i.hasNext(); ++index) {
            a[index + offset] = i.nextChar();
        }
        return index;
    }

    public static int unwrap(Character[] a, CharIterator i) {
        return CharIterators.unwrap(a, i, 0, a.length);
    }

    public static int unwrap(Character[] a, CharIterator i, int offset) {
        return CharIterators.unwrap(a, i, offset, a.length - offset);
    }

    public static int unwrap(Character[] a, CharIterator i, int offset, int max) {
        int index;
        if (max < 0) {
            throw new IllegalStateException("The max size is smaller then 0");
        }
        if (offset + max > a.length) {
            throw new IllegalStateException("largest array index exceeds array size");
        }
        for (index = 0; index < max && i.hasNext(); ++index) {
            a[index + offset] = Character.valueOf(i.nextChar());
        }
        return index;
    }

    public static int pour(CharIterator iter, CharCollection c) {
        return CharIterators.pour(iter, c, Integer.MAX_VALUE);
    }

    public static int pour(CharIterator iter, CharCollection c, int max) {
        int done;
        if (max < 0) {
            throw new IllegalStateException("Max is negative");
        }
        for (done = 0; done < max && iter.hasNext(); ++done) {
            c.add(iter.nextChar());
        }
        return done;
    }

    public static CharIterator concat(CharIterator ... array) {
        return CharIterators.concat(array, 0, array.length);
    }

    public static CharIterator concat(CharIterator[] array, int offset, int length) {
        return new ConcatIterator(array, offset, length);
    }

    private static class PeekIterator
    implements CharIterator {
        CharIterator iterator;
        CharConsumer action;

        public PeekIterator(CharIterator iterator, CharConsumer action) {
            this.iterator = iterator;
            this.action = action;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char result = this.iterator.nextChar();
            this.action.accept(result);
            return result;
        }
    }

    private static class LimitedIterator
    implements CharIterator {
        CharIterator iterator;
        long limit;

        public LimitedIterator(CharIterator iterator, long limit) {
            this.iterator = iterator;
            this.limit = limit;
        }

        @Override
        public boolean hasNext() {
            return this.limit > 0L && this.iterator.hasNext();
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.limit;
            return this.iterator.nextChar();
        }
    }

    private static class FilteredIterator
    implements CharIterator {
        CharIterator iterator;
        CharPredicate filter;
        char lastFound;
        boolean foundNext = false;

        public FilteredIterator(CharIterator iterator, CharPredicate filter) {
            this.iterator = iterator;
            this.filter = filter;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            while (this.iterator.hasNext()) {
                this.lastFound = this.iterator.nextChar();
                if (!this.filter.test(this.lastFound)) continue;
                this.foundNext = true;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.foundNext;
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.foundNext = false;
            return this.lastFound;
        }
    }

    private static class DistinctIterator
    implements CharIterator {
        CharIterator iterator;
        CharCollection filtered = CharCollections.distinctWrapper();
        char lastFound;
        boolean foundNext = false;

        public DistinctIterator(CharIterator iterator) {
            this.iterator = iterator;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            while (this.iterator.hasNext()) {
                this.lastFound = this.iterator.nextChar();
                if (!this.filtered.add(this.lastFound)) continue;
                this.foundNext = true;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.foundNext;
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.foundNext = false;
            return this.lastFound;
        }
    }

    private static class SortedIterator
    implements CharIterator {
        CharIterator iterator;
        CharComparator sorter;
        CharCollections.CollectionWrapper sortedElements = null;
        int index = 0;

        public SortedIterator(CharIterator iterator, CharComparator sorter) {
            this.iterator = iterator;
            this.sorter = sorter;
        }

        @Override
        public boolean hasNext() {
            if (this.sortedElements == null) {
                boolean hasNext = this.iterator.hasNext();
                if (hasNext) {
                    this.sortedElements = CharCollections.wrapper();
                    CharIterators.pour(this.iterator, this.sortedElements);
                } else {
                    this.sortedElements = CharCollections.wrapper();
                }
                if (hasNext) {
                    this.sortedElements.unstableSort(this.sorter);
                }
            }
            return this.index < this.sortedElements.size();
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.sortedElements.getChar(this.index++);
        }
    }

    private static class RepeatingIterator
    implements CharIterator {
        final int repeats;
        int index = 0;
        CharIterator iter;
        CharCollection repeater = CharCollections.wrapper();

        public RepeatingIterator(CharIterator iter, int repeat) {
            this.iter = iter;
            this.repeats = repeat;
        }

        @Override
        public boolean hasNext() {
            if (this.iter.hasNext()) {
                return true;
            }
            if (this.index < this.repeats) {
                ++this.index;
                this.iter = this.repeater.iterator();
                return this.iter.hasNext();
            }
            return false;
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char value = this.iter.nextChar();
            if (this.index == 0) {
                this.repeater.add(value);
            }
            return value;
        }
    }

    private static class InfiniteIterator
    implements CharIterator {
        CharIterator iter;
        CharCollections.CollectionWrapper looper = CharCollections.wrapper();
        int index = 0;

        public InfiniteIterator(CharIterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public char nextChar() {
            if (this.iter != null) {
                if (this.iter.hasNext()) {
                    char value = this.iter.nextChar();
                    this.looper.add(value);
                    return value;
                }
                this.iter = null;
            }
            return this.looper.getChar(this.index++ % this.looper.size());
        }

        @Override
        public void forEachRemaining(CharConsumer action) {
            throw new UnsupportedOperationException("This is a instant deadlock, so unsupported");
        }

        @Override
        public void forEachRemaining(Consumer<? super Character> action) {
            throw new UnsupportedOperationException("This is a instant deadlock, so unsupported");
        }

        @Override
        public <E> void forEachRemaining(E input, ObjectCharConsumer<E> action) {
            throw new UnsupportedOperationException("This is a instant deadlock, so unsupported");
        }
    }

    private static class FlatMappedArrayIterator<T>
    implements ObjectIterator<T> {
        CharIterator iterator;
        Iterator<T> last = null;
        CharFunction<T[]> mapper;
        boolean foundNext = false;

        FlatMappedArrayIterator(CharIterator iterator, CharFunction<T[]> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            this.foundNext = true;
            while (this.iterator.hasNext()) {
                if (this.last != null && this.last.hasNext()) {
                    return;
                }
                this.last = ObjectIterators.wrap(this.mapper.apply(this.iterator.nextChar()));
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.last != null && this.last.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.last.next();
            this.foundNext = false;
            return result;
        }
    }

    private static class FlatMappedIterator<T, V extends Iterable<T>>
    implements ObjectIterator<T> {
        CharIterator iterator;
        Iterator<T> last = null;
        CharFunction<V> mapper;
        boolean foundNext = false;

        FlatMappedIterator(CharIterator iterator, CharFunction<V> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            this.foundNext = true;
            while (this.iterator.hasNext()) {
                if (this.last != null && this.last.hasNext()) {
                    return;
                }
                this.last = ((Iterable)this.mapper.apply(this.iterator.nextChar())).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.last != null && this.last.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.last.next();
            this.foundNext = false;
            return result;
        }
    }

    private static class MappedIterator<T>
    implements ObjectIterator<T> {
        CharIterator iterator;
        CharFunction<T> mapper;

        MappedIterator(CharIterator iterator, CharFunction<T> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.mapper.apply(this.iterator.nextChar());
        }

        @Override
        public int skip(int amount) {
            return this.iterator.skip(amount);
        }
    }

    private static class ArrayIterator
    implements CharIterator {
        char[] a;
        int from;
        int to;

        ArrayIterator(char[] a, int from, int to) {
            this.a = a;
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean hasNext() {
            return this.from < this.to;
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.a[this.from++];
        }

        @Override
        public int skip(int amount) {
            if (amount < 0) {
                throw new IllegalStateException("Negative Numbers are not allowed");
            }
            int left = Math.min(amount, this.to - this.from);
            this.from += left;
            return amount - left;
        }
    }

    private static class EmptyIterator
    implements CharListIterator {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public char nextChar() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public char previousChar() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(char e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(char e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableIterator
    implements CharIterator {
        CharIterator iterator;

        UnmodifiableIterator(CharIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public char nextChar() {
            return this.iterator.nextChar();
        }
    }

    private static class UnmodifiableBiIterator
    implements CharBidirectionalIterator {
        CharBidirectionalIterator iter;

        UnmodifiableBiIterator(CharBidirectionalIterator iter) {
            this.iter = iter;
        }

        @Override
        public char nextChar() {
            return this.iter.nextChar();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public char previousChar() {
            return this.iter.previousChar();
        }
    }

    private static class UnmodifiableListIterator
    implements CharListIterator {
        CharListIterator iter;

        UnmodifiableListIterator(CharListIterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public char previousChar() {
            return this.iter.previousChar();
        }

        @Override
        public char nextChar() {
            return this.iter.nextChar();
        }

        @Override
        public void set(char e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(char e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReverseListIterator
    implements CharListIterator {
        CharListIterator it;

        ReverseListIterator(CharListIterator it) {
            this.it = it;
        }

        @Override
        public char nextChar() {
            return this.it.previousChar();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public char previousChar() {
            return this.it.nextChar();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public int nextIndex() {
            return this.it.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.nextIndex();
        }

        @Override
        public void set(char e) {
            this.it.set(e);
        }

        @Override
        public void add(char e) {
            this.it.add(e);
        }
    }

    private static class ReverseBiIterator
    implements CharBidirectionalIterator {
        CharBidirectionalIterator it;

        ReverseBiIterator(CharBidirectionalIterator it) {
            this.it = it;
        }

        @Override
        public char nextChar() {
            return this.it.previousChar();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public char previousChar() {
            return this.it.nextChar();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    private static class ConcatIterator
    implements CharIterator {
        CharIterator[] iters;
        int offset;
        int lastOffset = -1;
        int length;

        public ConcatIterator(CharIterator[] iters, int offset, int length) {
            this.iters = iters;
            this.offset = offset;
            this.length = length;
            this.find();
        }

        private void find() {
            while (this.length != 0 && !this.iters[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        @Override
        public boolean hasNext() {
            return this.length > 0;
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            char result = this.iters[this.lastOffset].nextChar();
            this.find();
            return result;
        }

        @Override
        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.iters[this.lastOffset].remove();
            this.lastOffset = -1;
        }
    }

    private static class IteratorWrapper
    implements CharIterator {
        Iterator<? extends Character> iter;

        public IteratorWrapper(Iterator<? extends Character> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public char nextChar() {
            return this.iter.next().charValue();
        }

        @Override
        @Deprecated
        public Character next() {
            return this.iter.next();
        }
    }
}

