/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.maps.abstracts;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import speiger.src.collections.chars.collections.CharIterator;
import speiger.src.collections.chars.functions.consumer.CharObjectConsumer;
import speiger.src.collections.chars.functions.function.CharFunction;
import speiger.src.collections.chars.functions.function.CharObjectUnaryOperator;
import speiger.src.collections.chars.maps.interfaces.Char2ObjectMap;
import speiger.src.collections.chars.sets.AbstractCharSet;
import speiger.src.collections.chars.sets.CharSet;
import speiger.src.collections.objects.collections.AbstractObjectCollection;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.ObjectSupplier;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.sets.ObjectSet;
import speiger.src.collections.utils.SanityChecks;

public abstract class AbstractChar2ObjectMap<V>
extends AbstractMap<Character, V>
implements Char2ObjectMap<V> {
    protected V defaultReturnValue = null;

    @Override
    public V getDefaultReturnValue() {
        return this.defaultReturnValue;
    }

    @Override
    public AbstractChar2ObjectMap<V> setDefaultReturnValue(V v) {
        this.defaultReturnValue = v;
        return this;
    }

    protected ObjectIterable<Char2ObjectMap.Entry<V>> getFastIterable(Char2ObjectMap<V> map) {
        return map.char2ObjectEntrySet();
    }

    protected ObjectIterator<Char2ObjectMap.Entry<V>> getFastIterator(Char2ObjectMap<V> map) {
        return map.char2ObjectEntrySet().iterator();
    }

    @Override
    public Char2ObjectMap<V> copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public V put(Character key, V value) {
        return ((AbstractMap)this).put(key.charValue(), value);
    }

    @Override
    public void putAll(Char2ObjectMap<V> m) {
        ObjectIterator<Char2ObjectMap.Entry<V>> iter = this.getFastIterator(m);
        while (iter.hasNext()) {
            Char2ObjectMap.Entry entry = (Char2ObjectMap.Entry)iter.next();
            ((AbstractMap)this).put(entry.getCharKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(Map<? extends Character, ? extends V> m) {
        if (m instanceof Char2ObjectMap) {
            this.putAll((Char2ObjectMap)m);
        } else {
            super.putAll(m);
        }
    }

    @Override
    public void putAll(char[] keys, V[] values, int offset, int size) {
        SanityChecks.checkArrayCapacity(keys.length, offset, size);
        SanityChecks.checkArrayCapacity(values.length, offset, size);
        for (int i = 0; i < size; ++i) {
            ((AbstractMap)this).put(keys[i], values[i]);
        }
    }

    @Override
    public void putAll(Character[] keys, V[] values, int offset, int size) {
        SanityChecks.checkArrayCapacity(keys.length, offset, size);
        SanityChecks.checkArrayCapacity(values.length, offset, size);
        for (int i = 0; i < size; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    @Override
    public void putAllIfAbsent(Char2ObjectMap<V> m) {
        for (Char2ObjectMap.Entry entry : this.getFastIterable(m)) {
            this.putIfAbsent(entry.getCharKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(char key) {
        CharIterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            if (iter.nextChar() != key) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator iter = this.values().iterator();
        while (iter.hasNext()) {
            if (!Objects.equals(value, iter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(char key, V oldValue, V newValue) {
        Object curValue = this.get(key);
        if (!Objects.equals(curValue, oldValue) || Objects.equals(curValue, this.getDefaultReturnValue()) && !this.containsKey(key)) {
            return false;
        }
        ((AbstractMap)this).put(key, newValue);
        return true;
    }

    @Override
    public V replace(char key, V value) {
        Object curValue = this.get(key);
        if (!Objects.equals(curValue, this.getDefaultReturnValue()) || this.containsKey(key)) {
            curValue = ((AbstractMap)this).put(key, value);
        }
        return curValue;
    }

    @Override
    public void replaceObjects(Char2ObjectMap<V> m) {
        for (Char2ObjectMap.Entry entry : this.getFastIterable(m)) {
            this.replace(entry.getCharKey(), (V)entry.getValue());
        }
    }

    @Override
    public void replaceObjects(CharObjectUnaryOperator<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        ObjectIterator<Char2ObjectMap.Entry<V>> iter = this.getFastIterator(this);
        while (iter.hasNext()) {
            Char2ObjectMap.Entry entry = (Char2ObjectMap.Entry)iter.next();
            entry.setValue(mappingFunction.apply(entry.getCharKey(), entry.getValue()));
        }
    }

    @Override
    public V compute(char key, CharObjectUnaryOperator<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Object value = this.get(key);
        V newValue = mappingFunction.apply(key, value);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            if (!Objects.equals(value, this.getDefaultReturnValue()) || this.containsKey(key)) {
                this.remove(key);
                return this.getDefaultReturnValue();
            }
            return this.getDefaultReturnValue();
        }
        ((AbstractMap)this).put(key, newValue);
        return newValue;
    }

    @Override
    public V computeIfAbsent(char key, CharFunction<V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Object value = this.get(key);
        if (!(value != this.getDefaultReturnValue() && this.containsKey(key) || Objects.equals(newValue = mappingFunction.apply(key), this.getDefaultReturnValue()))) {
            ((AbstractMap)this).put(key, newValue);
            return newValue;
        }
        return value;
    }

    @Override
    public V supplyIfAbsent(char key, ObjectSupplier<V> valueProvider) {
        V newValue;
        Objects.requireNonNull(valueProvider);
        Object value = this.get(key);
        if (!(value != this.getDefaultReturnValue() && this.containsKey(key) || Objects.equals(newValue = valueProvider.get(), this.getDefaultReturnValue()))) {
            ((AbstractMap)this).put(key, newValue);
            return newValue;
        }
        return value;
    }

    @Override
    public V computeIfPresent(char key, CharObjectUnaryOperator<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Object value = this.get(key);
        if (!Objects.equals(value, this.getDefaultReturnValue()) || this.containsKey(key)) {
            V newValue = mappingFunction.apply(key, value);
            if (!Objects.equals(newValue, this.getDefaultReturnValue())) {
                ((AbstractMap)this).put(key, newValue);
                return newValue;
            }
            this.remove(key);
        }
        return this.getDefaultReturnValue();
    }

    @Override
    public V merge(char key, V value, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Object oldValue = this.get(key);
        Object object = newValue = Objects.equals(oldValue, this.getDefaultReturnValue()) ? value : mappingFunction.apply(oldValue, value);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            this.remove(key);
        } else {
            ((AbstractMap)this).put(key, newValue);
        }
        return newValue;
    }

    @Override
    public void mergeAll(Char2ObjectMap<V> m, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        for (Char2ObjectMap.Entry entry : this.getFastIterable(m)) {
            Object newValue;
            char key = entry.getCharKey();
            Object oldValue = this.get(key);
            Object object = newValue = Objects.equals(oldValue, this.getDefaultReturnValue()) ? entry.getValue() : mappingFunction.apply(oldValue, entry.getValue());
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                this.remove(key);
                continue;
            }
            ((AbstractMap)this).put(key, newValue);
        }
    }

    @Override
    public V get(Object key) {
        return key instanceof Character ? this.get(((Character)key).charValue()) : this.getDefaultReturnValue();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return key instanceof Character ? this.getOrDefault(((Character)key).charValue(), defaultValue) : this.getDefaultReturnValue();
    }

    @Override
    public V getOrDefault(char key, V defaultValue) {
        Object value = this.get(key);
        return !Objects.equals(value, this.getDefaultReturnValue()) || this.containsKey(key) ? value : defaultValue;
    }

    @Override
    public V remove(Object key) {
        return key instanceof Character ? this.remove(((Character)key).charValue()) : this.getDefaultReturnValue();
    }

    @Override
    public void forEach(CharObjectConsumer<V> action) {
        Objects.requireNonNull(action);
        ObjectIterator<Char2ObjectMap.Entry<V>> iter = this.getFastIterator(this);
        while (iter.hasNext()) {
            Char2ObjectMap.Entry entry = (Char2ObjectMap.Entry)iter.next();
            action.accept(entry.getCharKey(), entry.getValue());
        }
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            @Override
            public boolean remove(char o) {
                return !Objects.equals(AbstractChar2ObjectMap.this.remove(o), AbstractChar2ObjectMap.this.getDefaultReturnValue());
            }

            @Override
            public boolean add(char o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    ObjectIterator<Char2ObjectMap.Entry<V>> iter;
                    {
                        this.iter = AbstractChar2ObjectMap.this.getFastIterator(AbstractChar2ObjectMap.this);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public char nextChar() {
                        return ((Char2ObjectMap.Entry)this.iter.next()).getCharKey();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractChar2ObjectMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2ObjectMap.this.clear();
            }
        };
    }

    @Override
    public ObjectCollection<V> values() {
        return new AbstractObjectCollection<V>(){

            @Override
            public boolean add(V o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return AbstractChar2ObjectMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2ObjectMap.this.clear();
            }

            @Override
            public ObjectIterator<V> iterator() {
                return new ObjectIterator<V>(){
                    ObjectIterator<Char2ObjectMap.Entry<V>> iter;
                    {
                        this.iter = AbstractChar2ObjectMap.this.getFastIterator(AbstractChar2ObjectMap.this);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((Char2ObjectMap.Entry)this.iter.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }
        };
    }

    @Override
    public ObjectSet<Map.Entry<Character, V>> entrySet() {
        return this.char2ObjectEntrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Map) {
            if (this.size() != ((Map)o).size()) {
                return false;
            }
            if (o instanceof Char2ObjectMap) {
                return this.char2ObjectEntrySet().containsAll(((Char2ObjectMap)o).char2ObjectEntrySet());
            }
            return this.char2ObjectEntrySet().containsAll(((Map)o).entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        ObjectIterator<Char2ObjectMap.Entry<V>> iter = this.getFastIterator(this);
        while (iter.hasNext()) {
            hash += ((Char2ObjectMap.Entry)iter.next()).hashCode();
        }
        return hash;
    }

    public static class BasicEntry<V>
    implements Char2ObjectMap.Entry<V> {
        protected char key;
        protected V value;

        public BasicEntry() {
        }

        public BasicEntry(Character key, V value) {
            this.key = key.charValue();
            this.value = value;
        }

        public BasicEntry(char key, V value) {
            this.key = key;
            this.value = value;
        }

        public void set(char key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char getCharKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                if (obj instanceof Char2ObjectMap.Entry) {
                    Char2ObjectMap.Entry entry = (Char2ObjectMap.Entry)obj;
                    return this.key == entry.getCharKey() && Objects.equals(this.value, entry.getValue());
                }
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                return key instanceof Character && this.key == ((Character)key).charValue() && Objects.equals(this.value, value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Character.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return Character.toString(this.key) + "=" + Objects.toString(this.value);
        }
    }
}

