/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.collections;

import java.util.Collection;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import speiger.src.collections.chars.collections.CharIterable;
import speiger.src.collections.chars.collections.CharIterator;
import speiger.src.collections.chars.collections.CharSplititerator;
import speiger.src.collections.chars.functions.CharConsumer;
import speiger.src.collections.chars.utils.CharCollections;
import speiger.src.collections.chars.utils.CharSplititerators;
import speiger.src.collections.utils.ISizeProvider;
import speiger.src.collections.utils.SanityChecks;

public interface CharCollection
extends Collection<Character>,
CharIterable,
ISizeProvider {
    @Override
    public boolean add(char var1);

    public boolean addAll(CharCollection var1);

    default public boolean addAll(char ... e) {
        return this.addAll(e, 0, e.length);
    }

    default public boolean addAll(char[] e, int length) {
        return this.addAll(e, 0, length);
    }

    default public boolean addAll(char[] e, int offset, int length) {
        if (length <= 0) {
            return false;
        }
        SanityChecks.checkArrayCapacity(e.length, offset, length);
        boolean added = false;
        for (int i = 0; i < length; ++i) {
            if (!this.add(e[offset + i])) continue;
            added = true;
        }
        return added;
    }

    public boolean contains(char var1);

    public boolean containsAll(CharCollection var1);

    public boolean containsAny(CharCollection var1);

    @Deprecated
    public boolean containsAny(Collection<?> var1);

    public boolean remChar(char var1);

    public boolean removeAll(CharCollection var1);

    public boolean removeAll(CharCollection var1, CharConsumer var2);

    public boolean retainAll(CharCollection var1);

    public boolean retainAll(CharCollection var1, CharConsumer var2);

    @Override
    default public <E extends CharCollection> E pour(E collection) {
        collection.addAll(this);
        return collection;
    }

    public CharCollection copy();

    @Override
    public char[] toCharArray();

    public char[] toCharArray(char[] var1);

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Character> filter) {
        Objects.requireNonNull(filter);
        return this.remIf(v -> filter.test(Character.valueOf(SanityChecks.castToChar(v))));
    }

    default public boolean remIf(IntPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        CharIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextChar())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    default public boolean add(Character o) {
        return this.add(o.charValue());
    }

    @Override
    @Deprecated
    default public boolean contains(Object o) {
        return o != null && this.contains(((Character)o).charValue());
    }

    @Override
    @Deprecated
    default public boolean remove(Object o) {
        return o != null && this.remChar(((Character)o).charValue());
    }

    @Override
    public CharIterator iterator();

    default public CharCollection synchronize() {
        return CharCollections.synchronize(this);
    }

    default public CharCollection synchronize(Object mutex) {
        return CharCollections.synchronize(this, mutex);
    }

    default public CharCollection unmodifiable() {
        return CharCollections.unmodifiable(this);
    }

    default public IntStream primitiveStream() {
        return StreamSupport.intStream(CharSplititerators.createJavaSplititerator(this, 0), false);
    }

    default public IntStream parallelPrimitiveStream() {
        return StreamSupport.intStream(CharSplititerators.createJavaSplititerator(this, 0), true);
    }

    @Override
    default public CharSplititerator spliterator() {
        return CharSplititerators.createSplititerator(this, 0);
    }
}

