/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.snyc;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.buffer.ReadBuffer;
import carbonconfiglib.networking.buffer.WriteBuffer;
import carbonconfiglib.utils.SyncType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class SyncPacket
implements ICarbonPacket {
    String identifier;
    SyncType type;
    Map<String, byte[]> entries = new Object2ObjectLinkedOpenHashMap();

    public SyncPacket() {
    }

    public SyncPacket(String identifier, SyncType type, Map<String, byte[]> entries) {
        this.identifier = identifier;
        this.type = type;
        this.entries = entries;
    }

    public static SyncPacket create(ConfigHandler handler, SyncType type, boolean forceSync) {
        if (!handler.isLoaded()) {
            return null;
        }
        Object2ObjectLinkedOpenHashMap data = new Object2ObjectLinkedOpenHashMap();
        ByteBuf buf = Unpooled.buffer();
        WriteBuffer buffer = new WriteBuffer(new PacketBuffer(buf));
        for (Map.Entry<String, ConfigEntry<?>> entry : handler.getConfig().getSyncedEntries(type).entrySet()) {
            ConfigEntry<?> value = entry.getValue();
            if (!forceSync && !value.hasChanged()) continue;
            buf.clear();
            value.serialize(buffer);
            byte[] configData = new byte[buf.writerIndex()];
            buf.readBytes(configData);
            data.put(entry.getKey(), configData);
            value.onSynced();
        }
        return data.isEmpty() ? null : new SyncPacket(handler.getConfigIdentifer(), type, (Map<String, byte[]>)data);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_180714_a(this.identifier);
        buffer.func_179249_a((Enum)this.type);
        buffer.func_150787_b(this.entries.size());
        for (Map.Entry<String, byte[]> entry : this.entries.entrySet()) {
            buffer.func_180714_a(entry.getKey());
            buffer.func_179250_a(entry.getValue());
        }
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.identifier = buffer.func_150789_c(Short.MAX_VALUE);
        this.type = (SyncType)buffer.func_179257_a(SyncType.class);
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            this.entries.put(buffer.func_150789_c(Short.MAX_VALUE), buffer.func_179251_a());
        }
    }

    @Override
    public void process(EntityPlayer player) {
        ReloadMode mode = this.processEntry(player);
        if (mode != null) {
            player.func_145747_a(mode.getName());
        }
    }

    public ReloadMode processEntry(EntityPlayer player) {
        if (this.entries.isEmpty()) {
            return null;
        }
        ConfigHandler cfg = CarbonConfig.CONFIGS.getConfig(this.identifier);
        if (cfg == null) {
            CarbonConfig.LOGGER.warn("Received packet for [" + this.identifier + "] which didn't exist!");
            return null;
        }
        Map<String, ConfigEntry<?>> mapped = cfg.getConfig().getSyncedEntries(this.type);
        boolean hasChanged = false;
        UUID owner = player.func_110124_au();
        ReloadMode mode = null;
        for (Map.Entry<String, byte[]> dataEntry : this.entries.entrySet()) {
            ConfigEntry<?> entry = mapped.get(dataEntry.getKey());
            if (entry == null) continue;
            entry.deserialize(new ReadBuffer(new PacketBuffer(Unpooled.wrappedBuffer((byte[])dataEntry.getValue()))), owner);
            if (entry.hasChanged()) {
                hasChanged = true;
                mode = ReloadMode.or(mode, entry.getReloadState());
            }
            entry.onSynced();
        }
        if (hasChanged) {
            cfg.onSynced();
            cfg.saveQuietly();
            return mode;
        }
        return null;
    }
}

