/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.minecraft;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.networking.ICarbonPacket;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.GameRules;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SaveGameRulesPacket
implements ICarbonPacket {
    GameRules rules;

    public SaveGameRulesPacket() {
    }

    public SaveGameRulesPacket(GameRules rules) {
        this.rules = rules;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150786_a(this.rules.func_82770_a());
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.rules = new GameRules();
        try {
            this.rules.func_82768_a(buffer.func_150793_b());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void process(EntityPlayer player) {
        if (!this.canIgnorePermissionCheck() && !this.hasPermissions(player, 4)) {
            CarbonConfig.LOGGER.warn("Don't have Permission to Change configs");
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        GameRules rule = server.func_71218_a(0).func_82736_K();
        rule.func_82768_a(this.rules.func_82770_a());
    }

    private boolean hasPermissions(EntityPlayer player, int value) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return server.func_184103_al().func_152603_m().func_187452_a(player.func_146103_bH()) >= value;
    }

    private boolean canIgnorePermissionCheck() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return !server.func_71262_S() && server instanceof IntegratedServer && ((IntegratedServer)server).func_71344_c();
    }
}

