/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.minecraft;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class RequestGameRulesPacket
implements ICarbonPacket {
    UUID requestId;

    public RequestGameRulesPacket() {
    }

    public RequestGameRulesPacket(UUID requestId) {
        this.requestId = requestId;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179252_a(this.requestId);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.requestId = buffer.func_179253_g();
    }

    @Override
    public void process(EntityPlayer player) {
        if (!this.canIgnorePermissionCheck() && !this.hasPermissions(player, 4)) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_150786_a(server.func_71218_a(0).func_82736_K().func_82770_a());
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        CarbonConfig.NETWORK.sendToPlayer(new ConfigAnswerPacket(this.requestId, data), player);
    }

    private boolean hasPermissions(EntityPlayer player, int value) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return server.func_184103_al().func_152603_m().func_187452_a(player.func_146103_bH()) >= value;
    }

    private boolean canIgnorePermissionCheck() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return !server.func_71262_S() && server instanceof IntegratedServer && ((IntegratedServer)server).func_71344_c();
    }
}

