/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.carbon;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.networking.ICarbonPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SaveConfigPacket
implements ICarbonPacket {
    String identifier;
    String data;

    public SaveConfigPacket() {
    }

    public SaveConfigPacket(String identifier, String data) {
        this.identifier = identifier;
        this.data = data;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_180714_a(this.identifier);
        buffer.func_180714_a(this.data);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.identifier = buffer.func_150789_c(Short.MAX_VALUE);
        this.data = buffer.func_150789_c(262144);
    }

    @Override
    public void process(EntityPlayer player) {
        if (!this.canIgnorePermissionCheck() && !this.hasPermissions(player, 4)) {
            CarbonConfig.LOGGER.warn("Don't have Permission to Change configs");
            return;
        }
        ConfigHandler handler = CarbonConfig.CONFIGS.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        try {
            ConfigHandler.load(handler, handler.getConfig(), (List<String>)ObjectArrayList.wrap((Object[])this.data.split("\n")), false);
            handler.save();
            CarbonConfig.LOGGER.info("Saved [" + this.identifier + "] Config");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean hasPermissions(EntityPlayer player, int value) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return server.func_184103_al().func_152603_m().func_187452_a(player.func_146103_bH()) >= value;
    }

    private boolean canIgnorePermissionCheck() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return !server.func_71262_S() && server instanceof IntegratedServer && ((IntegratedServer)server).func_71344_c();
    }
}

