/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.impl.internal;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.IConfigChangeListener;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.ISuggestionRenderer;
import carbonconfiglib.gui.config.ColorElement;
import carbonconfiglib.gui.config.RegistryElement;
import carbonconfiglib.gui.impl.forge.ForgeConfigs;
import carbonconfiglib.gui.impl.minecraft.MinecraftConfigs;
import carbonconfiglib.gui.screen.ConfigScreenFactory;
import carbonconfiglib.gui.widgets.SuggestionRenderers;
import carbonconfiglib.gui.widgets.screen.CarbonScreen;
import carbonconfiglib.impl.PerWorldProxy;
import carbonconfiglib.impl.entries.ColorValue;
import carbonconfiglib.impl.internal.ModConfigList;
import carbonconfiglib.impl.internal.ModConfigs;
import carbonconfiglib.networking.carbon.StateSyncPacket;
import carbonconfiglib.networking.snyc.BulkSyncPacket;
import carbonconfiglib.networking.snyc.SyncPacket;
import carbonconfiglib.utils.SyncType;
import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IFMLSidedHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectLinkedOpenHashMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;

public class EventHandler
implements IConfigChangeListener {
    public static final EventHandler INSTANCE = new EventHandler();
    boolean loaded = false;
    boolean allowFailed = true;
    Map<ModContainer, ModConfigs> configs = new Object2ObjectLinkedOpenHashMap().synchronize();
    Map<String, Configuration> foundFiles = new Object2ObjectLinkedOpenHashMap().synchronize();
    Object2ObjectMap<ModContainer, List<Configuration>> forgeConfigs = new Object2ObjectLinkedOpenHashMap().synchronize();

    public static void registerConfig(Configuration config) {
        if (config == null || config.getConfigFile() == null) {
            return;
        }
        IFMLSidedHandler side = FMLCommonHandler.instance().getSidedDelegate();
        if (side == null) {
            EventHandler.applyFailed(config);
            return;
        }
        if (side.getSide() == Side.SERVER) {
            return;
        }
        ModContainer container = Loader.instance().activeModContainer();
        if (container == null) {
            EventHandler.applyFailed(config);
            return;
        }
        EventHandler.INSTANCE.forgeConfigs.supplyIfAbsent(container, ObjectArrayList::new).add(config);
    }

    private static void applyFailed(Configuration config) {
        if (!EventHandler.INSTANCE.allowFailed || config == null || config.getConfigFile() == null) {
            return;
        }
        EventHandler.INSTANCE.foundFiles.put(config.getConfigFile().getAbsolutePath(), config);
    }

    public static void onPlayerClientJoin() {
        INSTANCE.onPlayerClientJoinEvent();
    }

    @SideOnly(value=Side.CLIENT)
    public static void onPlayerClientLeave(IntegratedServer server) {
        INSTANCE.onPlayerClientLeaveEvent(server);
    }

    @Override
    public void onConfigCreated(ConfigHandler config) {
        this.initMinecraftDataTypes(config);
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return;
        }
        ModContainer container = Loader.instance().activeModContainer();
        if (container == null) {
            throw new IllegalStateException("Mod Configs Must be created (not loaded) during a Mod Loading Phase");
        }
        this.configs.computeIfAbsent(container, ModConfigs::new).addConfig(config);
    }

    public void initMinecraftDataTypes(ConfigHandler config) {
        config.addParser('C', ColorValue::parse);
        config.addTempParser('R');
        config.addTempParser('K');
    }

    @Override
    public void onConfigAdded(ConfigHandler config) {
    }

    @Override
    public void onConfigChanged(ConfigHandler config) {
        SyncPacket packet;
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            SyncPacket packet2 = SyncPacket.create(config, SyncType.SERVER_TO_CLIENT, false);
            if (packet2 != null) {
                CarbonConfig.NETWORK.sendToAllPlayers(packet2);
            }
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (packet = SyncPacket.create(config, SyncType.SERVER_TO_CLIENT, false)) != null) {
            CarbonConfig.NETWORK.sendToAllPlayers(packet);
        }
        if (CarbonConfig.NETWORK.isInWorld() && (packet = SyncPacket.create(config, SyncType.CLIENT_TO_SERVER, false)) != null) {
            CarbonConfig.NETWORK.sendToServer(packet);
        }
    }

    @Override
    public void onConfigErrored(ConfigHandler configHandler) {
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processEvents();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processEvents();
        } else {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof CarbonScreen) {
                ((CarbonScreen)screen).tick();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenedEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiModList) {
            this.registerConfigs();
        }
    }

    public void processIMCEvents(Map<String, ModContainer> config, Map<ModContainer, ModContainer> remapping) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            this.foundFiles.clear();
            return;
        }
        this.foundFiles.forEach((F, C) -> {
            ModContainer container = (ModContainer)config.get(F);
            if (container == null) {
                return;
            }
            this.forgeConfigs.supplyIfAbsent(container, ObjectArrayList::new).add(C);
        });
        this.foundFiles.clear();
        for (Map.Entry<ModContainer, ModContainer> entry : remapping.entrySet()) {
            List<Configuration> configs = this.forgeConfigs.remove(entry.getKey());
            if (configs == null || configs.isEmpty()) continue;
            this.forgeConfigs.supplyIfAbsent(entry.getValue(), ObjectArrayList::new).addAll(configs);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerConfigs() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        BiMap factory = (BiMap)ObfuscationReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)FMLClientHandler.instance(), (String[])new String[]{"guiFactories"});
        Object2ObjectLinkedOpenHashMap<ModContainer, List> mappedConfigs = new Object2ObjectLinkedOpenHashMap<ModContainer, List>();
        this.configs.forEach((M, C) -> {
            if (factory.containsKey(M)) {
                return;
            }
            mappedConfigs.supplyIfAbsent((ModContainer)M, ObjectArrayList::new).add(C);
        });
        if (CarbonConfig.FORGE_SUPPORT.get()) {
            this.forgeConfigs.forEach((M, C) -> {
                if (factory.containsKey(M) && !CarbonConfig.FORCE_FORGE_SUPPORT.get()) {
                    return;
                }
                mappedConfigs.supplyIfAbsent((ModContainer)M, ObjectArrayList::new).add(new ForgeConfigs((ModContainer)M, (List<Configuration>)C));
            });
        }
        Optional.of(Loader.instance().getMinecraftModContainer()).ifPresent(T -> mappedConfigs.supplyIfAbsent((ModContainer)T, ObjectArrayList::new).add(new MinecraftConfigs()));
        mappedConfigs.forEach((M, C) -> {
            IModGuiFactory cfr_ignored_0 = (IModGuiFactory)factory.put(M, (Object)new ConfigScreenFactory(ModConfigList.createMultiIfApplicable(M, C)));
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void onConfigsLoaded() {
        this.loadDefaultTypes();
    }

    @SideOnly(value=Side.CLIENT)
    private void loadDefaultTypes() {
        ISuggestionRenderer.Registry.register(Item.class, new SuggestionRenderers.ItemEntry());
        ISuggestionRenderer.Registry.register(Block.class, new SuggestionRenderers.ItemEntry());
        ISuggestionRenderer.Registry.register(Fluid.class, new SuggestionRenderers.FluidEntry());
        ISuggestionRenderer.Registry.register(Enchantment.class, new SuggestionRenderers.EnchantmentEntry());
        ISuggestionRenderer.Registry.register(ColorValue.ColorWrapper.class, new SuggestionRenderers.ColorEntry());
        ISuggestionRenderer.Registry.register(Potion.class, new SuggestionRenderers.PotionEntry());
        DataType.registerType(Item.class, RegistryElement.createForType(Item.class, "minecraft:air"));
        DataType.registerType(Block.class, RegistryElement.createForType(Block.class, "minecraft:air"));
        DataType.registerType(Fluid.class, RegistryElement.createForType(Fluid.class, "minecraft:water"));
        DataType.registerType(Enchantment.class, RegistryElement.createForType(Enchantment.class, "minecraft:fortune"));
        DataType.registerType(Potion.class, RegistryElement.createForType(Potion.class, "minecraft:luck"));
        DataType.registerType(ColorValue.ColorWrapper.class, new DataType(false, "0xFFFFFFFF", ColorElement::new, ColorElement::new, ColorElement::new));
    }

    public void onServerJoinPacket(EntityPlayer player) {
        CarbonConfig.NETWORK.sendToPlayer(new StateSyncPacket(Side.SERVER), player);
        CarbonConfig.NETWORK.onPlayerJoined(player, true);
        BulkSyncPacket packet = BulkSyncPacket.create(CarbonConfig.CONFIGS.getConfigsToSync(), SyncType.SERVER_TO_CLIENT, true);
        if (packet == null) {
            return;
        }
        CarbonConfig.NETWORK.sendToPlayer(packet, player);
    }

    @SubscribeEvent
    public void onServerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        CarbonConfig.NETWORK.onPlayerLeft(event.player, true);
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerClientJoinEvent() {
        if (Minecraft.func_71410_x().func_71401_C() == null) {
            this.loadMPConfigs();
        }
        CarbonConfig.NETWORK.sendToServer(new StateSyncPacket(Side.CLIENT));
        BulkSyncPacket packet = BulkSyncPacket.create(CarbonConfig.CONFIGS.getConfigsToSync(), SyncType.CLIENT_TO_SERVER, true);
        if (packet == null) {
            return;
        }
        CarbonConfig.NETWORK.sendToServer(packet);
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerClientLeaveEvent(IntegratedServer server) {
        CarbonConfig.NETWORK.onPlayerLeft(null, false);
        if (server == null) {
            for (ConfigHandler handler : CarbonConfig.CONFIGS.getAllConfigs()) {
                if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
                handler.unload();
            }
        }
    }

    private void loadMPConfigs() {
        for (ConfigHandler handler : CarbonConfig.CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.load();
        }
    }

    private void processEvents() {
        CarbonConfig.CONFIGS.processFileSystemEvents();
    }
}

