/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.impl;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.api.IConfigProxy;
import carbonconfiglib.api.SimpleConfigProxy;
import carbonconfiglib.config.ConfigSettings;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PerWorldProxy
implements IConfigProxy {
    public static final IConfigProxy INSTANCE = new PerWorldProxy(PerWorldProxy.getGameDirectory().resolve("multiplayerconfigs"), PerWorldProxy.getGameDirectory().resolve("defaultconfigs"), PerWorldProxy.getGameDirectory().resolve("saves"));
    Path baseClientPath;
    Path baseServerPath;
    Path saveFolders;

    private PerWorldProxy(Path baseClientPath, Path baseServerPath, Path saveFolders) {
        this.baseClientPath = baseClientPath;
        this.baseServerPath = baseServerPath;
        this.saveFolders = saveFolders;
    }

    private static Path getGameDirectory() {
        return Loader.instance().getConfigDir().toPath().getParent();
    }

    public static boolean isProxy(IConfigProxy proxy) {
        return proxy instanceof PerWorldProxy;
    }

    public static ConfigSettings perWorld() {
        return ConfigSettings.withFolderProxy(INSTANCE).withType(ConfigType.SERVER);
    }

    @Override
    public Path getBasePaths(Path relativeFile) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            Path path = server.func_71254_M().func_186352_b(server.func_71270_I(), "serverconfig").toPath();
            if (Files.exists(path.resolve(relativeFile), new LinkOption[0])) {
                return path;
            }
        } else if (FMLCommonHandler.instance().getSide().isClient() && CarbonConfig.NETWORK.isInWorld()) {
            return this.baseClientPath;
        }
        return this.baseServerPath;
    }

    @Override
    public List<? extends IConfigProxy.IPotentialTarget> getPotentialConfigs() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            return this.getLevels();
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return Collections.singletonList(new SimpleConfigProxy.SimpleTarget(server.func_71254_M().func_186352_b(server.func_71270_I(), "serverconfig").toPath(), "server"));
    }

    @SideOnly(value=Side.CLIENT)
    private List<IConfigProxy.IPotentialTarget> getLevels() {
        ISaveFormat storage = Minecraft.func_71410_x().func_71359_d();
        ObjectArrayList folders = new ObjectArrayList();
        if (Files.exists(this.baseServerPath, new LinkOption[0])) {
            folders.add(new SimpleConfigProxy.SimpleTarget(this.baseServerPath, "Default Config"));
        }
        try {
            for (WorldSummary sum : storage.func_75799_b()) {
                try {
                    Path path = storage.func_186352_b(sum.func_75786_a(), "serverconfig").toPath();
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    folders.add(new WorldTarget(sum, storage.func_186352_b(sum.func_75786_a(), ".").toPath(), path));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folders;
    }

    @Override
    public boolean isDynamicProxy() {
        return true;
    }

    public static class WorldTarget
    implements IConfigProxy.IPotentialTarget {
        WorldSummary summary;
        Path worldFile;
        Path folder;

        public WorldTarget(WorldSummary summary, Path worldFile, Path folder) {
            this.summary = summary;
            this.worldFile = worldFile;
            this.folder = folder;
        }

        @Override
        public Path getFolder() {
            return this.folder;
        }

        @Override
        public String getName() {
            return this.summary.func_75788_b();
        }

        public Path getWorldFile() {
            return this.worldFile;
        }

        public WorldSummary getSummary() {
            return this.summary;
        }
    }
}

