/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.widgets.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.screen.SmoothFloat;
import carbonconfiglib.gui.widgets.screen.IInteractable;
import carbonconfiglib.gui.widgets.screen.IInteractableContainer;
import carbonconfiglib.gui.widgets.screen.IWidget;
import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public class AbstractScrollList<E extends Entry<E>>
implements IInteractableContainer,
IWidget {
    BackgroundTexture.BackgroundHolder texture = BackgroundTexture.DEFAULT.asHolder();
    protected final int itemHeight;
    private final List<E> children = new TrackedList();
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected boolean centerListVertically = true;
    private boolean renderSelection = true;
    protected int headerHeight;
    private boolean scrolling;
    @Nullable
    private E selected;
    private boolean renderBackground = true;
    private boolean renderTopAndBottom = true;
    @Nullable
    private E hovered;
    private IInteractable focused;
    private boolean isDragging;
    private int lastTick = 0;
    SmoothFloat scrollAmount = new SmoothFloat(0.5f);

    public AbstractScrollList(int width, int height, int screenY, int listY, int itemHeight) {
        this.width = width;
        this.height = height;
        this.y0 = screenY;
        this.y1 = listY;
        this.itemHeight = itemHeight;
        this.x0 = 0;
        this.x1 = width;
    }

    @Override
    public void setX(int x) {
    }

    @Override
    public void setY(int y) {
    }

    @Override
    public int getX() {
        return 0;
    }

    @Override
    public int getY() {
        return 0;
    }

    @Override
    public boolean isHovered() {
        return this.hovered != null;
    }

    public void setRenderSelection(boolean render) {
        this.renderSelection = render;
    }

    public void setCustomBackground(BackgroundTexture.BackgroundHolder customBackground) {
        this.texture = customBackground;
    }

    public int getRowWidth() {
        return 220;
    }

    public int getLastTick() {
        return this.lastTick;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(E selected) {
        this.selected = selected;
    }

    public void setRenderBackground(boolean render) {
        this.renderBackground = render;
    }

    public void setRenderTopAndBottom(boolean render) {
        this.renderTopAndBottom = render;
    }

    protected final void clearEntries() {
        this.children.clear();
    }

    protected void replaceEntries(Collection<E> entries) {
        this.children.clear();
        this.children.addAll(entries);
    }

    protected E getEntry(int index) {
        return (E)((Entry)this.children().get(index));
    }

    protected int addEntry(E entry) {
        this.children.add(entry);
        return this.children.size() - 1;
    }

    protected void addEntryToTop(E entry) {
        double d0 = (double)this.getMaxScroll() - this.getScrollAmount();
        this.children.add(0, entry);
        this.setScrollAmount((double)this.getMaxScroll() - d0);
    }

    protected boolean removeEntryFromTop(E entry) {
        double d0 = (double)this.getMaxScroll() - this.getScrollAmount();
        boolean flag = this.removeEntry(entry);
        this.setScrollAmount((double)this.getMaxScroll() - d0);
        return flag;
    }

    protected int getItemCount() {
        return this.children().size();
    }

    protected boolean isSelectedItem(int index) {
        return Objects.equals(this.getSelected(), this.children().get(index));
    }

    @Nullable
    protected final E getEntryAtPosition(double mouseX, double mouseY) {
        int i = this.getRowWidth() / 2;
        int j = this.x0 + this.width / 2;
        int k = j - i;
        int l = j + i;
        int i1 = MathHelper.func_76128_c((double)(mouseY - (double)this.y0)) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int j1 = i1 / this.itemHeight;
        return (E)(mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)k && mouseX <= (double)l && j1 >= 0 && i1 >= 0 && j1 < this.getItemCount() ? (Entry)this.children().get(j1) : null);
    }

    public void updateSize(int width, int height, int screenY, int listY) {
        this.width = width;
        this.height = height;
        this.y0 = screenY;
        this.y1 = listY;
        this.x0 = 0;
        this.x1 = width;
    }

    public void setLeftPos(int left) {
        this.x0 = left;
        this.x1 = left + this.width;
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    public void tick() {
        ++this.lastTick;
        int max = this.getItemCount();
        for (int i = 0; i < max; ++i) {
            int j1 = this.getRowTop(i);
            if (j1 + this.itemHeight < this.y0 || j1 > this.y1) continue;
            ((Entry)this.getEntry(i)).tick();
        }
    }

    protected void renderBackground() {
    }

    @Override
    public void render(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        int maxScroll;
        int color;
        BackgroundTexture texture;
        this.scrollAmount.update(partialTicks);
        this.renderBackground();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder builder = tes.func_178180_c();
        this.hovered = this.isMouseOver(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        Object v0 = this.hovered;
        if (this.renderBackground) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            texture = this.texture.getTexture();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture.getBackgroundTexture());
            color = texture.getBackgroundBrightness();
            float scroll = (float)this.getScrollAmount();
            builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            builder.func_181662_b((double)this.x0, (double)this.y1, 0.0).func_187315_a((double)((float)this.x0 / 32.0f), (double)(((float)this.y1 + scroll) / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
            builder.func_181662_b((double)this.x1, (double)this.y1, 0.0).func_187315_a((double)((float)this.x1 / 32.0f), (double)(((float)this.y1 + scroll) / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
            builder.func_181662_b((double)this.x1, (double)this.y0, 0.0).func_187315_a((double)((float)this.x1 / 32.0f), (double)(((float)this.y0 + scroll) / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
            builder.func_181662_b((double)this.x0, (double)this.y0, 0.0).func_187315_a((double)((float)this.x0 / 32.0f), (double)(((float)this.y0 + scroll) / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
            tes.func_78381_a();
        }
        this.renderList(mouseX, mouseY, partialTicks);
        if (this.renderTopAndBottom) {
            texture = this.texture.getTexture();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture.getForegroundTexture());
            GlStateManager.func_179098_w();
            GlStateManager.func_179126_j();
            GlStateManager.func_179143_c((int)519);
            color = texture.getForegroundBrightness();
            builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            builder.func_181662_b((double)this.x0, (double)this.y0, -100.0).func_187315_a(0.0, (double)((float)this.y0 / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
            builder.func_181662_b((double)(this.x0 + this.width), (double)this.y0, -100.0).func_187315_a((double)((float)this.width / 32.0f), (double)((float)this.y0 / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
            builder.func_181662_b((double)(this.x0 + this.width), 0.0, -100.0).func_187315_a((double)((float)this.width / 32.0f), 0.0).func_181669_b(color, color, color, 255).func_181675_d();
            builder.func_181662_b((double)this.x0, 0.0, -100.0).func_187315_a(0.0, 0.0).func_181669_b(color, color, color, 255).func_181675_d();
            builder.func_181662_b((double)this.x0, (double)this.height, -100.0).func_187315_a(0.0, (double)((float)this.height / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
            builder.func_181662_b((double)(this.x0 + this.width), (double)this.height, -100.0).func_187315_a((double)((float)this.width / 32.0f), (double)((float)this.height / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
            builder.func_181662_b((double)(this.x0 + this.width), (double)this.y1, -100.0).func_187315_a((double)((float)this.width / 32.0f), (double)((float)this.y1 / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
            builder.func_181662_b((double)this.x0, (double)this.y1, -100.0).func_187315_a(0.0, (double)((float)this.y1 / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
            tes.func_78381_a();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179118_c();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179090_x();
            builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            builder.func_181662_b((double)this.x0, (double)(this.y0 + 4), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            builder.func_181662_b((double)this.x1, (double)(this.y0 + 4), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            builder.func_181662_b((double)this.x1, (double)this.y0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            builder.func_181662_b((double)this.x0, (double)this.y0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            builder.func_181662_b((double)this.x0, (double)this.y1, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            builder.func_181662_b((double)this.x1, (double)this.y1, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            builder.func_181662_b((double)this.x1, (double)(this.y1 - 4), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            builder.func_181662_b((double)this.x0, (double)(this.y1 - 4), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            tes.func_78381_a();
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
            GlStateManager.func_179098_w();
        }
        if ((maxScroll = this.getMaxScroll()) > 0) {
            int maxPosition = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            maxPosition = MathHelper.func_76125_a((int)maxPosition, (int)32, (int)(this.y1 - this.y0 - 8));
            int scrollValue = (int)this.getScrollAmount() * (this.y1 - this.y0 - maxPosition) / maxScroll + this.y0;
            if (scrollValue < this.y0) {
                scrollValue = this.y0;
            }
            int minX = this.getScrollbarPosition();
            int maxX = minX + 6;
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179118_c();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179090_x();
            builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            builder.func_181662_b((double)minX, (double)this.y1, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            builder.func_181662_b((double)maxX, (double)this.y1, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            builder.func_181662_b((double)maxX, (double)this.y0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            builder.func_181662_b((double)minX, (double)this.y0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tes.func_78381_a();
            builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            builder.func_181662_b((double)minX, (double)(scrollValue + maxPosition), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            builder.func_181662_b((double)maxX, (double)(scrollValue + maxPosition), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            builder.func_181662_b((double)maxX, (double)scrollValue, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            builder.func_181662_b((double)minX, (double)scrollValue, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            tes.func_78381_a();
            builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            builder.func_181662_b((double)minX, (double)(scrollValue + maxPosition - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            builder.func_181662_b((double)(maxX - 1), (double)(scrollValue + maxPosition - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            builder.func_181662_b((double)(maxX - 1), (double)scrollValue, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            builder.func_181662_b((double)minX, (double)scrollValue, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            tes.func_78381_a();
            GlStateManager.func_179098_w();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    protected void centerScrollOn(E entry) {
        this.setScrollAmount(this.children().indexOf(entry) * this.itemHeight + this.itemHeight / 2 - (this.y1 - this.y0) / 2);
    }

    protected void ensureVisible(E entry) {
        int k;
        int i = this.getRowTop(this.children().indexOf(entry));
        int j = i - this.y0 - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = this.y1 - i - this.itemHeight - this.itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int value) {
        this.setScrollAmount(this.getScrollAmount() + (double)value);
    }

    public double getScrollAmount() {
        return this.scrolling ? (double)this.scrollAmount.getTarget() : (double)this.scrollAmount.getValue();
    }

    public void setScrollAmount(double value) {
        this.scrollAmount.setTarget((float)MathHelper.func_151237_a((double)value, (double)0.0, (double)this.getMaxScroll()));
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScrollAmount() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        E e = this.getEntryAtPosition(mouseX, mouseY);
        if (e != null && e.mouseClick(mouseX, mouseY, button)) {
            this.setFocused((IInteractable)e);
            this.setDragging(true);
            return true;
        }
        return this.scrolling;
    }

    @Override
    public boolean mouseRelease(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.getFocused() != null) {
            this.getFocused().mouseRelease(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean mouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (IInteractableContainer.super.mouseDrag(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.y0) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)this.y1) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d0 = Math.max(1, this.getMaxScroll());
                int i = this.y1 - this.y0;
                int j = MathHelper.func_76125_a((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.setScrollAmount(this.getScrollAmount() + dragY * d1);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double scroll) {
        this.setScrollAmount(this.getScrollAmount() - scroll * (double)this.itemHeight * 2.0);
        return true;
    }

    @Override
    public boolean charTyped(char character, int keyCode) {
        if (IInteractableContainer.super.charTyped(character, keyCode)) {
            return true;
        }
        if (keyCode == 200) {
            this.moveSelection(true);
            return true;
        }
        if (keyCode == 208) {
            this.moveSelection(false);
            return true;
        }
        return false;
    }

    protected void moveSelection(boolean up) {
        this.moveSelection(up, value -> true);
    }

    protected void refreshSelection() {
        E e = this.getSelected();
        if (e != null) {
            this.setSelected(e);
            this.ensureVisible(e);
        }
    }

    protected boolean moveSelection(boolean up, Predicate<E> filter) {
        int i;
        int n = i = up ? -1 : 1;
        if (!this.children().isEmpty()) {
            int nextIndex;
            int index = this.children().indexOf(this.getSelected());
            while (index != (nextIndex = MathHelper.func_76125_a((int)(index + i), (int)0, (int)(this.getItemCount() - 1)))) {
                Entry entry = (Entry)this.children().get(nextIndex);
                if (filter.test(entry)) {
                    this.setSelected(entry);
                    this.ensureVisible(entry);
                    return true;
                }
                index = nextIndex;
            }
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseY >= (double)this.y0 && mouseY <= (double)this.y1 && mouseX >= (double)this.x0 && mouseX <= (double)this.x1;
    }

    protected void renderList(int mouseX, int mouseY, float partialTicks) {
        int i = this.getRowLeft();
        int j = this.getRowWidth();
        int k = this.itemHeight - 4;
        int l = this.getItemCount();
        for (int i1 = 0; i1 < l; ++i1) {
            int j1 = this.getRowTop(i1);
            int k1 = this.getRowBottom(i1);
            if (k1 < this.y0 || j1 > this.y1) continue;
            this.renderItem(mouseX, mouseY, partialTicks, i1, i, j1, j, k);
        }
    }

    protected void renderItem(int mouseX, int mouseY, float partialTicks, int x, int left, int top, int width, int height) {
        E e = this.getEntry(x);
        if (this.renderSelection && this.isSelectedItem(x)) {
            int i = this.isFocused() ? -1 : -8355712;
            this.renderSelection(top, width, height, i, -16777216);
        }
        ((Entry)e).render(x, top, left, width, height, mouseX, mouseY, Objects.equals(this.hovered, e), partialTicks);
    }

    protected void renderSelection(int top, int width, int height, int mainColor, int subColor) {
        int minX = this.x0 + (this.width - width) / 2;
        int maxX = this.x0 + (this.width + width) / 2;
        Gui.func_73734_a((int)minX, (int)(top - 2), (int)maxX, (int)(top + height + 2), (int)mainColor);
        Gui.func_73734_a((int)(minX + 1), (int)(top - 1), (int)(maxX - 1), (int)(top + height + 1), (int)subColor);
    }

    public int getRowLeft() {
        return this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    protected int getRowTop(int index) {
        return this.y0 + 4 - (int)this.getScrollAmount() + index * this.itemHeight + this.headerHeight;
    }

    private int getRowBottom(int index) {
        return this.getRowTop(index) + this.itemHeight;
    }

    protected boolean isFocused() {
        return false;
    }

    @Nullable
    protected E remove(int index) {
        Entry e = (Entry)this.children.get(index);
        return (E)(this.removeEntry((Entry)this.children.get(index)) ? e : null);
    }

    protected boolean removeEntry(E entry) {
        boolean flag = this.children.remove(entry);
        if (flag && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return flag;
    }

    @Nullable
    protected E getHovered() {
        return this.hovered;
    }

    void bindEntryToSelf(Entry<E> entry) {
        entry.list = this;
    }

    @Override
    public int getWidgetWidth() {
        return this.width;
    }

    @Override
    public int getWidgetHeight() {
        return this.height;
    }

    public int getTop() {
        return this.y0;
    }

    public int getBottom() {
        return this.y1;
    }

    public int getLeft() {
        return this.x0;
    }

    public int getRight() {
        return this.x1;
    }

    @Override
    public final boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public final void setDragging(boolean value) {
        this.isDragging = value;
    }

    @Override
    public IInteractable getFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(IInteractable interact) {
        this.focused = interact;
    }

    public List<E> children() {
        return this.children;
    }

    class TrackedList
    extends AbstractList<E> {
        private final List<E> delegate = Lists.newArrayList();

        TrackedList() {
        }

        @Override
        public E get(int p_93557_) {
            return (Entry)this.delegate.get(p_93557_);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public E set(int p_93559_, E p_93560_) {
            Entry e = (Entry)this.delegate.set(p_93559_, p_93560_);
            AbstractScrollList.this.bindEntryToSelf(p_93560_);
            return e;
        }

        @Override
        public void add(int p_93567_, E p_93568_) {
            this.delegate.add(p_93567_, p_93568_);
            AbstractScrollList.this.bindEntryToSelf(p_93568_);
        }

        @Override
        public E remove(int p_93565_) {
            return (Entry)this.delegate.remove(p_93565_);
        }
    }

    public static abstract class ContainerEntry<E extends Entry<E>>
    extends Entry<E>
    implements IInteractableContainer {
        @Nullable
        private IInteractable focused;
        private boolean dragging;

        @Override
        public boolean isDragging() {
            return this.dragging;
        }

        @Override
        public void setDragging(boolean dragging) {
            this.dragging = dragging;
        }

        @Override
        public void setFocused(@Nullable IInteractable focused) {
            this.focused = focused;
        }

        @Override
        @Nullable
        public IInteractable getFocused() {
            return this.focused;
        }
    }

    public static abstract class Entry<E extends Entry<E>>
    implements IInteractable {
        protected AbstractScrollList<E> list;

        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public void tick() {
        }

        @Override
        public boolean isMouseOver(double p_93537_, double p_93538_) {
            return Objects.equals(this.list.getEntryAtPosition(p_93537_, p_93538_), this);
        }
    }
}

