/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ElementList;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.CarbonEditBox;
import carbonconfiglib.gui.widgets.screen.CarbonScreen;
import carbonconfiglib.utils.ParseResult;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class EditStringScreen
extends CarbonScreen {
    ITextComponent title;
    GuiScreen parent;
    IValueNode value;
    CarbonEditBox textBox;
    boolean valid = true;
    BackgroundTexture.BackgroundHolder texture;
    ParseResult<Boolean> result;

    public EditStringScreen(GuiScreen parent, ITextComponent name, IValueNode value, BackgroundTexture.BackgroundHolder texture) {
        this.title = name;
        this.parent = parent;
        this.value = value;
        this.value.createTemp();
        this.texture = texture == null ? BackgroundTexture.DEFAULT.asHolder() : texture;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_146294_l / 2 - 100;
        GuiButton apply = this.addWidget(new CarbonButton(x + 10, 160, 85, 20, I18n.func_135052_a((String)"gui.carbonconfig.apply", (Object[])new Object[0]), this::save));
        this.addWidget(new CarbonButton(x + 105, 160, 85, 20, I18n.func_135052_a((String)"gui.carbonconfig.cancel", (Object[])new Object[0]), this::cancel));
        this.textBox = new CarbonEditBox(this.field_146289_q, x, 113, 200, 18);
        this.addWidget(this.textBox);
        this.textBox.func_146180_a(this.value.get());
        this.textBox.setListener(T -> {
            this.textBox.func_146193_g(0xE0E0E0);
            this.valid = true;
            this.result = this.value.isValid((String)T);
            if (!this.result.getValue().booleanValue()) {
                this.textBox.func_146193_g(0xFF0000);
                this.valid = false;
            }
            apply.field_146124_l = this.valid;
            if (this.valid) {
                this.value.set(this.textBox.func_146179_b());
            }
        });
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ElementList.renderBackground(0, this.field_146294_l, 0, this.field_146295_m, 0.0f, this.texture.getTexture());
        ElementList.renderListOverlay(0, this.field_146294_l, 103, 142, this.field_146294_l, this.field_146295_m, this.texture.getTexture());
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String title = this.title.func_150254_d();
        this.field_146289_q.func_78276_b(title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(title) / 2, 85, -1);
        if (this.textBox.isMouseOver(mouseX, mouseY) && this.result != null && !this.result.getValue().booleanValue()) {
            this.func_146283_a((List)new ObjectArrayList((Collection)this.field_146289_q.func_78271_c(this.result.getError().getMessage(), Integer.MAX_VALUE)), mouseX, mouseY);
        }
    }

    @Override
    public void onClose() {
        this.value.setPrevious();
        this.field_146297_k.func_147108_a(this.parent);
    }

    private void save(GuiButton button) {
        if (!this.valid) {
            return;
        }
        this.value.apply();
        this.field_146297_k.func_147108_a(this.parent);
    }

    private void cancel(GuiButton button) {
        if (this.value.isChanged()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((T, k) -> {
                if (T) {
                    this.value.setPrevious();
                }
                this.field_146297_k.func_147108_a((GuiScreen)(T ? this.parent : this));
            }, new TextComponentTranslation("gui.carbonconfig.warn.changed", new Object[0]).func_150254_d(), new TextComponentTranslation("gui.carbonconfig.warn.changed.desc", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150254_d(), 0));
            return;
        }
        this.value.setPrevious();
        this.field_146297_k.func_147108_a(this.parent);
    }
}

