/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.minecraft;

import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.impl.minecraft.IGameRuleValue;
import carbonconfiglib.gui.impl.minecraft.MinecraftValue;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class MinecraftLeaf
implements IConfigNode {
    IGameRuleValue entry;
    MinecraftValue value;

    public MinecraftLeaf(IGameRuleValue entry) {
        this.entry = entry;
    }

    @Override
    public List<IConfigNode> getChildren() {
        return null;
    }

    @Override
    public IStructuredData.StructureType getDataStructure() {
        return IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public INode asNode() {
        if (this.value == null) {
            this.value = new MinecraftValue(this.entry);
        }
        return this.value;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return this.value != null && this.value.isChanged();
    }

    @Override
    public void setPrevious() {
        if (this.value != null) {
            this.value.setPrevious();
        }
    }

    @Override
    public void setDefault() {
        if (this.value != null) {
            this.value.setDefault();
        }
    }

    @Override
    public void save() {
        if (this.value != null) {
            this.value.save();
        }
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public boolean requiresReload() {
        return false;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public ITextComponent getName() {
        return IConfigNode.createLabel(I18n.func_135052_a((String)this.entry.getDescriptionId(), (Object[])new Object[0]));
    }

    @Override
    public ITextComponent getTooltip() {
        String id = this.entry.getDescriptionId();
        TextComponentString result = new TextComponentString("");
        result.func_150257_a(new TextComponentTranslation(id, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        id = id + ".description";
        if (I18n.func_188566_a((String)id)) {
            result.func_150258_a("\n").func_150257_a(new TextComponentTranslation(id, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
        return result;
    }
}

