/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.impl.forge.ForgeArray;
import carbonconfiglib.gui.impl.forge.ForgeValue;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.impl.entries.ColorValue;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.structure.IStructuredData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import speiger.src.collections.objects.utils.ObjectLists;

public class ForgeLeaf
implements IConfigNode {
    Property property;
    ForgeValue value;
    ForgeArray array;

    public ForgeLeaf(Property property) {
        this.property = property;
    }

    @Override
    public List<IConfigNode> getChildren() {
        return null;
    }

    @Override
    public INode asNode() {
        if (this.property.isList()) {
            if (this.array == null) {
                this.array = new ForgeArray(this.getName(), this.getTooltip(), this.getMode(), this.fromType(this.property.getType()), (List<String>)new ObjectArrayList((Object[])this.property.getStringList()), (List<String>)new ObjectArrayList((Object[])this.property.getDefaults()), () -> this.getValidValues(), this::isValid, T -> this.property.setValues(T.toArray(new String[T.size()])));
            }
            return this.array;
        }
        if (this.value == null) {
            this.value = new ForgeValue(this.getName(), this.getTooltip(), this.getMode(), this.fromType(this.property.getType()), this.property.getString(), this.property.getDefault(), () -> this.getValidValues(), this::isValid, (K, V) -> this.property.set(K));
        }
        return this.value;
    }

    private ReloadMode getMode() {
        return this.property.requiresMcRestart() ? ReloadMode.GAME : (this.property.requiresWorldRestart() ? ReloadMode.WORLD : null);
    }

    public List<ISuggestionProvider.Suggestion> getValidValues() {
        String[] values = this.property.getValidValues();
        if (values == null || values.length <= 0) {
            return ObjectLists.empty();
        }
        ObjectArrayList suggestion = new ObjectArrayList();
        for (String value : values) {
            suggestion.add(ISuggestionProvider.Suggestion.value(value));
        }
        return suggestion;
    }

    public ParseResult<Boolean> isValid(String value) {
        switch (this.property.getType()) {
            case BOOLEAN: {
                return ParseResult.success(true);
            }
            case COLOR: {
                return this.validate(ColorValue.ColorWrapper.parseInt(value));
            }
            case DOUBLE: {
                return this.validate(Helpers.parseDouble(value));
            }
            case INTEGER: {
                return this.validate(Helpers.parseInt(value));
            }
            case MOD_ID: {
                return ParseResult.result(Loader.instance().getIndexedModList().containsKey(value), NullPointerException::new, "Mod [" + value + "] isn't a thing");
            }
            case STRING: {
                return ParseResult.success(true);
            }
        }
        return ParseResult.success(true);
    }

    private ParseResult<Boolean> validate(ParseResult<?> value) {
        return value.hasError() ? value.withDefault(false) : ParseResult.success(true);
    }

    @Override
    public IStructuredData.StructureType getDataStructure() {
        return this.property.isList() ? IStructuredData.StructureType.LIST : IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return this.value != null && this.value.isChanged() || this.array != null && this.array.isChanged();
    }

    @Override
    public void setPrevious() {
        if (this.value != null) {
            this.value.setPrevious();
        }
        if (this.array != null) {
            this.array.setPrevious();
        }
    }

    @Override
    public void setDefault() {
        this.asNode();
        if (this.property.isList()) {
            this.array.setDefault();
        } else {
            this.value.setDefault();
        }
    }

    @Override
    public void save() {
        if (this.value != null) {
            this.value.save();
        }
        if (this.array != null) {
            this.array.save();
        }
    }

    @Override
    public boolean requiresRestart() {
        return this.property.requiresMcRestart();
    }

    @Override
    public boolean requiresReload() {
        return this.property.requiresWorldRestart();
    }

    @Override
    public String getNodeName() {
        return this.property.getName().toLowerCase(Locale.ROOT);
    }

    @Override
    public ITextComponent getName() {
        return IConfigNode.createLabel(I18n.func_188566_a((String)this.property.getLanguageKey()) ? I18n.func_135052_a((String)this.property.getLanguageKey(), (Object[])new Object[0]) : this.property.getName());
    }

    @Override
    public ITextComponent getTooltip() {
        String[] array;
        TextComponentString comp = new TextComponentString("");
        comp.func_150257_a(new TextComponentString(I18n.func_188566_a((String)this.property.getLanguageKey()) ? I18n.func_135052_a((String)this.property.getLanguageKey(), (Object[])new Object[0]) : this.property.getName()).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        String comment = this.property.getComment();
        if (comment != null && (array = comment.split("\n")) != null && array.length > 0) {
            int i = 0;
            while (i < array.length) {
                comp.func_150258_a("\n").func_150258_a(array[i++]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            }
        }
        return comp;
    }

    private DataType fromType(Property.Type type) {
        switch (type) {
            case BOOLEAN: {
                return DataType.BOOLEAN;
            }
            case COLOR: {
                return DataType.INTEGER;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
            case INTEGER: {
                return DataType.INTEGER;
            }
            case MOD_ID: {
                return DataType.STRING;
            }
            case STRING: {
                return DataType.STRING;
            }
        }
        return DataType.STRING;
    }
}

