/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.gui.api.IConfigFolderNode;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.impl.forge.ForgeLeaf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;

public class ForgeFolder
implements IConfigFolderNode {
    ConfigCategory category;
    List<IConfigNode> children;

    public ForgeFolder(ConfigCategory category) {
        this.category = category;
    }

    @Override
    public List<IConfigNode> getChildren() {
        if (this.children == null) {
            this.children = new ObjectArrayList();
            for (Property prop : this.category.values()) {
                this.children.add(new ForgeLeaf(prop));
            }
        }
        return this.children;
    }

    @Override
    public String getNodeName() {
        return this.category.getName().toLowerCase(Locale.ROOT);
    }

    @Override
    public ITextComponent getName() {
        return IConfigNode.createLabel(I18n.func_188566_a((String)this.category.getLanguagekey()) ? I18n.func_135052_a((String)this.category.getLanguagekey(), (Object[])new Object[0]) : this.category.getName());
    }

    @Override
    public ITextComponent getTooltip() {
        String[] array;
        TextComponentString comp = new TextComponentString("");
        comp.func_150257_a(new TextComponentString(I18n.func_188566_a((String)this.category.getLanguagekey()) ? I18n.func_135052_a((String)this.category.getLanguagekey(), (Object[])new Object[0]) : this.category.getName()).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        String comment = this.category.getComment();
        if (comment != null && (array = comment.split("\n")) != null && array.length > 0) {
            int i = 0;
            while (i < array.length) {
                comp.func_150258_a("\n").func_150258_a(array[i++]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            }
        }
        return comp;
    }
}

