/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ElementList;
import carbonconfiglib.gui.config.IIgnoreSearch;
import carbonconfiglib.gui.config.IListOwner;
import carbonconfiglib.gui.screen.MultiChoiceScreen;
import carbonconfiglib.gui.widgets.CarbonEditBox;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.Icon;
import carbonconfiglib.gui.widgets.screen.CarbonScreen;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.awt.Desktop;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public abstract class ListScreen
extends CarbonScreen
implements IListOwner {
    private static final ITextComponent LOG_INFO = new TextComponentTranslation("gui.carbonconfig.logo.name", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)).func_150258_a("\n").func_150257_a(new TextComponentTranslation("gui.carbonconfig.logo.page", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
    protected ITextComponent title;
    protected ElementList visibleList;
    protected List<Element> allEntries = new ObjectArrayList();
    protected List<ITextComponent> tooltips = new ObjectArrayList();
    protected CarbonEditBox activeWidget;
    protected long currentTick = 0L;
    protected long lastTick = -1L;
    protected double lastScroll = -1.0;
    protected CarbonEditBox searchBox;
    BackgroundTexture.BackgroundHolder customTexture;

    public ListScreen(ITextComponent name, BackgroundTexture.BackgroundHolder customTexture) {
        this.title = name;
        this.customTexture = customTexture;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.allEntries.clear();
        this.visibleList = new ElementList(this.field_146294_l, this.field_146295_m, this.getHeaderSpace(), this.field_146295_m - this.getFooterSpace(), this.getElementHeight());
        this.visibleList.setCustomBackground(this.customTexture);
        this.visibleList.setListWidth(this.getListWidth());
        this.visibleList.setScrollPadding(this.getScrollPadding());
        this.collectElements(this::addEntry);
        this.visibleList.addElements(this.sortElements(this.allEntries));
        this.addWidget(this.visibleList);
        if (this.shouldHaveSearch()) {
            this.searchBox = new CarbonEditBox(this.field_146289_q, this.field_146294_l / 2 - 100, 25, 200, 20);
            this.searchBox.setSuggestion(I18n.func_135052_a((String)"gui.carbonconfig.search", (Object[])new Object[0]));
            this.searchBox.setListener(T -> this.onSearchChange(this.searchBox, T.toLowerCase(Locale.ROOT)));
            this.addWidget(this.searchBox);
        }
        if (this.lastScroll >= 0.0) {
            this.visibleList.setScrollAmount(this.lastScroll);
        }
    }

    protected List<Element> sortElements(List<Element> list) {
        return list;
    }

    @Override
    public void tick() {
        ++this.currentTick;
        super.tick();
        this.visibleList.tick();
        if (this.searchBox != null) {
            this.searchBox.tick();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GuiUtils.drawTextureRegion(5.0f, 5.0f, 40.0f, 40.0f, Icon.LOGO, 400.0f, 400.0f);
        if (mouseX >= 5 && mouseX <= 45 && mouseY >= 5 && mouseY <= 40) {
            this.addTooltips(LOG_INFO);
        }
        this.handleForground(mouseX, mouseY, partialTicks);
        if (!this.tooltips.isEmpty()) {
            ObjectArrayList text = new ObjectArrayList();
            for (ITextComponent entry : this.tooltips) {
                text.addAll(this.field_146289_q.func_78271_c(entry.func_150254_d(), Math.max(mouseX, this.field_146294_l - mouseX) - 20));
            }
            this.func_146283_a((List)text, mouseX, mouseY);
            this.tooltips.clear();
        }
    }

    public void handleForground(int mouseX, int mouseY, float partialTicks) {
    }

    public void func_146281_b() {
        this.lastScroll = this.visibleList.getScrollAmount();
        super.func_146281_b();
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        if (mouseX >= 5.0 && mouseX <= 45.0 && mouseY >= 5.0 && mouseY <= 45.0) {
            this.activeWidget = null;
            MultiChoiceScreen screen = new MultiChoiceScreen(T -> {
                if (T.isMain()) {
                    this.openURL("https://curseforge.com/minecraft/mc-mods/carbon-config");
                } else if (T.isOther()) {
                    this.openURL("https://modrinth.com/mod/carbon-config");
                } else {
                    this.field_146297_k.func_147108_a((GuiScreen)this);
                }
            }, (ITextComponent)new TextComponentTranslation("gui.carbonconfig.logo.link.title", new Object[0]), new TextComponentTranslation("gui.carbonconfig.logo.link.message", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)), (ITextComponent)new TextComponentTranslation("gui.carbonconfig.logo.link.curseforge", new Object[0]), (ITextComponent)new TextComponentTranslation("gui.carbonconfig.logo.link.modrinth", new Object[0]), (ITextComponent)new TextComponentTranslation("gui.carbonconfig.reset_all.cancel", new Object[0]));
            this.field_146297_k.func_147108_a((GuiScreen)screen);
            return true;
        }
        boolean result = super.mouseClick(mouseX, mouseY, button);
        if (this.currentTick - this.lastTick >= 5L) {
            this.activeWidget = null;
        }
        return result;
    }

    private void openURL(String url) {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((T, U) -> {
            if (T) {
                try {
                    Desktop.getDesktop().browse(new URL(url).toURI());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }, url, 0, true));
    }

    protected void addInternal(Element element) {
        element.owner = this;
        element.init();
    }

    protected void addEntry(Element element) {
        element.owner = this;
        this.allEntries.add(element);
        element.init();
    }

    protected abstract void collectElements(Consumer<Element> var1);

    protected void onSearchChange(CarbonEditBox box, String value) {
        this.onSearchChange(box, value, this.allEntries);
    }

    protected boolean onSearchChange(CarbonEditBox box, String value, List<Element> allEntries) {
        if (value.isEmpty()) {
            box.setSuggestion(I18n.func_135052_a((String)"gui.carbonconfig.search", (Object[])new Object[0]));
            this.visibleList.updateList(allEntries);
            this.visibleList.setScrollAmount(this.visibleList.getScrollAmount());
            return true;
        }
        ObjectArrayList validElements = new ObjectArrayList();
        String suggestion = null;
        int m = allEntries.size();
        for (int i = 0; i < m; ++i) {
            String name;
            Element el = allEntries.get(i);
            if (IIgnoreSearch.shouldIgnoreSearch(el) || !(name = el.getName().toLowerCase(Locale.ROOT)).contains(value)) continue;
            validElements.add(el);
            if (!name.startsWith(value) || suggestion != null && suggestion.length() <= name.length()) continue;
            suggestion = el.getName();
        }
        if (validElements.size() > 0 && suggestion == null) {
            int offset;
            String sub;
            ObjectArrayList sorted;
            ObjectArrayList objectArrayList = sorted = validElements.size() > 2 ? new ObjectArrayList((Collection)validElements) : validElements;
            if (validElements.size() > 2) {
                sorted.sort(Comparator.comparing(Element::getName, Comparator.comparingInt(String::length).reversed()));
            }
            int m2 = sorted.size();
            for (int i = 0; i < m2 && (suggestion = (sub = ((Element)sorted.get(i)).getName()).substring(offset = sub.toLowerCase(Locale.ROOT).indexOf(value))).length() <= value.length(); ++i) {
            }
            if (suggestion.length() <= value.length()) {
                suggestion = null;
            }
        }
        if (validElements.isEmpty()) {
            box.setSuggestion("");
            this.visibleList.updateList((List<Element>)ObjectLists.emptyList());
            this.visibleList.setScrollAmount(this.visibleList.getScrollAmount());
            return false;
        }
        if (suggestion == null) {
            box.setSuggestion("");
        } else {
            box.setSuggestion(suggestion.substring(value.length()));
        }
        this.visibleList.updateList((List<Element>)validElements);
        this.visibleList.setScrollAmount(this.visibleList.getScrollAmount());
        return false;
    }

    protected boolean shouldHaveSearch() {
        return true;
    }

    protected boolean shouldHaveTooltips() {
        return true;
    }

    protected int getListWidth() {
        return 220;
    }

    protected int getScrollPadding() {
        return 124;
    }

    protected int getHeaderSpace() {
        return 50;
    }

    protected int getFooterSpace() {
        return 36;
    }

    protected int getElementHeight() {
        return 24;
    }

    @Override
    public void addTooltips(ITextComponent tooltip) {
        if (this.shouldHaveTooltips()) {
            this.tooltips.add(tooltip);
        }
    }

    @Override
    public boolean isInsideList(double mouseX, double mouseY) {
        return this.visibleList.isMouseOver(mouseX, mouseY);
    }

    @Override
    public boolean isActiveWidget(CarbonEditBox widget) {
        return this.activeWidget == widget;
    }

    @Override
    public void setActiveWidget(CarbonEditBox widget) {
        this.activeWidget = widget;
        this.lastTick = this.currentTick;
    }

    @Override
    public void updateInformation() {
        this.visibleList.children().forEach(Element::updateValues);
    }

    @Override
    public void removeEntry(Element element) {
    }

    @Override
    public BackgroundTexture.BackgroundHolder getCustomTexture() {
        return this.customTexture;
    }
}

