/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.widgets.screen.AbstractScrollList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class ElementList
extends AbstractScrollList<Element> {
    int listWidth = 220;
    int scrollPadding = 124;
    Consumer<Element> callback;

    public ElementList(int width, int height, int screenY, int listY, int itemHeight) {
        super(width, height, screenY, listY, itemHeight);
        this.setRenderSelection(false);
    }

    @Override
    protected boolean isSelectedItem(int index) {
        return Objects.equals(this.getSelected(), this.children().get(index));
    }

    public void setCallback(Consumer<Element> callback) {
        this.callback = callback;
    }

    public void addElement(Element element) {
        this.addEntry(element);
    }

    public void addElements(List<Element> elements) {
        elements.forEach(this::addEntry);
    }

    public void updateList(List<Element> elements) {
        super.replaceEntries(elements);
    }

    public void removeElement(Element element) {
        this.removeEntry(element);
    }

    public int size() {
        return this.children().size();
    }

    @Override
    public void setSelected(Element p_93462_) {
        super.setSelected(p_93462_);
        if (this.callback != null && this.getSelected() != null) {
            this.callback.accept((Element)this.getSelected());
        }
    }

    public void scrollToElement(Element element, boolean center) {
        int index = this.children().indexOf(element);
        if (index == -1) {
            return;
        }
        this.scrollToElement(index, center);
    }

    public void scrollToSelected(boolean center) {
        if (this.getSelected() == null) {
            return;
        }
        this.scrollToElement((Element)this.getSelected(), center);
    }

    public void scrollToElement(int index, boolean center) {
        if (center) {
            index -= this.height / this.itemHeight / 3;
        }
        this.setScrollAmount(Math.max(0, index) * this.itemHeight + this.headerHeight);
    }

    public void setListWidth(int listWidth) {
        this.listWidth = listWidth;
    }

    public void setScrollPadding(int scrollPadding) {
        this.scrollPadding = scrollPadding;
    }

    @Override
    public int getRowWidth() {
        return this.listWidth;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.width / 2 + this.scrollPadding;
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public static void renderBackground(int x0, int x1, int y0, int y1, float scroll, BackgroundTexture texture) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture.getBackgroundTexture());
        int color = texture.getBackgroundBrightness();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder builder = tes.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        builder.func_181662_b((double)x0, (double)y1, 0.0).func_187315_a((double)((float)x0 / 32.0f), (double)(((float)y1 + scroll) / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
        builder.func_181662_b((double)x1, (double)y1, 0.0).func_187315_a((double)((float)x1 / 32.0f), (double)(((float)y1 + scroll) / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
        builder.func_181662_b((double)x1, (double)y0, 0.0).func_187315_a((double)((float)x1 / 32.0f), (double)(((float)y0 + scroll) / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
        builder.func_181662_b((double)x0, (double)y0, 0.0).func_187315_a((double)((float)x0 / 32.0f), (double)(((float)y0 + scroll) / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
        tes.func_78381_a();
    }

    public static void renderListOverlay(int x0, int x1, int y0, int y1, int width, int height, BackgroundTexture texture) {
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder builder = tes.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture.getForegroundTexture());
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)519);
        int color = texture.getForegroundBrightness();
        builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        builder.func_181662_b((double)x0, (double)y0, -100.0).func_187315_a(0.0, (double)((float)y0 / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
        builder.func_181662_b((double)(x0 + width), (double)y0, -100.0).func_187315_a((double)((float)width / 32.0f), (double)((float)y0 / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
        builder.func_181662_b((double)(x0 + width), 0.0, -100.0).func_187315_a((double)((float)width / 32.0f), 0.0).func_181669_b(color, color, color, 255).func_181675_d();
        builder.func_181662_b((double)x0, 0.0, -100.0).func_187315_a(0.0, 0.0).func_181669_b(color, color, color, 255).func_181675_d();
        builder.func_181662_b((double)x0, (double)height, -100.0).func_187315_a(0.0, (double)((float)height / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
        builder.func_181662_b((double)(x0 + width), (double)height, -100.0).func_187315_a((double)((float)width / 32.0f), (double)((float)height / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
        builder.func_181662_b((double)(x0 + width), (double)y1, -100.0).func_187315_a((double)((float)width / 32.0f), (double)((float)y1 / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
        builder.func_181662_b((double)x0, (double)y1, -100.0).func_187315_a(0.0, (double)((float)y1 / 32.0f)).func_181669_b(color, color, color, 255).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179118_c();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179090_x();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_181662_b((double)x0, (double)(y0 + 4), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        builder.func_181662_b((double)x1, (double)(y0 + 4), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        builder.func_181662_b((double)x1, (double)y0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        builder.func_181662_b((double)x0, (double)y0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        builder.func_181662_b((double)x0, (double)y1, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        builder.func_181662_b((double)x1, (double)y1, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        builder.func_181662_b((double)x1, (double)(y1 - 4), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        builder.func_181662_b((double)x0, (double)(y1 - 4), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }
}

