/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.config;

import carbonconfiglib.api.buffer.IReadBuffer;
import carbonconfiglib.config.ConfigEntry;
import java.util.UUID;
import java.util.function.Supplier;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectLinkedOpenHashMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;

public class SyncedConfig<T extends ConfigEntry<?>> {
    Object2ObjectMap<UUID, T> mappedEntries = new Object2ObjectLinkedOpenHashMap<UUID, T>();
    Supplier<T> creator;

    public SyncedConfig(Supplier<T> creator, T defaultValue) {
        this.creator = creator;
        this.mappedEntries.setDefaultReturnValue(defaultValue);
    }

    public boolean isPresent(UUID id) {
        return this.mappedEntries.containsKey(id);
    }

    public T get(UUID id) {
        return (T)((ConfigEntry)this.mappedEntries.get(id));
    }

    public void onSync(IReadBuffer buffer, UUID owner) {
        this.mappedEntries.computeIfAbsent(owner, T -> (ConfigEntry)this.creator.get()).deserializeValue(buffer);
    }
}

