/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib;

import carbonconfiglib.api.ConfigType;
import carbonconfiglib.config.Config;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.config.ConfigSection;
import carbonconfiglib.config.ConfigSettings;
import carbonconfiglib.config.FileSystemWatcher;
import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.BackgroundTypes;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.screen.ConfigScreen;
import carbonconfiglib.gui.screen.RequestScreen;
import carbonconfiglib.impl.PerWorldProxy;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.impl.entries.ColorValue;
import carbonconfiglib.impl.entries.RegistryKeyValue;
import carbonconfiglib.impl.entries.RegistryValue;
import carbonconfiglib.impl.internal.ConfigLogger;
import carbonconfiglib.impl.internal.EventHandler;
import carbonconfiglib.networking.CarbonNetwork;
import carbonconfiglib.utils.AutomationType;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectLinkedOpenHashMap;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectOpenHashMap;

@Mod(modid="carbonconfig", version="1.2.1", name="Carbon Config Library", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12]")
public class CarbonConfig {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final FileSystemWatcher CONFIGS = new FileSystemWatcher(new ConfigLogger(LOGGER), Loader.instance().getConfigDir().toPath(), EventHandler.INSTANCE);
    public static final CarbonNetwork NETWORK = new CarbonNetwork();
    public static BooleanSupplier MOD_GUI = () -> false;
    ConfigHandler handler;
    public static ConfigEntry.BoolValue FORGE_SUPPORT;
    public static ConfigEntry.BoolValue FORCE_FORGE_SUPPORT;
    public static ConfigEntry.BoolValue FORCE_CUSTOM_BACKGROUND;
    public static ConfigEntry.EnumValue<BackgroundTypes> BACKGROUNDS;
    public static ConfigEntry.BoolValue INGAME_BACKGROUND;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        NETWORK.init();
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            Config config = new Config("carbonconfig");
            ConfigSection section = config.add("general");
            FORGE_SUPPORT = (ConfigEntry.BoolValue)section.addBool("enable-forge-support", true, "Enables that CarbonConfig automatically adds Forge Configs into its own Config Gui System").setRequiredReload(ReloadMode.GAME);
            FORCE_FORGE_SUPPORT = (ConfigEntry.BoolValue)section.addBool("force-forge-support", true, "Enables that Carbon Config Overrides the config guis of forge mods that have added their own guis").setRequiredReload(ReloadMode.GAME);
            BACKGROUNDS = section.addEnum("custom-background", BackgroundTypes.PLANKS, BackgroundTypes.class, "Allows to pick for a Custom Background for Configs that use the default Background");
            FORCE_CUSTOM_BACKGROUND = section.addBool("force-custom-background", false, "Allows to force your Selected Background to be used everywhere instead of just default Backgrounds");
            INGAME_BACKGROUND = section.addBool("ingame-background", false, "Allows to set if the background is always visible or only if you are not in a active world");
            this.handler = CONFIGS.createConfig(config, ConfigSettings.withConfigType(ConfigType.CLIENT).withAutomations(AutomationType.AUTO_LOAD, AutomationType.AUTO_RELOAD));
            this.handler.register();
        }
    }

    public static ConfigSettings getPerWorldProxy() {
        return PerWorldProxy.perWorld();
    }

    public ConfigSettings createLateLoadSettings() {
        return ConfigSettings.withSettings(AutomationType.AUTO_RELOAD, AutomationType.AUTO_SYNC);
    }

    public static ColorValue createColor(String key, int color, String ... comments) {
        return new ColorValue(key, color, comments);
    }

    public static <E extends IForgeRegistryEntry<E>> RegistryKeyValue.Builder<E> createRegistryKeyBuilder(String key, Class<E> clz) {
        return RegistryKeyValue.builder(key, clz);
    }

    public static <E extends IForgeRegistryEntry<E>> RegistryValue.Builder<E> createRegistryBuilder(String key, Class<E> clz) {
        return RegistryValue.builder(key, clz);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openRemoteConfigFolder(IModConfig config, String ... path) {
        CarbonConfig.openRemoteConfigFolder(config, BackgroundTexture.DEFAULT, path);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openRemoteConfigFolder(IModConfig config, BackgroundTexture texture, String ... path) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            CarbonConfig.openLocalConfigFolder(config, texture, path);
            return;
        }
        if (config.getConfigType() == ConfigType.CLIENT) {
            LOGGER.info("Tried to open a local config in the Remote Opener");
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            LOGGER.info("Tried to open a Remote config when there was no remote attached");
            return;
        }
        if (mc.field_71439_g.func_184840_I() < 4) {
            LOGGER.info("Tried to open a Remote config without permission");
            return;
        }
        mc.func_147108_a((GuiScreen)new RequestScreen(texture.asHolder(), ConfigScreen.Navigator.create(config).withWalker(path), mc.field_71462_r, config));
    }

    @SideOnly(value=Side.CLIENT)
    public static void openLocalConfigFolder(IModConfig config, String ... path) {
        CarbonConfig.openLocalConfigFolder(config, BackgroundTexture.DEFAULT, path);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openLocalConfigFolder(IModConfig config, BackgroundTexture texture, String ... path) {
        if (!config.isLocalConfig()) {
            LOGGER.info("Tried to open a Remote config in the Local Opener");
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((GuiScreen)new ConfigScreen(ConfigScreen.Navigator.create(config).withWalker(path), config, mc.field_71462_r, texture.asHolder()));
    }

    public static boolean hasPermission(EntityPlayer player, int permissionLevel) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server.func_71264_H() && Objects.equals(player.func_146103_bH().getName(), server.func_71214_G())) {
            return true;
        }
        UserListOpsEntry entry = (UserListOpsEntry)server.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
        return entry != null && entry.func_152644_a() >= permissionLevel;
    }

    @Mod.EventHandler
    public void onCommonLoad(FMLPostInitializationEvent event) {
        for (ConfigHandler handler : CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.createDefaultConfig();
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.onClientLoad();
        }
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        Object2ObjectOpenHashMap<String, ModContainer> mods = new Object2ObjectOpenHashMap<String, ModContainer>();
        Object2ObjectLinkedOpenHashMap<ModContainer, ModContainer> mappingTasks = new Object2ObjectLinkedOpenHashMap<ModContainer, ModContainer>();
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            ModContainer from;
            ModContainer to;
            if ("registerGui".equalsIgnoreCase(message.key) && message.isStringMessage()) {
                ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(message.getSender());
                if (container == null) continue;
                mods.put(message.getStringValue(), container);
                continue;
            }
            if (!"remapGui".equalsIgnoreCase(message.key) || !message.isStringMessage() || (to = (ModContainer)Loader.instance().getIndexedModList().get(message.getSender())) == null || (from = (ModContainer)Loader.instance().getIndexedModList().get(message.getStringValue())) == null) continue;
            mappingTasks.put(from, to);
        }
        EventHandler.INSTANCE.processIMCEvents(mods, mappingTasks);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientLoad() {
        EventHandler.INSTANCE.onConfigsLoaded();
        KeyBinding mapping = new KeyBinding("key.carbon_config.key", 82, "key.carbon_config");
        ClientRegistry.registerKeyBinding((KeyBinding)mapping);
        MOD_GUI = () -> ((KeyBinding)mapping).func_151470_d();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && MOD_GUI.getAsBoolean()) {
            mc.func_147108_a((GuiScreen)new GuiModList(mc.field_71462_r));
        }
    }

    @Mod.EventHandler
    public void load(FMLServerAboutToStartEvent event) {
        for (ConfigHandler handler : CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.load();
        }
    }

    @Mod.EventHandler
    public void unload(FMLServerStoppingEvent event) {
        for (ConfigHandler handler : CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.unload();
        }
    }
}

