/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.client.screen.PressableButton;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.JarGroupListWidget;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.JarListWidget;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.PlayerCountStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectPlanTypeStep;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;

public class SelectJarStep
extends ProcessStep {
    private JarGroupListWidget.JarGroupEntry selectedGroup = null;
    private JarListWidget.JarEntry selectedJar = null;
    private final String nameFilter = I18n.func_135052_a((String)"step.select_jar.name_filter", (Object[])new Object[0]);
    private final String platformFilter = I18n.func_135052_a((String)"step.select_jar.platform_filter", (Object[])new Object[0]);
    private final String selectPack = I18n.func_135052_a((String)"step.select_jar.select_pack", (Object[])new Object[0]);
    private JarGroupListWidget jarGroupList;
    private JarListWidget jarList;
    private GuiTextField searchBar;
    private GuiButton selectButton;

    public SelectJarStep(OrderData orderData) {
        super(orderData);
        orderData.jar = null;
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<GuiButton> children) {
        super.init(screen, children);
        int y0 = 80;
        int y1 = screen.field_146295_m - 80;
        List<JarGroupData> jarGroupIds = ApiData.AVAILABLE_GROUPS.values().stream().sorted().filter(group -> !group.ignore).collect(Collectors.toList());
        this.jarGroupList = new JarGroupListWidget(this, screen.field_146297_k, screen.field_146294_l / 3, screen.field_146295_m, y0 + 44, y1, jarGroupIds);
        this.jarGroupList.setLeft(6);
        this.jarList = new JarListWidget(this, screen.field_146297_k, screen.field_146294_l - this.jarGroupList.field_148155_a - this.jarGroupList.field_148152_e - 16, screen.field_146295_m, y0, y1);
        this.jarList.setLeft(this.jarGroupList.field_148152_e + this.jarGroupList.field_148155_a + 10);
        this.searchBar = new GuiTextField(1, screen.field_146297_k.field_71466_p, this.jarGroupList.field_148152_e, this.jarGroupList.field_148153_b - 43, this.jarGroupList.field_148155_a, 15);
        this.searchBar.func_175207_a(new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int id, boolean value) {
                SelectJarStep.this.filterJars();
            }

            public void func_175320_a(int id, float value) {
                SelectJarStep.this.filterJars();
            }

            public void func_175319_a(int id, String value) {
                SelectJarStep.this.filterJars();
            }
        });
        this.selectButton = new PressableButton(2, this.jarList.field_148152_e + (this.jarList.field_148155_a - 150) / 2, this.jarList.field_148154_c + 7, 150, 20, I18n.func_135052_a((String)"step.select_jar.select", (Object[])new Object[0]), b -> screen.setStep(new SelectPlanTypeStep(this.orderData)));
        children.accept(this.selectButton);
        this.filterJars();
    }

    @Override
    public void tick(BHOrderScreen screen) {
        this.searchBar.func_146178_a();
        this.jarGroupList.setSelectedEntry(this.selectedGroup);
        this.jarList.setSelectedEntry(this.selectedJar);
        this.selectButton.field_146124_l = this.orderData.jar != null;
    }

    public void setSelectedGroup(@Nullable JarGroupListWidget.JarGroupEntry selectedGroup) {
        this.selectedGroup = selectedGroup == this.selectedGroup ? null : selectedGroup;
        this.filterJars();
    }

    public void setSelectedJar(@Nullable JarListWidget.JarEntry selectedJar) {
        this.selectedJar = selectedJar == this.selectedJar ? null : selectedJar;
        this.orderData.jar = this.selectedJar == null ? null : selectedJar.data;
    }

    public void filterJars() {
        this.jarList.setScrollAmount(0);
        Stream<JarGroupData.JarData> jarStream = ApiData.AVAILABLE_JARS.values().stream().sorted();
        if (this.selectedGroup != null) {
            jarStream = jarStream.filter(jar -> this.selectedGroup.data.premiumJars.containsKey(jar.premiumJarId));
        }
        if (!this.searchBar.func_146179_b().isEmpty()) {
            jarStream = jarStream.filter(jar -> jar.name.toLowerCase(Locale.ROOT).contains(this.searchBar.func_146179_b().toLowerCase(Locale.ROOT)));
        }
        List<JarGroupData.JarData> jars = jarStream.collect(Collectors.toList());
        this.jarList.buildJarList(jars);
        this.setSelectedJar(this.jarList.getSelected());
    }

    @Override
    public void render(BHOrderScreen screen, FontRenderer font, int mouseX, int mouseY, float partialTicks) {
        this.jarGroupList.func_148128_a(mouseX, mouseY, partialTicks);
        this.jarList.func_148128_a(mouseX, mouseY, partialTicks);
        this.searchBar.func_146194_f();
        font.func_175065_a(this.nameFilter, (float)this.searchBar.field_146209_f + (float)(this.searchBar.func_146200_o() - font.func_78256_a(this.nameFilter)) / 2.0f, (float)(this.searchBar.field_146210_g - 15), 0xFFFFFF, false);
        font.func_175065_a(this.platformFilter, (float)this.jarGroupList.field_148152_e + (float)(this.jarGroupList.field_148155_a - font.func_78256_a(this.platformFilter)) / 2.0f, (float)(this.jarGroupList.field_148153_b - 15), 0xFFFFFF, false);
        font.func_175065_a(this.selectPack, (float)this.jarList.field_148152_e + (float)(this.jarList.field_148155_a - font.func_78256_a(this.selectPack)) / 2.0f, (float)(this.jarList.field_148153_b - 15), 0xFFFFFF, false);
    }

    @Override
    public void handleMouseInput(int mouseX, int mouseY, int scroll) throws IOException {
        this.jarGroupList.func_178039_p();
        this.jarList.func_178039_p();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.jarList.func_148179_a(mouseX, mouseY, mouseButton);
        this.jarGroupList.func_148179_a(mouseX, mouseY, mouseButton);
        this.searchBar.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        this.searchBar.func_146201_a(typedChar, keyCode);
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        if (!this.searchBar.func_146179_b().isEmpty()) {
            this.searchBar.func_146180_a("");
        } else if (this.selectedGroup != null) {
            this.selectedGroup = null;
        } else {
            screen.setStep(new PlayerCountStep(this.orderData));
        }
    }
}

