/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.client.screen.PressableButton;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.RecommendJarStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectJarStep;
import java.util.function.Consumer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiSlider;

public class PlayerCountStep
extends ProcessStep {
    private final String question = I18n.func_135052_a((String)"step.player_count.question", (Object[])new Object[0]);

    public PlayerCountStep(OrderData data) {
        super(data);
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<GuiButton> children) {
        super.init(screen, children);
        children.accept((GuiButton)new GuiSlider(1, (screen.field_146294_l - 250) / 2, screen.field_146295_m / 2 - 30, 250, 20, "", "", 0.0, 100.0, (double)this.orderData.playerCount, false, true, s -> {
            int val = s.getValueInt();
            s.field_146126_j = val > 99 ? "99+" : String.valueOf(val);
            this.orderData.playerCount = val;
        }));
        children.accept(new PressableButton(2, screen.field_146294_l / 2 - 50, screen.field_146295_m / 2 + 10, 100, 20, I18n.func_135052_a((String)"step.player_count.next", (Object[])new Object[0]), b -> {
            JarGroupData.JarData recommendedJar = PlayerCountStep.getRecommendedJarData();
            if (recommendedJar == null) {
                screen.setStep(new SelectJarStep(this.orderData));
            } else {
                screen.setStep(new RecommendJarStep(recommendedJar, this.orderData));
            }
        }));
    }

    @Override
    public void render(BHOrderScreen screen, FontRenderer font, int mouseX, int mouseY, float partialTicks) {
        font.func_175065_a(this.question, (float)(screen.field_146294_l - font.func_78256_a(this.question)) / 2.0f, (float)screen.field_146295_m / 2.0f - 50.0f, 0xFFFFFF, false);
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        screen.field_146297_k.func_147108_a(screen.parent);
    }

    public static JarGroupData.JarData getRecommendedJarData() {
        if (GlobalConfigs.packId.getValue().isEmpty()) {
            return null;
        }
        JarGroupData.JarData recommendedJar = ApiData.AVAILABLE_JARS.get(GlobalConfigs.packId.getValue());
        if (recommendedJar == null) {
            ModRef.LOGGER.warn("Invalid pack id {}", (Object)GlobalConfigs.packId.getValue());
            return null;
        }
        return recommendedJar;
    }
}

