/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config.lists;

import com.bisecthosting.mods.bhmenu.client.screen.IGuiComponent;
import com.bisecthosting.mods.bhmenu.config.IConfigurable;
import com.bisecthosting.mods.bhmenu.config.ModuleConfigScreen;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.StringUtils;

public class ModuleConfigList
extends GuiListExtended {
    private ModuleConfigScreen screen;
    private List<Entry> entries;

    public ModuleConfigList(ModuleConfigScreen screen, Minecraft mc, int width, int height, int y0, int y1, int itemHeight) {
        super(mc, width, height, y0, y1, itemHeight);
        this.screen = screen;
        this.entries = new ArrayList<Entry>();
    }

    public void saveAll() {
        for (Entry entry : this.entries) {
            entry.save();
        }
    }

    public void populateModuleConfigList(BiConsumer<ModuleConfigList, Consumer<Entry>> populator) {
        populator.accept(this, this.entries::add);
    }

    public void func_148128_a(int mouseX, int mouseY, float delta) {
        super.func_148128_a(mouseX, mouseY, delta);
        int entryId = this.func_148124_c(mouseX, mouseY);
        GuiListExtended.IGuiListEntry entry = this.func_148180_b(entryId);
        if (entry instanceof Entry && mouseX < this.field_148155_a / 2 && entry != null && !((Entry)entry).comments.isEmpty()) {
            this.screen.func_146283_a(((Entry)entry).comments, mouseX, mouseY);
        }
    }

    protected boolean func_148131_a(int slotIndex) {
        return false;
    }

    public int func_148139_c() {
        return this.field_148155_a - 40;
    }

    protected int func_148137_d() {
        return this.field_148155_a - 6;
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int i) {
        if (i < 0 || i >= this.entries.size()) {
            return null;
        }
        return this.entries.get(i);
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    public void keyTyped(char typedChar, int keyCode) {
        Entry entry = (Entry)this.func_148180_b(this.field_148168_r);
        if (entry == null) {
            return;
        }
        entry.keyTyped(typedChar, keyCode);
    }

    public static class Entry
    implements GuiListExtended.IGuiListEntry {
        private final ModuleConfigList parent;
        private final List<String> comments = new ArrayList<String>();
        private final String text;
        private final IGuiComponent configButton;
        private final List<IGuiComponent> children;

        public Entry(ModuleConfigList parent, String comments, String text, IGuiComponent button) {
            this.parent = parent;
            if (!StringUtils.func_151246_b((String)comments)) {
                this.comments.addAll(Arrays.asList(comments.split("\n")));
            }
            this.text = text;
            this.configButton = button;
            this.children = Lists.newArrayList((Object[])new IGuiComponent[]{this.configButton});
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            this.configButton.setX(x + listWidth / 2 + 10);
            this.configButton.setY(y + (slotHeight - this.configButton.getHeight()) / 2);
            this.configButton._setWidth(listWidth / 2 - 10);
            this.configButton.draw(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            font.func_78276_b(this.text, x, y + (slotHeight - font.field_78288_b) / 2, 0xFFFFFF);
        }

        public void func_192633_a(int i, int i1, int i2, float v) {
        }

        public void save() {
            if (this.configButton instanceof IConfigurable) {
                ((IConfigurable)((Object)this.configButton)).save();
            }
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            for (IGuiComponent child : this.children) {
                if (child instanceof GuiButton && ((GuiButton)child).func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) {
                    ((GuiButton)child).func_146113_a(Minecraft.func_71410_x().func_147118_V());
                    return true;
                }
                if (!(child instanceof GuiTextField) || !((GuiTextField)child).func_146192_a(mouseX, mouseY, mouseEvent)) continue;
                return true;
            }
            return false;
        }

        public void func_148277_b(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            for (IGuiComponent child : this.children) {
                if (!(child instanceof GuiButton)) continue;
                ((GuiButton)child).func_146118_a(mouseX, mouseY);
                return;
            }
        }

        public void keyTyped(char typedChar, int keyCode) {
            for (IGuiComponent child : this.children) {
                if (!(child instanceof GuiTextField)) continue;
                ((GuiTextField)child).func_146201_a(typedChar, keyCode);
            }
        }
    }
}

