/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client.render.item;

import codechicken.lib.render.item.IItemRenderer;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import morph.avaritia.client.render.item.IEntityItemTickCallback;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;

public abstract class PerspectiveAwareItemRenderer
implements IItemRenderer,
IEntityItemTickCallback {
    @Nullable
    protected EntityLivingBase renderEntity;
    protected World world;
    protected BlockPos entityPos;
    private final IModelState state;

    protected PerspectiveAwareItemRenderer(IModelState state) {
        this.state = state;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public ItemOverrideList func_188617_f() {
        return new EntityCachingOverrideList((entity, world) -> {
            this.renderEntity = entity;
            this.world = world;
            if (entity != null) {
                this.entityPos = entity.func_180425_c();
            }
        });
    }

    public IModelState getTransforms() {
        return this.state;
    }

    @Override
    public void onEntityTick(EntityItem item) {
        this.entityPos = item.func_180425_c();
    }

    private static interface IEntityCallback {
        public void onEntityStuffs(EntityLivingBase var1, World var2);
    }

    private static class EntityCachingOverrideList
    extends ItemOverrideList {
        private IEntityCallback callback;

        public EntityCachingOverrideList(IEntityCallback callback) {
            super((List)ImmutableList.of());
            this.callback = callback;
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            this.callback.onEntityStuffs(entity, world);
            return super.handleItemState(originalModel, stack, world, entity);
        }
    }
}

