/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.util.registry;

import aroma1997.core.log.LogHelper;
import aroma1997.core.util.registry.AutoRegister;
import aroma1997.core.util.registry.HasItemBlock;
import aroma1997.core.util.registry.IAutoRegisterInfo;
import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public class AutoRegisterInfoClass<T>
implements IAutoRegisterInfo {
    private final Class<T> clazz;
    private final T obj;
    private final String modid;

    public AutoRegisterInfoClass(Class<T> clazz, T obj, String modid) {
        this.clazz = clazz;
        this.obj = obj;
        this.modid = modid;
    }

    @Override
    public String getModId() {
        return this.modid;
    }

    public Class<T> getRegisterClass() {
        return this.clazz;
    }

    public T getRegisterInstance() {
        return this.obj;
    }

    public String toString() {
        return this.modid + ":" + this.clazz.getName() + "@" + this.obj;
    }

    @Override
    public <C> Collection<C> getValuesApplicableFor(Class<C> toFind) {
        ArrayList<C> list = new ArrayList<C>();
        for (Field field : this.getRegisterClass().getDeclaredFields()) {
            Object val;
            AutoRegister autoRegister;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((autoRegister = field.getAnnotation(AutoRegister.class)) == null) continue;
            ResourceLocation name = new ResourceLocation(this.getModId(), !autoRegister.name().isEmpty() ? autoRegister.name() : field.getName());
            try {
                val = field.get(this.getRegisterInstance());
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            Object actual = AutoRegisterInfoClass.getTypeFromField(toFind, val);
            if (actual == null && toFind == Item.class) {
                HasItemBlock itemBlk = field.getAnnotation(HasItemBlock.class);
                Block block = AutoRegisterInfoClass.getTypeFromField(Block.class, val);
                if (itemBlk != null && block != null) {
                    try {
                        actual = itemBlk.itemBlock().getConstructor(Block.class).newInstance(block);
                    }
                    catch (Exception e) {
                        LogHelper.log(Level.ERROR, "Failed to load Item from containing Block: " + name);
                        Throwables.propagate((Throwable)e);
                    }
                }
            }
            if (actual == null || !(actual instanceof IForgeRegistryEntry)) continue;
            IForgeRegistryEntry entry = (IForgeRegistryEntry)actual;
            if (entry.getRegistryName() == null) {
                entry.setRegistryName(name);
            } else assert (entry.getRegistryName().equals((Object)name));
            list.add(actual);
        }
        return list;
    }

    private static <T> T getTypeFromField(Class<T> clazz, Object val) {
        if (clazz.isInstance(val)) {
            return (T)val;
        }
        while (val instanceof Supplier) {
            if (!clazz.isInstance(val = ((Supplier)val).get())) continue;
            return (T)val;
        }
        return null;
    }
}

