/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.config;

import aroma1997.core.config.ConfigEntry;
import aroma1997.core.config.ConfigProcessorBoolean;
import aroma1997.core.config.ConfigProcessorFloat;
import aroma1997.core.config.ConfigProcessorInt;
import aroma1997.core.config.ConfigProcessorString;
import aroma1997.core.config.IConfigProcessor;
import aroma1997.core.config.ReloadableValue;
import aroma1997.core.coremod.CoreMod;
import aroma1997.core.log.LogHelperPre;
import com.google.common.base.Throwables;
import java.io.File;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class Conf {
    private static Map<Class<?>, IConfigProcessor> processors = new IdentityHashMap();

    public static void loadReloadableConfig(Configuration config, Class<?> origin, Object o) {
        Conf.loadConfig(config, origin, o, field -> field.getAnnotation(ReloadableValue.class) != null);
    }

    public static void loadConfig(Configuration config, Class<?> origin, Object o) {
        Conf.loadConfig(config, origin, o, f -> true);
    }

    public static void loadConfig(Configuration config, Class<?> origin, Object o, Predicate<Field> shouldLoad) {
        try {
            for (Field field : origin.getDeclaredFields()) {
                ConfigEntry.ConfigCategoryDesc categoryDesc;
                ConfigEntry entry;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((entry = field.getAnnotation(ConfigEntry.class)) != null) {
                    Class<?> clazz = field.getType();
                    if (!processors.containsKey(clazz)) {
                        throw new IllegalArgumentException("Illegal type:" + clazz + " for config field " + field);
                    }
                    processors.get(clazz).process(config, field, o, entry);
                }
                if ((categoryDesc = field.getAnnotation(ConfigEntry.ConfigCategoryDesc.class)) == null) continue;
                if (field.getType() != String.class) {
                    throw new IllegalArgumentException();
                }
                String category = (String)field.get(o);
                config.addCustomCategoryComment(category, categoryDesc.value());
            }
        }
        catch (ReflectiveOperationException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public static File getConfigFolder() {
        return new File(CoreMod.mcLocation, "config/aroma1997");
    }

    public static File getConfigFile(String name) {
        File file = new File(Conf.getConfigFolder(), name + ".cfg");
        LogHelperPre.log(Level.TRACE, "Loaded configuration " + name + " from: " + file);
        return file;
    }

    public static Configuration getConfig(String name) {
        return new Configuration(Conf.getConfigFile(name));
    }

    static {
        processors.put(String.class, new ConfigProcessorString());
        processors.put(Integer.TYPE, new ConfigProcessorInt());
        processors.put(Float.TYPE, new ConfigProcessorFloat());
        processors.put(Boolean.TYPE, new ConfigProcessorBoolean());
    }
}

