/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.alfheim.lighting;

import dev.redstudio.alfheim.ProjectConstants;
import dev.redstudio.alfheim.api.IChunkLightingData;
import dev.redstudio.alfheim.lighting.LightUtil;
import dev.redstudio.alfheim.utils.DeduplicatedLongQueue;
import dev.redstudio.redcore.math.ClampUtil;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class LightingEngine {
    private static final byte MAX_LIGHT_LEVEL = 15;
    private final Thread ownerThread = Thread.currentThread();
    private final World world;
    private final Profiler profiler;
    private final DeduplicatedLongQueue[] lightUpdateQueues = new DeduplicatedLongQueue[EnumSkyBlock.values().length];
    private final DeduplicatedLongQueue[] darkeningQueues = new DeduplicatedLongQueue[16];
    private final DeduplicatedLongQueue[] brighteningQueues = new DeduplicatedLongQueue[16];
    private final DeduplicatedLongQueue initialBrightenings;
    private final DeduplicatedLongQueue initialDarkenings;
    private boolean updating = false;
    private static final int L_X = 26;
    private static final int L_Y = 8;
    private static final int L_Z = 26;
    private static final int L_L = 4;
    private static final int S_Z = 0;
    private static final int S_X = 26;
    private static final int S_Y = 52;
    private static final int S_L = 60;
    private static final long M_X = 0x3FFFFFFL;
    private static final long M_Y = 255L;
    private static final long M_Z = 0x3FFFFFFL;
    private static final long M_L = 15L;
    private static final long M_POS = 0xFFFFFFFFFFFFFFFL;
    private static final long Y_CHECK = 0x1000000000000000L;
    private static final long[] neighborShifts = new long[6];
    private static final long M_CHUNK = 4503598620737520L;
    private final BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
    private Chunk currentChunk;
    private long currentChunkIdentifier;
    private long currentData;
    private boolean isNeighborDataValid = false;
    private final NeighborInfo[] neighborInfos = new NeighborInfo[6];
    private DeduplicatedLongQueue currentQueue;
    private final ReentrantLock lock = new ReentrantLock();

    public LightingEngine(World world) {
        int i;
        this.world = world;
        this.profiler = world.field_72984_F;
        this.initialBrightenings = new DeduplicatedLongQueue(16384);
        this.initialDarkenings = new DeduplicatedLongQueue(16384);
        for (i = 0; i < EnumSkyBlock.values().length; ++i) {
            this.lightUpdateQueues[i] = new DeduplicatedLongQueue(16384);
        }
        for (i = 0; i < this.darkeningQueues.length; ++i) {
            this.darkeningQueues[i] = new DeduplicatedLongQueue(16384);
        }
        for (i = 0; i < this.brighteningQueues.length; ++i) {
            this.brighteningQueues[i] = new DeduplicatedLongQueue(16384);
        }
        for (i = 0; i < this.neighborInfos.length; ++i) {
            this.neighborInfos[i] = new NeighborInfo();
        }
    }

    public void scheduleLightUpdate(EnumSkyBlock lightType, BlockPos pos) {
        this.lock();
        try {
            this.scheduleLightUpdate(lightType, LightingEngine.encodeWorldCoord(pos));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void scheduleLightUpdate(EnumSkyBlock lightType, long blockPos) {
        this.lightUpdateQueues[lightType.ordinal()].enqueue(blockPos);
    }

    public void processLightUpdates() {
        this.profiler.func_76320_a("processSky");
        this.processLightUpdatesForType(EnumSkyBlock.SKY);
        this.profiler.func_76318_c("processBlock");
        this.processLightUpdatesForType(EnumSkyBlock.BLOCK);
        this.profiler.func_76319_b();
    }

    public void processLightUpdatesForType(EnumSkyBlock lightType) {
        if (this.world.field_72995_K && !this.isCallingFromMainThread()) {
            return;
        }
        DeduplicatedLongQueue queue = this.lightUpdateQueues[lightType.ordinal()];
        if (queue.isEmpty()) {
            return;
        }
        this.profiler.func_76320_a("process");
        this.lock();
        try {
            this.processLightUpdatesForTypeInner(lightType, queue);
        }
        finally {
            this.lock.unlock();
        }
        this.profiler.func_76319_b();
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isCallingFromMainThread() {
        return Minecraft.func_71410_x().func_152345_ab();
    }

    private void lock() {
        if (this.lock.tryLock()) {
            return;
        }
        Thread current = Thread.currentThread();
        if (current != this.ownerThread) {
            IllegalAccessException illegalAccessException = new IllegalAccessException(String.format("World is owned by '%s' (ID: %s), but was accessed from thread '%s' (ID: %s)", this.ownerThread.getName(), this.ownerThread.getId(), current.getName(), current.getId()));
            ProjectConstants.LOGGER.warn("Something (likely another mod) has attempted to modify the world's state from the wrong thread!\nThis is *bad practice* and can cause severe issues in your game.\nAlfheim has done as best as it can to mitigate this violation, but it may negatively impact performance or introduce stalls.\nIn a future release, this violation may result in a hard crash instead of the current soft warning.\n", (Throwable)illegalAccessException);
        }
        this.lock.lock();
    }

    private void processLightUpdatesForTypeInner(EnumSkyBlock lightType, DeduplicatedLongQueue queue) {
        byte oldLight;
        if (this.updating) {
            throw new IllegalStateException("Already processing updates!");
        }
        this.updating = true;
        this.currentChunkIdentifier = -1L;
        this.currentQueue = queue;
        if (this.currentQueue != null) {
            this.currentQueue.clearSet();
        }
        this.profiler.func_76320_a("prepare");
        while (this.nextItem()) {
            byte newLight;
            if (this.currentChunk == null) continue;
            oldLight = this.getCursorCachedLight(lightType);
            if (oldLight < (newLight = this.calculateNewLightFromCursor(lightType))) {
                this.initialBrightenings.enqueue((long)newLight << 60 | this.currentData);
                continue;
            }
            if (oldLight <= newLight) continue;
            this.initialDarkenings.enqueue(this.currentData);
        }
        this.profiler.func_76318_c("enqueueBrightening");
        this.currentQueue = this.initialBrightenings;
        if (this.currentQueue != null) {
            this.currentQueue.clearSet();
        }
        while (this.nextItem()) {
            byte newLight = (byte)(this.currentData >> 60 & 0xFL);
            if (newLight <= this.getCursorCachedLight(lightType)) continue;
            this.enqueueBrightening((BlockPos)this.currentPos, this.currentData & 0xFFFFFFFFFFFFFFFL, newLight, this.currentChunk, lightType);
        }
        this.profiler.func_76318_c("enqueueDarkening");
        this.currentQueue = this.initialDarkenings;
        if (this.currentQueue != null) {
            this.currentQueue.clearSet();
        }
        while (this.nextItem()) {
            oldLight = this.getCursorCachedLight(lightType);
            if (oldLight == 0) continue;
            this.enqueueDarkening((BlockPos)this.currentPos, this.currentData, oldLight, this.currentChunk, lightType);
        }
        this.profiler.func_76318_c("process");
        for (byte currentLight = 15; currentLight >= 0; currentLight = (byte)(currentLight - 1)) {
            this.currentQueue = this.darkeningQueues[currentLight];
            if (this.currentQueue != null) {
                this.currentQueue.clearSet();
            }
            while (this.nextItem()) {
                byte luminosity;
                if (this.getCursorCachedLight(lightType) >= currentLight) continue;
                IBlockState blockState = this.currentChunk.func_177435_g((BlockPos)this.currentPos);
                byte opacity = (luminosity = this.getCursorLuminosity(blockState, lightType)) >= 14 ? (byte)1 : this.getPosOpacity((BlockPos)this.currentPos, blockState);
                if (this.calculateNewLightFromCursor(luminosity, opacity, lightType) < currentLight) {
                    byte newLight = luminosity;
                    this.fetchNeighborDataFromCursor(lightType);
                    for (NeighborInfo neighborInfo : this.neighborInfos) {
                        byte neighborLight;
                        Chunk neighborChunk = neighborInfo.chunk;
                        if (neighborChunk == null || (neighborLight = neighborInfo.light) == 0) continue;
                        BlockPos.MutableBlockPos neighborPos = neighborInfo.mutableBlockPos;
                        if (currentLight - this.getPosOpacity((BlockPos)neighborPos, neighborChunk.func_177435_g((BlockPos)neighborPos)) >= neighborLight) {
                            this.enqueueDarkening((BlockPos)neighborPos, neighborInfo.key, neighborLight, neighborChunk, lightType);
                            continue;
                        }
                        newLight = (byte)Math.max(newLight, neighborLight - opacity);
                    }
                    this.enqueueBrighteningFromCursor(newLight, lightType);
                    continue;
                }
                this.enqueueBrighteningFromCursor(currentLight, lightType);
            }
            this.currentQueue = this.brighteningQueues[currentLight];
            if (this.currentQueue != null) {
                this.currentQueue.clearSet();
            }
            while (this.nextItem()) {
                byte oldLight2 = this.getCursorCachedLight(lightType);
                if (oldLight2 != currentLight) continue;
                this.world.func_175679_n((BlockPos)this.currentPos);
                if (currentLight <= 1) continue;
                this.spreadLightFromCursor(currentLight, lightType);
            }
        }
        this.profiler.func_76319_b();
        this.updating = false;
    }

    private void fetchNeighborDataFromCursor(EnumSkyBlock lightType) {
        if (this.isNeighborDataValid) {
            return;
        }
        this.isNeighborDataValid = true;
        for (int i = 0; i < this.neighborInfos.length; ++i) {
            NeighborInfo neighborInfo = this.neighborInfos[i];
            neighborInfo.key = this.currentData + neighborShifts[i];
            long neighborLongPos = neighborInfo.key;
            if ((neighborLongPos & 0x1000000000000000L) != 0L) {
                neighborInfo.chunk = null;
                continue;
            }
            BlockPos.MutableBlockPos neighborPos = LightingEngine.decodeWorldCoord(neighborInfo.mutableBlockPos, neighborLongPos);
            Chunk neighborChunk = (neighborLongPos & 0xFFFFFC3FFFFF0L) == this.currentChunkIdentifier ? (neighborInfo.chunk = this.currentChunk) : (neighborInfo.chunk = this.getChunk((BlockPos)neighborPos));
            if (neighborChunk == null) continue;
            ExtendedBlockStorage neighborSection = neighborChunk.func_76587_i()[neighborPos.func_177956_o() >> 4];
            neighborInfo.light = LightingEngine.getCachedLightFor(neighborChunk, neighborSection, (BlockPos)neighborPos, lightType);
        }
    }

    private static byte getCachedLightFor(Chunk chunk, ExtendedBlockStorage storage, BlockPos blockPos, EnumSkyBlock type) {
        int x = blockPos.func_177958_n() & 0xF;
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p() & 0xF;
        if (storage == Chunk.field_186036_a) {
            return type == EnumSkyBlock.SKY && chunk.func_177444_d(blockPos) ? (byte)type.field_77198_c : (byte)0;
        }
        if (type == EnumSkyBlock.SKY) {
            return chunk.func_177412_p().field_73011_w.func_191066_m() ? (byte)storage.func_76670_c(x, y & 0xF, z) : (byte)0;
        }
        return type == EnumSkyBlock.BLOCK ? (byte)storage.func_76674_d(x, y & 0xF, z) : (byte)type.field_77198_c;
    }

    private byte calculateNewLightFromCursor(EnumSkyBlock lightType) {
        IBlockState blockState = this.currentChunk.func_177435_g((BlockPos)this.currentPos);
        byte luminosity = this.getCursorLuminosity(blockState, lightType);
        byte opacity = luminosity >= 14 ? (byte)1 : this.getPosOpacity((BlockPos)this.currentPos, blockState);
        return this.calculateNewLightFromCursor(luminosity, opacity, lightType);
    }

    private byte calculateNewLightFromCursor(byte luminosity, byte opacity, EnumSkyBlock lightType) {
        if (luminosity >= 15 - opacity) {
            return luminosity;
        }
        byte newLight = luminosity;
        this.fetchNeighborDataFromCursor(lightType);
        for (NeighborInfo neighborInfo : this.neighborInfos) {
            if (neighborInfo.chunk == null) continue;
            newLight = (byte)Math.max(neighborInfo.light - opacity, newLight);
        }
        return newLight;
    }

    private void spreadLightFromCursor(byte currentLight, EnumSkyBlock lightType) {
        this.fetchNeighborDataFromCursor(lightType);
        for (NeighborInfo neighborInfo : this.neighborInfos) {
            BlockPos.MutableBlockPos neighborBlockPos;
            byte newLight;
            Chunk neighborChunk = neighborInfo.chunk;
            if (neighborChunk == null || currentLight < neighborInfo.light || (newLight = (byte)(currentLight - this.getPosOpacity((BlockPos)(neighborBlockPos = neighborInfo.mutableBlockPos), neighborChunk.func_177435_g((BlockPos)neighborBlockPos)))) <= neighborInfo.light) continue;
            this.enqueueBrightening((BlockPos)neighborBlockPos, neighborInfo.key, newLight, neighborChunk, lightType);
        }
    }

    private void enqueueBrighteningFromCursor(byte newLight, EnumSkyBlock lightType) {
        this.enqueueBrightening((BlockPos)this.currentPos, this.currentData, newLight, this.currentChunk, lightType);
    }

    private void enqueueBrightening(BlockPos blockPos, long longPos, byte newLight, Chunk chunk, EnumSkyBlock lightType) {
        this.brighteningQueues[newLight].enqueue(longPos);
        chunk.func_177431_a(lightType, blockPos, (int)newLight);
    }

    private void enqueueDarkening(BlockPos blockPos, long longPos, byte oldLight, Chunk chunk, EnumSkyBlock lightType) {
        this.darkeningQueues[oldLight].enqueue(longPos);
        chunk.func_177431_a(lightType, blockPos, 0);
    }

    private static BlockPos.MutableBlockPos decodeWorldCoord(BlockPos.MutableBlockPos mutableBlockPos, long longPos) {
        return mutableBlockPos.func_181079_c((int)(longPos >> 26 & 0x3FFFFFFL) - 0x2000000, (int)(longPos >> 52 & 0xFFL), (int)(longPos >> 0 & 0x3FFFFFFL) - 0x2000000);
    }

    private static long encodeWorldCoord(BlockPos pos) {
        return (long)pos.func_177956_o() << 52 | (long)pos.func_177958_n() + 0x2000000L << 26 | (long)pos.func_177952_p() + 0x2000000L << 0;
    }

    private boolean nextItem() {
        if (this.currentQueue.isEmpty()) {
            this.currentQueue = null;
            return false;
        }
        this.currentData = this.currentQueue.dequeue();
        this.isNeighborDataValid = false;
        LightingEngine.decodeWorldCoord(this.currentPos, this.currentData);
        long chunkIdentifier = this.currentData & 0xFFFFFC3FFFFF0L;
        if (this.currentChunkIdentifier != chunkIdentifier) {
            this.currentChunk = this.getChunk((BlockPos)this.currentPos);
            this.currentChunkIdentifier = chunkIdentifier;
        }
        return true;
    }

    private byte getCursorCachedLight(EnumSkyBlock lightType) {
        return ((IChunkLightingData)this.currentChunk).alfheim$getCachedLightFor(lightType, (BlockPos)this.currentPos);
    }

    private byte getCursorLuminosity(IBlockState state, EnumSkyBlock lightType) {
        if (lightType == EnumSkyBlock.SKY) {
            if (this.currentChunk.func_177444_d((BlockPos)this.currentPos)) {
                return (byte)EnumSkyBlock.SKY.field_77198_c;
            }
            return 0;
        }
        return (byte)ClampUtil.clampMinFirst((int)LightUtil.getLightValueForState(state, (IBlockAccess)this.world, (BlockPos)this.currentPos), (int)0, (int)15);
    }

    private byte getPosOpacity(BlockPos blockPos, IBlockState blockState) {
        return (byte)ClampUtil.clampMinFirst((int)blockState.getLightOpacity((IBlockAccess)this.world, blockPos), (int)1, (int)15);
    }

    private Chunk getChunk(BlockPos blockPos) {
        return this.world.func_72863_F().func_186026_b(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
    }

    static {
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            Vec3i offset = EnumFacing.field_82609_l[i].func_176730_m();
            LightingEngine.neighborShifts[i] = (long)offset.func_177956_o() << 52 | (long)offset.func_177958_n() << 26 | (long)offset.func_177952_p() << 0;
        }
    }

    private static final class NeighborInfo {
        public final BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        public Chunk chunk;
        public byte light;
        public long key;

        private NeighborInfo() {
        }
    }
}

